/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.kit;

import com.devexperts.qd.SerialFieldType;
import com.devexperts.qd.kit.CompactIntField;
import com.devexperts.qd.util.ShortString;

public class ShortStringField
extends CompactIntField {
    public ShortStringField(int index, String name) {
        this(index, name, SerialFieldType.SHORT_STRING.forNamedField(name));
    }

    public ShortStringField(int index, String name, SerialFieldType serialType) {
        super(index, name, serialType);
        if (!serialType.hasSameRepresentationAs(SerialFieldType.SHORT_STRING)) {
            throw new IllegalArgumentException("Invalid serialType: " + serialType);
        }
    }

    @Override
    public String toString(int value) {
        return ShortString.decode(value);
    }

    @Override
    public int parseString(String value) {
        return (int)ShortString.encode(value);
    }

    @Override
    public double toDouble(int value) {
        return Double.NaN;
    }
}

