/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.kit;

import com.devexperts.qd.SerialFieldType;
import com.devexperts.qd.kit.CompactIntField;

public class SequenceField
extends CompactIntField {
    private static final int MILLIS_SHIFT = 22;
    private static final int SEQUENCE_MASK = 0x3FFFFF;

    public SequenceField(int index, String name) {
        this(index, name, SerialFieldType.SEQUENCE.forNamedField(name));
    }

    public SequenceField(int index, String name, SerialFieldType serialType) {
        super(index, name, serialType);
        if (!serialType.hasSameRepresentationAs(SerialFieldType.SEQUENCE)) {
            throw new IllegalArgumentException("Invalid serialType: " + serialType);
        }
    }

    @Override
    public String toString(int value) {
        if (value == 0) {
            return "0";
        }
        int millis = value >>> 22;
        return millis != 0 ? millis + ":" + (value & 0x3FFFFF) : Integer.toString(value);
    }

    @Override
    public int parseString(String value) {
        int i = value.indexOf(58);
        return i >= 0 ? (Integer.parseInt(value.substring(0, i)) << 22) + Integer.parseInt(value.substring(i + 1)) : Integer.parseInt(value);
    }
}

