/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.kit;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.DataScheme;
import com.devexperts.qd.QDContract;
import com.devexperts.qd.QDFilter;
import com.devexperts.qd.kit.CompositeFilters;
import com.devexperts.qd.kit.FastRecordFilter;
import com.devexperts.qd.kit.NotFilter;
import com.devexperts.qd.spi.QDFilterContext;
import com.devexperts.util.InvalidFormatException;

public abstract class RecordOnlyFilter
extends QDFilter {
    public static RecordOnlyFilter valueOf(String spec, DataScheme scheme) {
        if (spec.equals("*") || spec.equals("all")) {
            return new Anything(scheme);
        }
        QDFilter filter = CompositeFilters.getFactory(scheme).createFilter(spec, QDFilterContext.RECORD_ONLY);
        if (filter instanceof RecordOnlyFilter) {
            return (RecordOnlyFilter)filter;
        }
        throw new InvalidFormatException("\"" + spec + "\" does not specify a list of records");
    }

    protected RecordOnlyFilter(DataScheme scheme) {
        super(scheme);
        if (scheme == null) {
            throw new NullPointerException("scheme must be specified for record filter");
        }
    }

    @Override
    public final boolean accept(QDContract contract, DataRecord record, int cipher, String symbol) {
        return this.acceptRecord(record);
    }

    public abstract boolean acceptRecord(DataRecord var1);

    @Override
    public final QDFilter.Kind getKind() {
        return QDFilter.Kind.RECORD_ONLY;
    }

    @Override
    public QDFilter negate() {
        return new FastRecordFilter(new NotFilter(this.unwrap()), true);
    }

    @Override
    public final boolean isStable() {
        return true;
    }

    @Override
    public final boolean isDynamic() {
        return false;
    }

    @Override
    public final boolean isFast() {
        return true;
    }

    @Override
    public final QDFilter toStableFilter() {
        return this;
    }

    private static class Anything
    extends RecordOnlyFilter {
        private Anything(DataScheme scheme) {
            super(scheme);
        }

        @Override
        public boolean acceptRecord(DataRecord record) {
            return true;
        }

        @Override
        public String toString() {
            return ":*";
        }
    }
}

