/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.kit;

import com.devexperts.qd.QDLog;
import com.devexperts.qd.kit.DefaultRecord;
import com.devexperts.qd.ng.RecordMapping;
import com.devexperts.qd.ng.RecordMappingFactory;
import com.devexperts.services.Services;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

class RecordMappingFactoryHolder {
    private static final List<RecordMappingFactory> RECORD_MAPPING_FACTORIES = new ArrayList<RecordMappingFactory>();

    RecordMappingFactoryHolder() {
    }

    static LinkedHashMap<Class<? extends RecordMapping>, RecordMapping> createMapping(DefaultRecord record) {
        LinkedHashMap<Class<? extends RecordMapping>, RecordMapping> mappings = new LinkedHashMap<Class<? extends RecordMapping>, RecordMapping>();
        for (RecordMappingFactory factory : RECORD_MAPPING_FACTORIES) {
            RecordMapping mapping = RecordMappingFactoryHolder.createMapping(factory, record);
            if (mapping == null) continue;
            mappings.put(mapping.getClass(), mapping);
        }
        return mappings;
    }

    private static RecordMapping createMapping(RecordMappingFactory factory, DefaultRecord record) {
        RecordMapping mapping = null;
        try {
            mapping = factory.createMapping(record);
        }
        catch (IllegalArgumentException e) {
            QDLog.log.warn("Invalid record " + record.getName() + ": " + e.getMessage());
        }
        if (mapping != null) {
            if (mapping.getRecord() != record) {
                throw new IllegalArgumentException("Created mapping " + mapping + " uses record " + mapping.getRecord() + " instead of record " + record);
            }
            return mapping;
        }
        return null;
    }

    static {
        for (RecordMappingFactory factory : Services.createServices(RecordMappingFactory.class, null)) {
            RECORD_MAPPING_FACTORIES.add(factory);
        }
    }
}

