/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.kit;

import com.devexperts.io.BufferedInput;
import com.devexperts.io.BufferedOutput;
import com.devexperts.io.IOUtil;
import com.devexperts.qd.SymbolCodec;
import com.devexperts.qd.qtp.ProtocolOption;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UTFDataFormatException;

public final class PentaCodec
implements SymbolCodec {
    public static final PentaCodec INSTANCE;
    private static final int[] PENTA;
    private static final int[] PLEN;
    private static final char[] CHAR;
    private static final int MRU_EVENT_FLAGS = 1;
    private final int wildcardCipher = this.encode("*");

    private static int encodePenta(long penta, int plen) {
        if (plen <= 30) {
            return (int)penta + 0x40000000;
        }
        int c = (int)(penta >>> 30);
        if (c == PENTA[47]) {
            return ((int)penta & 0x3FFFFFFF) + Integer.MIN_VALUE;
        }
        if (c == PENTA[36]) {
            return ((int)penta & 0x3FFFFFFF) + -1073741824;
        }
        return 0;
    }

    private static long decodeCipher(int cipher) {
        switch (cipher >>> 30) {
            case 0: {
                throw new IllegalArgumentException("Unknown or reserved cipher.");
            }
            case 1: {
                return cipher & 0x3FFFFFFF;
            }
            case 2: {
                return ((long)PENTA[47] << 30) + (long)(cipher & 0x3FFFFFFF);
            }
            case 3: {
                return ((long)PENTA[36] << 30) + (long)(cipher & 0x3FFFFFFF);
            }
        }
        throw new InternalError("'int' has more than 32 bits.");
    }

    private static String pentaToString(long penta) {
        int plen = 0;
        while (penta >>> plen != 0L) {
            plen += 5;
        }
        char[] chars = new char[plen / 5];
        int length = 0;
        while (plen > 0) {
            int code = (int)(penta >>> (plen -= 5)) & 0x1F;
            if (code >= 30 && plen > 0) {
                code = (int)(penta >>> (plen -= 5)) & 0x3FF;
            }
            chars[length++] = CHAR[code];
        }
        return new String(chars, 0, length);
    }

    private int getChartAt(long penta, int i) {
        int plen = 0;
        while (penta >>> plen != 0L) {
            plen += 5;
        }
        while (i >= 0 && plen > 0) {
            int code = (int)(penta >>> (plen -= 5)) & 0x1F;
            if (code >= 30 && plen > 0) {
                code = (int)(penta >>> (plen -= 5)) & 0x3FF;
            }
            if (i == 0) {
                return CHAR[code];
            }
            --i;
        }
        return -1;
    }

    @Override
    public int encode(String symbol) {
        if (symbol == null) {
            return 0;
        }
        int length = symbol.length();
        if (length > 7) {
            return 0;
        }
        long penta = 0L;
        int plen = 0;
        for (int i = 0; i < length; ++i) {
            char c = symbol.charAt(i);
            if (c >= '\u0080') {
                return 0;
            }
            int l = PLEN[c];
            penta = (penta << l) + (long)PENTA[c];
            plen += l;
        }
        if (plen > 35) {
            return 0;
        }
        return PentaCodec.encodePenta(penta, plen);
    }

    @Override
    public int encode(char[] chars, int offset, int length) {
        if ((offset | length | offset + length | chars.length - (offset + length)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (length > 7) {
            return 0;
        }
        long penta = 0L;
        int plen = 0;
        length += offset;
        while (offset < length) {
            char c = chars[offset];
            if (c >= '\u0080') {
                return 0;
            }
            int l = PLEN[c];
            penta = (penta << l) + (long)PENTA[c];
            plen += l;
            ++offset;
        }
        if (plen > 35) {
            return 0;
        }
        return PentaCodec.encodePenta(penta, plen);
    }

    @Override
    public String decode(int cipher) {
        if (cipher == 0) {
            return null;
        }
        return PentaCodec.pentaToString(PentaCodec.decodeCipher(cipher));
    }

    @Override
    public String decode(int cipher, String symbol) {
        return symbol != null ? symbol : this.decode(cipher);
    }

    @Override
    public long decodeToLong(int cipher) {
        if (cipher == 0) {
            return 0L;
        }
        long penta = PentaCodec.decodeCipher(cipher);
        int plen = 0;
        while (penta >>> plen != 0L) {
            plen += 5;
        }
        long result = 0L;
        int shift = 64;
        while (plen > 0) {
            int code = (int)(penta >>> (plen -= 5)) & 0x1F;
            if (code >= 30 && plen > 0) {
                code = (int)(penta >>> (plen -= 5)) & 0x3FF;
            }
            result = result << 8 | (long)CHAR[code];
            shift -= 8;
        }
        return result << shift;
    }

    @Override
    public int decodeCharAt(int cipher, int i) {
        if (i < 0) {
            throw new IllegalArgumentException("Negative index");
        }
        if (cipher == 0) {
            return -1;
        }
        return this.getChartAt(PentaCodec.decodeCipher(cipher), i);
    }

    @Override
    public int hashCode(int cipher) {
        if (cipher == 0) {
            return 0;
        }
        long penta = PentaCodec.decodeCipher(cipher);
        int plen = 0;
        while (penta >>> plen != 0L) {
            plen += 5;
        }
        int hash = 0;
        while (plen > 0) {
            int code = (int)(penta >>> (plen -= 5)) & 0x1F;
            if (code >= 30 && plen > 0) {
                code = (int)(penta >>> (plen -= 5)) & 0x3FF;
            }
            hash = 31 * hash + CHAR[code];
        }
        return hash;
    }

    @Override
    public int getWildcardCipher() {
        return this.wildcardCipher;
    }

    @Override
    public SymbolCodec.Reader createReader() {
        return new ReaderImpl();
    }

    @Override
    public SymbolCodec.Writer createWriter() {
        return new WriterImpl();
    }

    private static void initPenta(char c, int penta, int plen) {
        PentaCodec.PENTA[c] = penta;
        PentaCodec.PLEN[c] = plen;
        PentaCodec.CHAR[penta] = c;
    }

    static {
        PENTA = new int[128];
        PLEN = new int[128];
        CHAR = new char[1024];
        int i = PLEN.length;
        while (--i >= 0) {
            PentaCodec.PLEN[i] = 64;
        }
        for (i = 65; i <= 90; ++i) {
            PentaCodec.initPenta((char)i, i - 65 + 1, 5);
        }
        PentaCodec.initPenta('.', 27, 5);
        PentaCodec.initPenta('/', 28, 5);
        PentaCodec.initPenta('$', 29, 5);
        int penta = 960;
        for (int i2 = 32; i2 <= 126; ++i2) {
            if (PENTA[i2] != 0 || i2 == 39 || i2 == 96) continue;
            PentaCodec.initPenta((char)i2, penta++, 10);
        }
        if (penta != 1024) {
            throw new InternalError("Number of pentas is incorrect.");
        }
        INSTANCE = new PentaCodec();
    }

    private static class WriterImpl
    extends SymbolCodec.Writer {
        private int lastCipher;
        private String lastSymbol;
        private int mruEventFlags = 1;

        private WriterImpl() {
        }

        @Override
        public void reset(ProtocolOption.Set optSet) {
            this.lastCipher = 0;
            this.lastSymbol = null;
            this.mruEventFlags = 1;
        }

        @Override
        public void writeSymbol(BufferedOutput out, int cipher, String symbol, int eventFlags) throws IOException {
            if (cipher == 0 && symbol == null) {
                throw new IllegalArgumentException();
            }
            if (eventFlags != 0) {
                if (eventFlags == this.mruEventFlags) {
                    out.writeByte(248);
                } else {
                    out.writeByte(249);
                    out.writeCompactInt(eventFlags);
                    this.mruEventFlags = eventFlags;
                }
            }
            if (cipher == this.lastCipher && (cipher != 0 || symbol.equals(this.lastSymbol))) {
                out.writeByte(255);
                return;
            }
            if (cipher != 0) {
                long penta = PentaCodec.decodeCipher(cipher);
                if (penta == 0L) {
                    out.writeByte(254);
                } else if (penta < 32768L) {
                    out.writeShort((int)penta);
                } else if (penta < 0x100000L) {
                    out.writeByte(0xE0 | (int)penta >>> 16);
                    out.writeShort((int)penta);
                } else if (penta < 0x40000000L) {
                    out.writeInt(Integer.MIN_VALUE | (int)penta);
                } else if (penta < 0x800000000L) {
                    out.writeByte(0xF0 | (int)(penta >>> 32));
                    out.writeInt((int)penta);
                } else {
                    throw new IOException("Penta has more than 35 bits");
                }
                this.lastCipher = cipher;
                this.lastSymbol = null;
            } else {
                out.writeByte(253);
                IOUtil.writeCharArray((DataOutput)out, symbol);
                this.lastCipher = 0;
                this.lastSymbol = symbol;
            }
        }
    }

    private static class ReaderImpl
    extends SymbolCodec.Reader {
        private int mruEventFlags = 1;
        private final char[] buffer = new char[64];

        private ReaderImpl() {
        }

        @Override
        public void reset(ProtocolOption.Set optSet) {
            this.cipher = 0;
            this.symbol = null;
            this.eventFlags = 0;
            this.mruEventFlags = 1;
        }

        @Override
        public void readSymbol(BufferedInput in, SymbolCodec.Resolver resolver) throws IOException {
            long penta;
            block16: {
                int i;
                this.eventFlags = 0;
                this.eventFlagsBytes = 0;
                while (true) {
                    if ((i = in.readUnsignedByte()) < 128) {
                        penta = (i << 8) + in.readUnsignedByte();
                        break block16;
                    }
                    if (i < 192) {
                        penta = ((i & 0x3F) << 24) + (in.readUnsignedByte() << 16) + in.readUnsignedShort();
                        break block16;
                    }
                    if (i < 224) {
                        throw new IOException("Reserved bit sequence");
                    }
                    if (i < 240) {
                        penta = ((i & 0xF) << 16) + in.readUnsignedShort();
                        break block16;
                    }
                    if (i < 248) {
                        penta = ((long)(i & 7) << 32) + ((long)in.readInt() & 0xFFFFFFFFL);
                        break block16;
                    }
                    if (i == 248) {
                        if (this.eventFlagsBytes > 0) {
                            throw new IOException("Duplicated event flags prefix");
                        }
                        this.eventFlags = this.mruEventFlags;
                        this.eventFlagsBytes = 1;
                        continue;
                    }
                    if (i != 249) break;
                    if (this.eventFlagsBytes > 0) {
                        throw new IOException("Duplicated event flags prefix");
                    }
                    long eventFlagsPosition = in.totalPosition();
                    this.eventFlags = this.mruEventFlags = in.readCompactInt();
                    this.eventFlagsBytes = (int)(in.totalPosition() - eventFlagsPosition);
                }
                if (i < 252) {
                    throw new IOException("Reserved bit sequence");
                }
                if (i == 252) {
                    this.readUTF(in, resolver);
                    return;
                }
                if (i == 253) {
                    this.readCESU(in, resolver);
                    return;
                }
                if (i == 254) {
                    penta = 0L;
                } else {
                    if (this.cipher == 0 && this.symbol == null) {
                        throw new IOException("Symbol is undefined");
                    }
                    return;
                }
            }
            int plen = 0;
            while (penta >>> plen != 0L) {
                plen += 5;
            }
            this.cipher = PentaCodec.encodePenta(penta, plen);
            this.symbol = this.cipher == 0 ? PentaCodec.pentaToString(penta) : null;
        }

        private void readUTF(BufferedInput in, SymbolCodec.Resolver resolver) throws IOException {
            long longUtfLength = in.readCompactLong();
            if (longUtfLength < 0L || longUtfLength > Integer.MAX_VALUE) {
                throw new IOException("Illegal length");
            }
            int utfLength = (int)longUtfLength;
            char[] chars = utfLength <= this.buffer.length ? this.buffer : new char[utfLength];
            this.resolve(chars, in.readUTFBody(utfLength, chars, 0), resolver);
        }

        private void readCESU(BufferedInput in, SymbolCodec.Resolver resolver) throws IOException {
            long longLength = in.readCompactLong();
            if (longLength < 0L || longLength > Integer.MAX_VALUE) {
                throw new IOException("Illegal length");
            }
            int length = (int)longLength;
            char[] chars = length <= this.buffer.length ? this.buffer : new char[length];
            for (int k = 0; k < length; ++k) {
                int codePoint = in.readUTFChar();
                if (codePoint > 65535) {
                    throw new UTFDataFormatException("Code point is beyond BMP");
                }
                chars[k] = (char)codePoint;
            }
            this.resolve(chars, length, resolver);
        }

        private void resolve(char[] chars, int length, SymbolCodec.Resolver resolver) {
            this.cipher = 0;
            if (resolver != null) {
                this.symbol = resolver.getSymbol(chars, 0, length);
                if (this.symbol != null) {
                    return;
                }
            }
            this.symbol = length == 0 ? "" : new String(chars, 0, length);
        }
    }
}

