/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.kit;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.DataScheme;
import com.devexperts.qd.QDContract;
import com.devexperts.qd.QDFilter;
import com.devexperts.qd.SubscriptionFilter;
import com.devexperts.qd.kit.FilterSyntaxException;
import com.devexperts.qd.kit.RecordOnlyFilter;
import com.devexperts.qd.util.SymbolSet;
import com.devexperts.util.LongHashSet;
import com.devexperts.util.SystemProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

public final class PatternFilter
extends QDFilter {
    private static final int MAX_SYMBOL_SET_SIZE = SystemProperties.getIntProperty(PatternFilter.class, "maxSymbolSetSize", 10000);
    private static final int MAX_MID_PATTERNS = SystemProperties.getIntProperty(PatternFilter.class, "maxMidPatterns", 1000);
    private static final int[] EMPTY_BITS = new int[0];
    private static final int N_CHARS_SHIFT = 7;
    private static final int MAX_CHAR = 127;
    public static final int BITS_CHAR_SHIFT = 5;
    public static final int BITS_CHAR_MASK = 31;
    private static final int BITS_LENGTH_SHIFT = 2;
    private final String pattern;
    private final boolean negated;
    private final boolean fixedLength;
    private final int[] prefixBits;
    private final int prefixLength;
    private final int[] midBits;
    private final int midLength;
    private final int rollingHashOutMultiplier;
    private final LongHashSet midPatternHashes;
    private final char[] bmMidPattern;
    private final int[] bmSkipArray;
    private final int[] suffixBits;
    private final int suffixLength;
    private final int symbolSetSize;
    private SymbolSet set;

    public static String quote(String string) throws FilterSyntaxException {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            PatternFilter.charRangeCheck(c);
            boolean quote = false;
            if (i == 0 && c >= 'a' && c <= 'z') {
                quote = true;
            }
            boolean quote_next = false;
            switch (c) {
                case ' ': 
                case '[': 
                case '\\': 
                case ']': {
                    quote_next = true;
                    break;
                }
                case '!': 
                case '\"': 
                case '&': 
                case '\'': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case ':': 
                case ';': 
                case '<': 
                case '>': 
                case '?': 
                case '`': 
                case '{': 
                case '|': 
                case '}': 
                case '~': {
                    quote = true;
                }
            }
            if (quote_next) {
                sb.append('\\').append(c);
                continue;
            }
            if (quote) {
                sb.append('[').append(c).append(']');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static SubscriptionFilter valueOf(String pattern, DataScheme scheme) throws FilterSyntaxException {
        QDFilter result = PatternFilter.valueOfImpl(pattern, pattern, scheme);
        return result == ANYTHING ? null : result;
    }

    public static QDFilter valueOf(String pattern, String name, DataScheme scheme) throws FilterSyntaxException {
        PatternFilter.checkShortName(name);
        return PatternFilter.valueOfImpl(pattern, name, scheme);
    }

    static QDFilter valueOfImpl(String pattern, String name, DataScheme scheme) throws FilterSyntaxException {
        if (pattern.isEmpty()) {
            return ANYTHING;
        }
        boolean record = pattern.startsWith(":");
        PatternFilter filter = new PatternFilter(record ? pattern.substring(1) : pattern, name, scheme);
        if (filter.isEverythingPattern()) {
            return ANYTHING;
        }
        if (filter.isNothingPattern()) {
            return NOTHING;
        }
        if (record) {
            return new RecordPatternFilter(scheme, name, filter);
        }
        return filter;
    }

    private PatternFilter(String pattern, String name, DataScheme scheme) throws FilterSyntaxException {
        super(scheme);
        if (!pattern.isEmpty() && pattern.charAt(0) >= 'a' && pattern.charAt(0) <= 'z') {
            throw new FilterSyntaxException("Patterns with the first lower-case letter are reserved for application-specific extensions. Check spelling of the pattern or use '[' and ']' to quote first characters if needed: \"" + pattern + "\"");
        }
        this.pattern = pattern;
        this.setName(name);
        this.negated = !pattern.isEmpty() && pattern.startsWith("!");
        int[] pos = new int[]{this.negated ? 1 : 0};
        this.prefixBits = PatternFilter.parse(pattern, pos);
        this.prefixLength = this.prefixBits.length >> 2;
        boolean bl = this.fixedLength = pos[0] == pattern.length();
        if (!this.fixedLength) {
            pos[0] = pos[0] + 1;
        }
        int[] nextBits = PatternFilter.parse(pattern, pos);
        if (pos[0] < pattern.length()) {
            if (pattern.charAt(pos[0] - 1) == '*') {
                throw new FilterSyntaxException("Double '**' wild-card is not supported in pattern");
            }
            pos[0] = pos[0] + 1;
            this.suffixBits = PatternFilter.parse(pattern, pos);
            this.midBits = nextBits;
        } else {
            this.midBits = new int[0];
            this.suffixBits = nextBits;
        }
        this.midLength = this.midBits.length >> 2;
        int outMultiplier = 1;
        for (int i = 0; i < this.midLength; ++i) {
            outMultiplier *= 31;
        }
        this.rollingHashOutMultiplier = outMultiplier;
        this.suffixLength = this.suffixBits.length >> 2;
        if (pos[0] < pattern.length()) {
            throw new FilterSyntaxException("Third '*' wild-card is not supported in pattern");
        }
        List<char[]> midPatterns = this.generateMidPatterns();
        this.midPatternHashes = this.computeMidHashes(midPatterns);
        this.bmMidPattern = this.computeBoyerMoorePattern(midPatterns);
        this.bmSkipArray = this.computeBoyerMooreSkipArray();
        this.symbolSetSize = this.computeSymbolSetSize();
    }

    private PatternFilter(PatternFilter source, boolean forNegation) {
        super(source.getScheme());
        if (!forNegation) {
            throw new FilterSyntaxException("Allowed only for negate pattern construction");
        }
        this.pattern = this.negateName(source.pattern);
        this.negated = !source.negated;
        this.fixedLength = source.fixedLength;
        this.prefixBits = source.prefixBits;
        this.prefixLength = source.prefixLength;
        this.midBits = source.midBits;
        this.midLength = source.midLength;
        this.rollingHashOutMultiplier = source.rollingHashOutMultiplier;
        this.midPatternHashes = source.midPatternHashes;
        this.bmMidPattern = source.bmMidPattern;
        this.bmSkipArray = source.bmSkipArray;
        this.suffixBits = source.suffixBits;
        this.suffixLength = source.suffixLength;
        this.symbolSetSize = this.computeSymbolSetSize();
    }

    private int computeSymbolSetSize() {
        if (!this.fixedLength || this.negated) {
            return Integer.MAX_VALUE;
        }
        int symbolSetSize = 1;
        for (int i = 0; i < this.prefixLength; ++i) {
            if (PatternFilter.hasChar(this.prefixBits, i, 127)) {
                return Integer.MAX_VALUE;
            }
            int acceptCnt = 0;
            for (int c = 0; c < 127; ++c) {
                if (!PatternFilter.hasChar(this.prefixBits, i, c)) continue;
                ++acceptCnt;
            }
            if ((symbolSetSize *= acceptCnt) <= MAX_SYMBOL_SET_SIZE) continue;
            return Integer.MAX_VALUE;
        }
        return symbolSetSize;
    }

    private boolean isEverythingPattern() {
        return !this.fixedLength && !this.negated && this.prefixLength == 0 && this.midLength == 0 && this.suffixLength == 0;
    }

    private boolean isNothingPattern() {
        return !this.fixedLength && this.negated && this.prefixLength == 0 && this.midLength == 0 && this.suffixLength == 0;
    }

    @Override
    public QDFilter.Kind getKind() {
        return this.symbolSetSize <= MAX_SYMBOL_SET_SIZE ? QDFilter.Kind.SYMBOL_SET : QDFilter.Kind.PATTERN;
    }

    @Override
    public SymbolSet getSymbolSet() {
        if (this.symbolSetSize > MAX_SYMBOL_SET_SIZE) {
            return null;
        }
        SymbolSet symbolSet = this.set;
        if (symbolSet == null) {
            SymbolSet set = SymbolSet.createInstance();
            StringBuilder sb = new StringBuilder(this.prefixLength);
            sb.setLength(this.prefixLength);
            this.generateSet(set, sb, 0);
            this.set = symbolSet = set.unmodifiable();
        }
        return symbolSet;
    }

    private void generateSet(SymbolSet set, StringBuilder sb, int i) {
        if (i >= this.prefixLength) {
            String symbol = sb.toString();
            set.add(this.getScheme().getCodec().encode(symbol), symbol);
            return;
        }
        for (char c = '\u0000'; c < '\u007f'; c = (char)(c + 1)) {
            if (!PatternFilter.hasChar(this.prefixBits, i, c)) continue;
            sb.setCharAt(i, c);
            this.generateSet(set, sb, i + 1);
        }
    }

    @Override
    public QDFilter toStableFilter() {
        return this;
    }

    @Override
    public boolean isFast() {
        return true;
    }

    public String getPattern() {
        return this.pattern;
    }

    @Override
    public QDFilter negate() {
        PatternFilter filter = new PatternFilter(this, true);
        filter.setName(this.negateName(this.toString()));
        return filter;
    }

    @Nonnull
    private String negateName(String name) {
        return this.negated ? name.substring(1) : "!" + name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.pattern.equals(((PatternFilter)o).pattern);
    }

    public int hashCode() {
        return this.pattern.hashCode();
    }

    @Override
    public String getDefaultName() {
        return this.pattern;
    }

    private static int[] parse(String pattern, int[] pos) throws FilterSyntaxException {
        int i = pos[0];
        if (i >= pattern.length()) {
            return EMPTY_BITS;
        }
        int length = 0;
        int[] bits = new int[pattern.length() << 2];
        boolean block_quote = false;
        boolean escape_next = false;
        boolean char_class = false;
        boolean char_class_start = false;
        boolean char_class_range = false;
        boolean inverse = false;
        boolean next_char = false;
        int last_char = 0;
        block12: while (i < pattern.length()) {
            int d;
            boolean process_regular_char;
            int c = pattern.charAt(i);
            PatternFilter.charRangeCheck((char)c);
            if (block_quote) {
                if (c == 92 && i + 1 < pattern.length() && pattern.charAt(i + 1) == 'E') {
                    block_quote = false;
                    ++i;
                    process_regular_char = false;
                } else {
                    process_regular_char = true;
                }
            } else if (escape_next) {
                escape_next = false;
                switch (c) {
                    case 81: {
                        block_quote = true;
                        process_regular_char = false;
                        break;
                    }
                    default: {
                        process_regular_char = true;
                        break;
                    }
                }
            } else {
                process_regular_char = false;
                switch (c) {
                    case 91: {
                        if (char_class) {
                            throw new FilterSyntaxException("Illegal character inside char class '" + (char)c + "'");
                        }
                        char_class = true;
                        char_class_start = true;
                        break;
                    }
                    case 93: {
                        if (!char_class) {
                            throw new FilterSyntaxException("Illegal character outside char class '" + (char)c + "'");
                        }
                        if (char_class_range) {
                            throw new FilterSyntaxException("Not terminated char class range");
                        }
                        char_class = false;
                        next_char = true;
                        break;
                    }
                    case 94: {
                        if (char_class_start) {
                            char_class_start = false;
                            inverse = true;
                            break;
                        }
                        process_regular_char = true;
                        break;
                    }
                    case 45: {
                        if (char_class) {
                            if (char_class_range || last_char == 0) {
                                throw new FilterSyntaxException("Illegal usage of range '" + (char)c + "'");
                            }
                            char_class_range = true;
                            break;
                        }
                        process_regular_char = true;
                        break;
                    }
                    case 92: {
                        escape_next = true;
                        break;
                    }
                    case 42: {
                        if (!char_class) break block12;
                    }
                    case 33: 
                    case 34: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 41: 
                    case 43: 
                    case 60: 
                    case 62: 
                    case 63: 
                    case 96: 
                    case 124: 
                    case 126: {
                        if (!char_class) {
                            throw new FilterSyntaxException("Reserved character in pattern '" + (char)c + "'");
                        }
                        process_regular_char = true;
                        break;
                    }
                    default: {
                        process_regular_char = true;
                    }
                }
            }
            if (process_regular_char) {
                if (char_class_range) {
                    for (d = last_char; d <= c; ++d) {
                        PatternFilter.setChar(bits, length, d);
                    }
                    last_char = 0;
                } else {
                    PatternFilter.setChar(bits, length, c);
                    last_char = c;
                }
                char_class_start = false;
                char_class_range = false;
                if (!char_class) {
                    next_char = true;
                }
            }
            if (next_char) {
                if (inverse) {
                    for (d = 1; d <= 127; ++d) {
                        PatternFilter.invertChar(bits, length, d);
                    }
                    inverse = false;
                }
                ++length;
                next_char = false;
            }
            ++i;
        }
        if (block_quote) {
            throw new FilterSyntaxException("Block quote started with '\\Q' shall be terminated with '\\E'");
        }
        if (escape_next) {
            throw new FilterSyntaxException("Missing symbol after '\\' escape character");
        }
        if (char_class) {
            throw new FilterSyntaxException("Character class is not terminated with ']' character");
        }
        pos[0] = i;
        if (length == 0) {
            return EMPTY_BITS;
        }
        if (bits.length > length << 2) {
            bits = Arrays.copyOf(bits, length << 2);
        }
        return bits;
    }

    private static void charRangeCheck(char c) {
        if (c < ' ' || c >= '\u007f') {
            throw new FilterSyntaxException("Character is out of range '" + c + "'");
        }
    }

    @Override
    public boolean accept(QDContract contract, DataRecord record, int cipher, String symbol) {
        DataScheme scheme = this.getScheme();
        if (scheme == null) {
            scheme = record.getScheme();
        }
        if (cipher == scheme.getCodec().getWildcardCipher()) {
            return true;
        }
        if (symbol != null) {
            return this.negated ^ this.acceptString(symbol);
        }
        return this.negated ^ this.acceptCode(scheme.getCodec().decodeToLong(cipher));
    }

    private boolean acceptCode(long code) {
        for (int i = 0; i < this.prefixLength; ++i) {
            int c = PatternFilter.charAtCode(code, i);
            if (c != 0 && PatternFilter.hasChar(this.prefixBits, i, c)) continue;
            return false;
        }
        if (this.fixedLength && PatternFilter.charAtCode(code, this.prefixLength) != 0) {
            return false;
        }
        if (this.suffixLength + this.midLength > 0) {
            int sl;
            for (sl = this.prefixLength; sl < 8 && PatternFilter.charAtCode(code, sl) != 0; ++sl) {
            }
            if (sl < this.prefixLength + this.midLength + this.suffixLength) {
                return false;
            }
            for (int i = 0; i < this.suffixLength; ++i) {
                int c = PatternFilter.charAtCode(code, sl - 1 - i);
                if (PatternFilter.hasChar(this.suffixBits, this.suffixLength - 1 - i, c)) continue;
                return false;
            }
            if (this.midLength > 0) {
                return this.matchMid(code, sl);
            }
        }
        return true;
    }

    boolean acceptString(String symbol) {
        int c;
        int i;
        int sl = symbol.length();
        if (this.fixedLength && sl != this.prefixLength) {
            return false;
        }
        if (sl < this.prefixLength + this.midLength + this.suffixLength) {
            return false;
        }
        for (i = 0; i < this.prefixLength; ++i) {
            c = Math.min(127, symbol.charAt(i));
            if (PatternFilter.hasChar(this.prefixBits, i, c)) continue;
            return false;
        }
        for (i = 0; i < this.suffixLength; ++i) {
            c = Math.min(127, symbol.charAt(sl - 1 - i));
            if (PatternFilter.hasChar(this.suffixBits, this.suffixLength - 1 - i, c)) continue;
            return false;
        }
        if (this.midLength > 0) {
            return this.matchMid(symbol, sl);
        }
        return true;
    }

    private boolean matchMid(long code, int sl) {
        if (this.midLength == 1) {
            return this.matchSingleChar(code, sl);
        }
        if (this.bmMidPattern != null) {
            return this.matchBoyerMoore(code, sl);
        }
        return this.matchRabinCarp(code, sl);
    }

    private boolean matchMid(String symbol, int sl) {
        if (this.midLength == 1) {
            return this.matchSingleChar(symbol, sl);
        }
        if (this.bmMidPattern != null) {
            return this.matchBoyerMoore(symbol, sl);
        }
        return this.matchRabinKarp(symbol, sl);
    }

    private boolean matchSingleChar(long code, int sl) {
        for (int i = this.prefixLength; i < sl - this.suffixLength; ++i) {
            int c = PatternFilter.charAtCode(code, i);
            if (!PatternFilter.hasChar(this.midBits, 0, c)) continue;
            return true;
        }
        return false;
    }

    private boolean matchSingleChar(String symbol, int sl) {
        for (int i = this.prefixLength; i < sl - this.suffixLength; ++i) {
            int c = Math.min(127, symbol.charAt(i));
            if (!PatternFilter.hasChar(this.midBits, 0, c)) continue;
            return true;
        }
        return false;
    }

    private boolean matchBoyerMoore(long code, int sl) {
        int j;
        block0: for (int i = this.prefixLength; i <= sl - this.suffixLength - this.midLength; i += Math.max(1, j - this.bmSkipArray[PatternFilter.charAtCode(code, i + j)])) {
            for (j = this.midLength - 1; j >= 0; --j) {
                if (this.bmMidPattern[j] == PatternFilter.charAtCode(code, i + j)) continue;
                continue block0;
            }
            return true;
        }
        return false;
    }

    private boolean matchBoyerMoore(String symbol, int sl) {
        int c;
        int j;
        block0: for (int i = this.prefixLength; i <= sl - this.suffixLength - this.midLength; i += Math.max(1, j - this.bmSkipArray[c])) {
            for (j = this.midLength - 1; j >= 0; --j) {
                c = Math.min(127, symbol.charAt(i + j));
                if (this.bmMidPattern[j] == c) continue;
                continue block0;
            }
            return true;
        }
        return false;
    }

    private boolean matchRabinCarp(long code, int sl) {
        int hs = PatternFilter.hashCode(code, this.prefixLength, this.prefixLength + this.midLength);
        block0: for (int i = this.prefixLength; i <= sl - this.suffixLength - this.midLength; ++i) {
            if (i != this.prefixLength) {
                hs = PatternFilter.rollingHash(hs, code, i + this.midLength - 1, i - 1, this.rollingHashOutMultiplier);
            }
            if (!this.midPatternHashes.contains(hs)) continue;
            for (int j = 0; j < this.midLength; ++j) {
                if (!PatternFilter.hasChar(this.midBits, j, PatternFilter.charAtCode(code, i + j))) continue block0;
            }
            return true;
        }
        return false;
    }

    private boolean matchRabinKarp(String symbol, int sl) {
        int hs = PatternFilter.hashCode(symbol, this.prefixLength, this.prefixLength + this.midLength);
        block0: for (int i = this.prefixLength; i <= sl - this.suffixLength - this.midLength; ++i) {
            if (i != this.prefixLength) {
                hs = PatternFilter.rollingHash(hs, symbol, i + this.midLength - 1, i - 1, this.rollingHashOutMultiplier);
            }
            if (!this.midPatternHashes.contains(hs)) continue;
            for (int j = 0; j < this.midLength; ++j) {
                int c = Math.min(127, symbol.charAt(i + j));
                if (!PatternFilter.hasChar(this.midBits, j, c)) continue block0;
            }
            return true;
        }
        return false;
    }

    private List<char[]> generateMidPatterns() {
        if (this.midLength <= 1) {
            return Collections.emptyList();
        }
        ArrayList<char[]> patterns = new ArrayList<char[]>();
        for (int c = 0; c < 127; c = (int)((char)(c + 1))) {
            if (!PatternFilter.hasChar(this.midBits, 0, c)) continue;
            char[] p = new char[this.midLength];
            p[0] = c;
            patterns.add(p);
        }
        for (int i = 1; i < this.midLength; ++i) {
            int sbLength = patterns.size();
            int updates = 0;
            for (int c = 0; c < 127; c = (int)((char)(c + 1))) {
                if (!PatternFilter.hasChar(this.midBits, i, c)) continue;
                if (updates == 0) {
                    for (char[] p : patterns) {
                        p[i] = c;
                    }
                    ++updates;
                    continue;
                }
                for (int j = 0; j < sbLength; ++j) {
                    char[] p;
                    p = Arrays.copyOf((char[])patterns.get(j), this.midLength);
                    p[i] = c;
                    patterns.add(p);
                    if (patterns.size() <= MAX_MID_PATTERNS) continue;
                    throw new FilterSyntaxException("Too many middle patterns, max=" + MAX_MID_PATTERNS);
                }
            }
        }
        return patterns;
    }

    private LongHashSet computeMidHashes(List<char[]> patterns) {
        if (patterns.isEmpty()) {
            return null;
        }
        LongHashSet hashes = new LongHashSet(patterns.size());
        for (char[] p : patterns) {
            hashes.add(PatternFilter.hashCode(p));
        }
        return hashes;
    }

    private char[] computeBoyerMoorePattern(List<char[]> patterns) {
        if (patterns.size() != 1) {
            return null;
        }
        return Arrays.copyOf(patterns.get(0), this.midLength);
    }

    private int[] computeBoyerMooreSkipArray() {
        if (this.bmMidPattern == null) {
            return null;
        }
        int[] skipArray = new int[128];
        for (int i = 0; i < skipArray.length; ++i) {
            skipArray[i] = -1;
        }
        for (int j = 0; j < this.bmMidPattern.length; ++j) {
            skipArray[this.bmMidPattern[j]] = j;
        }
        return skipArray;
    }

    private static int charAtCode(long code, int i) {
        return (int)(code >>> (7 - i << 3) & 0xFFL);
    }

    private static boolean hasChar(int[] bits, int i, int c) {
        return (bits[(i << 2) + (c >> 5)] & 1 << (c & 0x1F)) != 0;
    }

    private static void setChar(int[] bits, int i, int c) {
        int n = (i << 2) + (c >> 5);
        bits[n] = bits[n] | 1 << (c & 0x1F);
    }

    private static void invertChar(int[] bits, int i, int c) {
        int n = (i << 2) + (c >> 5);
        bits[n] = bits[n] ^ 1 << (c & 0x1F);
    }

    private static int hashCode(char[] arr) {
        int result = 0;
        for (char c : arr) {
            result = 31 * result + c;
        }
        return result;
    }

    private static int hashCode(String s, int beginIndex, int endIndex) {
        int result = 0;
        for (int i = beginIndex; i < endIndex; ++i) {
            result = 31 * result + s.charAt(i);
        }
        return result;
    }

    private static int hashCode(long code, int beginIndex, int endIndex) {
        int result = 0;
        for (int i = beginIndex; i < endIndex; ++i) {
            result = 31 * result + PatternFilter.charAtCode(code, i);
        }
        return result;
    }

    private static int rollingHash(int hs, String s, int inIndex, int outIndex, int outMultiplier) {
        return 31 * hs + s.charAt(inIndex) - outMultiplier * s.charAt(outIndex);
    }

    private static int rollingHash(int hs, long code, int inIndex, int outIndex, int outMultiplier) {
        return 31 * hs + PatternFilter.charAtCode(code, inIndex) - outMultiplier * PatternFilter.charAtCode(code, outIndex);
    }

    public static final class RecordPatternFilter
    extends RecordOnlyFilter {
        private final String name;
        private final boolean[] accepts;

        RecordPatternFilter(DataScheme scheme, String name, PatternFilter filter) {
            super(scheme);
            this.name = name;
            this.accepts = new boolean[scheme.getRecordCount()];
            for (int i = 0; i < this.accepts.length; ++i) {
                this.accepts[i] = filter.acceptString(scheme.getRecord(i).getName());
            }
        }

        @Override
        public boolean acceptRecord(DataRecord record) {
            int id = record.getId();
            return id < this.accepts.length && this.accepts[id];
        }

        @Override
        public String toString() {
            return this.name;
        }
    }
}

