/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.kit;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.DataScheme;
import com.devexperts.qd.QDContract;
import com.devexperts.qd.QDFilter;

public class NotFilter
extends QDFilter
implements QDFilter.UpdateListener {
    QDFilter delegate;

    public NotFilter(QDFilter delegate) {
        this(delegate, null);
    }

    private NotFilter(QDFilter delegate, NotFilter source) {
        super(delegate.getScheme(), source);
        this.delegate = delegate;
    }

    @Override
    public QDFilter.Kind getKind() {
        QDFilter.Kind kind = this.delegate.getKind();
        if (kind.isRecordOnly()) {
            return QDFilter.Kind.RECORD_ONLY;
        }
        if (kind.isSymbolOnly()) {
            return QDFilter.Kind.OTHER_SYMBOL_ONLY;
        }
        return QDFilter.Kind.OTHER;
    }

    @Override
    public boolean accept(QDContract contract, DataRecord record, int cipher, String symbol) {
        DataScheme scheme = this.getScheme();
        if (scheme == null) {
            scheme = record.getScheme();
        }
        if (cipher == scheme.getCodec().getWildcardCipher()) {
            return true;
        }
        return !this.delegate.accept(contract, record, cipher, symbol);
    }

    @Override
    public QDFilter negate() {
        return this.delegate;
    }

    @Override
    public boolean isStable() {
        return this.delegate.isStable();
    }

    @Override
    public boolean isDynamic() {
        return this.delegate.isDynamic();
    }

    @Override
    public boolean isFast() {
        return this.delegate.isFast();
    }

    @Override
    public QDFilter toStableFilter() {
        return this.delegate.isStable() ? this : null;
    }

    @Override
    protected void dynamicTrackingStart() {
        this.delegate.addUpdateListener(this);
    }

    @Override
    protected void dynamicTrackingStop() {
        this.delegate.removeUpdateListener(this);
    }

    @Override
    protected QDFilter produceUpdatedFilter() {
        return new NotFilter(this.delegate.getUpdatedFilter(), this);
    }

    @Override
    public void filterUpdated(QDFilter filter) {
        this.fireFilterUpdated(null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.delegate.equals(((NotFilter)o).delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public String getDefaultName() {
        StringBuilder sb = new StringBuilder();
        QDFilter.SyntaxPrecedence precedence = this.delegate.getSyntaxPrecedence();
        boolean parenthesis = precedence == QDFilter.SyntaxPrecedence.AND || precedence == QDFilter.SyntaxPrecedence.OR;
        sb.append('!');
        if (parenthesis) {
            sb.append('(');
        }
        sb.append(this.delegate);
        if (parenthesis) {
            sb.append(')');
        }
        return sb.toString();
    }
}

