/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.kit;

import com.devexperts.io.BufferedInput;
import com.devexperts.io.BufferedOutput;
import com.devexperts.io.IOUtil;
import com.devexperts.io.Marshalled;
import com.devexperts.qd.SerialFieldType;
import com.devexperts.qd.kit.AbstractDataObjField;
import com.devexperts.util.Base64;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class MarshalledObjField
extends AbstractDataObjField {
    public MarshalledObjField(int index, String name) {
        super(index, name, SerialFieldType.SERIAL_OBJECT);
    }

    @Override
    public final void writeObj(DataOutput out, Object value) throws IOException {
        IOUtil.writeObject(out, value);
    }

    @Override
    public final void writeObj(BufferedOutput out, Object value) throws IOException {
        out.writeObject(value);
    }

    @Override
    public final Object readObj(DataInput in) throws IOException {
        return Marshalled.forBytes(IOUtil.readByteArray(in));
    }

    @Override
    public final Object readObj(BufferedInput in) throws IOException {
        return Marshalled.forBytes(in.readByteArray());
    }

    @Override
    public String toString(Object value) {
        if (value instanceof Marshalled) {
            Marshalled marshalled = (Marshalled)value;
            return marshalled + " " + Base64.DEFAULT_UNPADDED.encode(marshalled.getBytes());
        }
        if (value == null) {
            return null;
        }
        return String.valueOf(value);
    }

    @Override
    public Object parseString(String value) {
        if (value == null) {
            return null;
        }
        int i = value.lastIndexOf(32);
        return Marshalled.forBytes(Base64.DEFAULT_UNPADDED.decode(value.substring(i + 1)));
    }
}

