/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.kit;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.DataScheme;
import com.devexperts.qd.QDFilter;
import com.devexperts.qd.QDLog;
import com.devexperts.qd.kit.PatternFilter;
import com.devexperts.qd.kit.RecordOnlyFilter;

final class FastRecordFilter
extends RecordOnlyFilter {
    private final QDFilter delegate;
    private final boolean[] accepts;

    FastRecordFilter(DataScheme scheme, boolean[] accepts) {
        super(scheme);
        this.delegate = null;
        this.accepts = accepts;
    }

    FastRecordFilter(QDFilter delegate, boolean warnOnPotentialTypo) {
        super(delegate.getScheme());
        if (delegate.isDynamic()) {
            throw new IllegalArgumentException("Only static filters are supported");
        }
        this.delegate = delegate;
        int n = this.getScheme().getRecordCount();
        this.accepts = new boolean[n];
        int cnt = 0;
        for (int i = 0; i < n; ++i) {
            this.accepts[i] = delegate.accept(null, this.getScheme().getRecord(i), 0, null);
            if (!this.accepts[i]) continue;
            ++cnt;
        }
        if (warnOnPotentialTypo && cnt == 0) {
            QDLog.log.info("WARNING: Filter \"" + delegate + "\" matches no records.");
        }
        if (warnOnPotentialTypo && cnt == n) {
            QDLog.log.info("WARNING: Filter \"" + delegate + "\" matches all records.");
        }
    }

    @Override
    public QDFilter unwrap() {
        return this.delegate == null ? this : this.delegate;
    }

    @Override
    public QDFilter negate() {
        return new FastRecordFilter(this.delegate == null ? super.negate() : this.delegate.negate(), false);
    }

    @Override
    public boolean acceptRecord(DataRecord record) {
        int id = record.getId();
        return id < this.accepts.length && this.accepts[id];
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        if (this.delegate != null) {
            this.delegate.setName(name);
        }
    }

    @Override
    public String getDefaultName() {
        if (this.delegate != null) {
            return this.delegate.toString();
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.accepts.length; ++i) {
            if (!this.accepts[i]) continue;
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(':').append(PatternFilter.quote(this.getScheme().getRecord(i).getName()));
        }
        if (sb.length() == 0) {
            sb.append("!:*");
        }
        return sb.toString();
    }

    @Override
    public QDFilter.SyntaxPrecedence getSyntaxPrecedence() {
        if (this.delegate != null) {
            return this.delegate.getSyntaxPrecedence();
        }
        int count = 0;
        for (boolean accept : this.accepts) {
            if (!accept) continue;
            ++count;
        }
        return count <= 1 ? QDFilter.SyntaxPrecedence.TOKEN : QDFilter.SyntaxPrecedence.OR;
    }
}

