/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.kit;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.DataScheme;
import com.devexperts.qd.QDLog;
import com.devexperts.qd.SymbolCodec;
import com.devexperts.qd.kit.AbstractDataField;
import com.devexperts.qd.kit.AbstractDataIntField;
import com.devexperts.qd.kit.AbstractDataObjField;
import com.devexperts.qd.kit.DefaultRecord;
import com.devexperts.qd.kit.PentaCodec;
import com.devexperts.qd.spi.DataSchemeService;
import com.devexperts.services.Services;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DefaultScheme
implements DataScheme {
    protected final SymbolCodec codec;
    protected final DefaultRecord[] records;
    private final HashMap<String, DefaultRecord> records_by_name;
    private final HashMap<String, AbstractDataIntField> int_fields_by_name;
    private final HashMap<String, AbstractDataObjField> obj_fields_by_name;
    private final Map<Class<?>, Object> services = Collections.synchronizedMap(new HashMap());

    public DefaultScheme(SymbolCodec codec, DataRecord ... records) {
        if (codec == null) {
            throw new NullPointerException("SymbolCodec is null.");
        }
        if (codec.getClass() != PentaCodec.class) {
            QDLog.log.warn("WARNING: DEPRECATED use of custom SymbolCodec interface implementation " + codec.getClass().getName());
        }
        this.codec = codec;
        int n = records == null ? 0 : records.length;
        this.records = new DefaultRecord[n];
        if (n > 0) {
            System.arraycopy(records, 0, this.records, 0, n);
        }
        this.records_by_name = new HashMap();
        this.int_fields_by_name = new HashMap();
        this.obj_fields_by_name = new HashMap();
        int i = n;
        while (--i >= 0) {
            AbstractDataField field;
            DefaultRecord record = this.records[i];
            if (record.getId() != i) {
                throw new IllegalArgumentException("Record's id does not coincide with record index.");
            }
            if (this.records_by_name.put(record.getName(), record) != null) {
                throw new IllegalArgumentException("Duplicate record name.");
            }
            int j = record.getIntFieldCount();
            while (--j >= 0) {
                field = record.getIntField(j);
                if (this.int_fields_by_name.put(field.getName(), (AbstractDataIntField)field) == null) continue;
                throw new IllegalArgumentException("Duplicate int-field name.");
            }
            j = record.getObjFieldCount();
            while (--j >= 0) {
                field = record.getObjField(j);
                if (this.obj_fields_by_name.put(field.getName(), (AbstractDataObjField)field) == null) continue;
                throw new IllegalArgumentException("Duplicate obj-field name.");
            }
        }
        this.setParentReferences();
    }

    @Override
    public final SymbolCodec getCodec() {
        return this.codec;
    }

    @Override
    public final int getRecordCount() {
        return this.records.length;
    }

    @Override
    public final DefaultRecord getRecord(int index) {
        return this.records[index];
    }

    @Override
    public final DefaultRecord findRecordByName(String name) {
        return this.records_by_name.get(name);
    }

    @Override
    public final AbstractDataIntField findIntFieldByName(String name) {
        return this.int_fields_by_name.get(name);
    }

    @Override
    public final AbstractDataObjField findObjFieldByName(String name) {
        return this.obj_fields_by_name.get(name);
    }

    @Override
    public <T> T getService(Class<T> serviceClass) {
        Object result = this.services.get(serviceClass);
        if (result == null && (result = Services.createService(serviceClass, this.getClass().getClassLoader(), null)) != null) {
            if (result instanceof DataSchemeService) {
                ((DataSchemeService)result).setScheme(this);
            }
            this.services.put(serviceClass, result);
        }
        return (T)result;
    }

    public static void setParentReferences(DataScheme scheme) {
        ((DefaultScheme)scheme).setParentReferences();
    }

    private void setParentReferences() {
        for (DefaultRecord record : this.records) {
            record.setScheme(this);
        }
    }

    public static void verifyScheme(DataScheme scheme) {
    }
}

