/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.kit;

import com.devexperts.io.BufferedInput;
import com.devexperts.io.BufferedOutput;
import com.devexperts.qd.DataField;
import com.devexperts.qd.DataIntField;
import com.devexperts.qd.DataObjField;
import com.devexperts.qd.DataRecord;
import com.devexperts.qd.kit.AbstractDataField;
import com.devexperts.qd.kit.AbstractDataIntField;
import com.devexperts.qd.kit.AbstractDataObjField;
import com.devexperts.qd.kit.DefaultScheme;
import com.devexperts.qd.kit.RecordMappingFactoryHolder;
import com.devexperts.qd.ng.RecordCursor;
import com.devexperts.qd.ng.RecordMapping;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DefaultRecord
implements DataRecord {
    private DefaultScheme scheme;
    protected final int id;
    protected final String name;
    protected final boolean has_time;
    private final AbstractDataIntField[] intFields;
    private final AbstractDataObjField[] objFields;
    private final Map<String, DataField> fieldsByName = new HashMap<String, DataField>();
    private final Map<Class<? extends RecordMapping>, RecordMapping> mappings;
    private final RecordMapping mapping;

    public DefaultRecord(int id, String name, boolean hasTime, DataIntField[] dataIntFields, DataObjField[] dataObjFields) {
        int i;
        this.id = id;
        this.name = name;
        this.has_time = hasTime;
        this.intFields = dataIntFields == null ? new AbstractDataIntField[]{} : (AbstractDataIntField[])Arrays.copyOf(dataIntFields, dataIntFields.length, AbstractDataIntField[].class);
        this.objFields = dataObjFields == null ? new AbstractDataObjField[]{} : (AbstractDataObjField[])Arrays.copyOf(dataObjFields, dataObjFields.length, AbstractDataObjField[].class);
        for (AbstractDataIntField abstractDataIntField : this.intFields) {
            abstractDataIntField.setRecord(this);
        }
        for (AbstractDataField abstractDataField : this.objFields) {
            abstractDataField.setRecord(this);
        }
        if (hasTime && this.intFields.length < 2) {
            throw new IllegalArgumentException("Not enough Int-fields to contain time.");
        }
        if (id < 0) {
            throw new IllegalArgumentException("Record id is negative.");
        }
        for (i = 0; i < this.intFields.length; ++i) {
            if (this.intFields[i].getIndex() == i) continue;
            throw new IllegalArgumentException("Int field index #" + i + " does not match: " + this.intFields[i]);
        }
        for (i = 0; i < this.objFields.length; ++i) {
            if (this.objFields[i].getIndex() == i) continue;
            throw new IllegalArgumentException("Obj field index #" + i + " does not match: " + this.objFields[i]);
        }
        this.putDefaultFieldNames(this.intFields);
        this.putDefaultFieldNames(this.objFields);
        this.mappings = Collections.unmodifiableMap(RecordMappingFactoryHolder.createMapping(this));
        this.mapping = this.mappings.isEmpty() ? null : this.mappings.values().iterator().next();
        this.putNonDefaultFieldNames(this.intFields);
        this.putNonDefaultFieldNames(this.objFields);
    }

    private void putDefaultFieldNames(AbstractDataField[] fields) {
        for (AbstractDataField field : fields) {
            this.putFieldByName(field, field.getName());
            this.putFieldByName(field, field.getLocalName());
            this.putFieldByName(field, field.getPropertyName());
        }
    }

    private void putNonDefaultFieldNames(AbstractDataField[] fields) {
        for (AbstractDataField field : fields) {
            for (RecordMapping mapping : this.mappings.values()) {
                String propertyName = mapping.getNonDefaultPropertyName(field.getLocalName());
                if (propertyName == null) continue;
                this.putFieldByName(field, propertyName);
                field.setPropertyName(propertyName);
            }
        }
    }

    private void putFieldByName(DataField field, String name) {
        if (name.equals("EventSymbol")) {
            throw new IllegalArgumentException("Field name conflicts with EventSymbol: " + field.getName());
        }
        DataField otherField = this.fieldsByName.put(name, field);
        if (otherField != null && otherField != field) {
            throw new IllegalArgumentException("Field name conflict between " + field.getName() + " and " + otherField.getName());
        }
    }

    public final void setScheme(DefaultScheme scheme) {
        if (this.scheme != scheme && this.scheme != null) {
            throw new IllegalStateException("Parent scheme already set to different instance.");
        }
        this.scheme = scheme;
    }

    public final String toString() {
        return this.name;
    }

    @Override
    public final DefaultScheme getScheme() {
        return this.scheme;
    }

    @Override
    public RecordMapping getMapping() {
        return this.mapping;
    }

    @Override
    public final <T extends RecordMapping> T getMapping(Class<T> mappingClass) {
        if (this.mapping == null) {
            return null;
        }
        if (this.mapping.getClass() == mappingClass) {
            return (T)this.mapping;
        }
        if (this.mappings.size() == 1) {
            return null;
        }
        return (T)this.mappings.get(mappingClass);
    }

    @Override
    public Map<Class<? extends RecordMapping>, RecordMapping> getMappings() {
        return this.mappings;
    }

    @Override
    public final int getId() {
        return this.id;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final boolean hasTime() {
        return this.has_time;
    }

    @Override
    public final int getIntFieldCount() {
        return this.intFields.length;
    }

    @Override
    public final AbstractDataIntField getIntField(int index) {
        return this.intFields[index];
    }

    @Override
    public final int getObjFieldCount() {
        return this.objFields.length;
    }

    @Override
    public final AbstractDataObjField getObjField(int index) {
        return this.objFields[index];
    }

    @Override
    public final DataField findFieldByName(String name) {
        return this.fieldsByName.get(name);
    }

    @Override
    public boolean update(RecordCursor from, RecordCursor to) {
        return to.updateDataFrom(from);
    }

    @Override
    public void writeFields(BufferedOutput out, RecordCursor cursor) throws IOException {
        for (AbstractDataIntField abstractDataIntField : this.intFields) {
            abstractDataIntField.write(out, cursor);
        }
        for (AbstractDataField abstractDataField : this.objFields) {
            ((AbstractDataObjField)abstractDataField).write(out, cursor);
        }
    }

    @Override
    public void readFields(BufferedInput in, RecordCursor cursor) throws IOException {
        for (AbstractDataIntField abstractDataIntField : this.intFields) {
            abstractDataIntField.read(in, cursor);
        }
        for (AbstractDataField abstractDataField : this.objFields) {
            ((AbstractDataObjField)abstractDataField).read(in, cursor);
        }
    }
}

