/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.kit;

import com.devexperts.qd.SerialFieldType;
import com.devexperts.qd.kit.CompactIntField;
import com.devexperts.qd.util.Decimal;

public class DecimalField
extends CompactIntField {
    public DecimalField(int index, String name) {
        this(index, name, SerialFieldType.DECIMAL.forNamedField(name));
    }

    public DecimalField(int index, String name, SerialFieldType serialType) {
        super(index, name, serialType);
        if (!serialType.hasSameRepresentationAs(SerialFieldType.DECIMAL)) {
            throw new IllegalArgumentException("Invalid serialType: " + serialType);
        }
    }

    @Override
    public String toString(int value) {
        return Decimal.toString(value);
    }

    @Override
    public int parseString(String value) {
        return Decimal.parseDecimal(value);
    }

    @Override
    public double toDouble(int value) {
        return Decimal.toDouble(value);
    }

    @Override
    public int toInt(double value) {
        return Decimal.compose(value);
    }
}

