/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.kit;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.DataScheme;
import com.devexperts.qd.QDContract;
import com.devexperts.qd.QDFilter;
import com.devexperts.qd.QDLog;
import com.devexperts.qd.StableSubscriptionFilter;
import com.devexperts.qd.SubscriptionFilter;
import com.devexperts.qd.SubscriptionFilterFactory;
import com.devexperts.qd.kit.FastRecordFilter;
import com.devexperts.qd.kit.FilterSyntaxException;
import com.devexperts.qd.kit.PatternFilter;
import com.devexperts.qd.kit.RecordOnlyFilter;
import com.devexperts.qd.kit.SymbolSetFilter;
import com.devexperts.qd.spi.QDFilterContext;
import com.devexperts.qd.spi.QDFilterFactory;
import com.devexperts.qd.util.SymbolSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class CompositeFilters {
    private static final char EOLN = '\u0000';
    private static final char SPACE = ' ';
    private static final char NOT = '!';
    private static final char AND = '&';
    private static final char OR = ',';
    private static final char OPEN_PAREN = '(';
    private static final char CLOSE_PAREN = ')';
    private static final char OPEN_BRACE = '[';
    private static final char CLOSE_BRACE = ']';
    private static final char OPEN_CURL = '{';
    private static final char CLOSE_CURL = '}';
    private static final char BACKSPACE = '\\';
    private static final char RECORD = ':';
    private static final char ANY = '*';
    private static final Comparator<QDFilter> FILTERS_BY_KIND = (f1, f2) -> f1.getKind().compareTo(f2.getKind());

    private CompositeFilters() {
    }

    public static QDFilter valueOf(String spec, DataScheme scheme) {
        QDFilter result = CompositeFilters.parse(spec, scheme, scheme.getService(QDFilterFactory.class), QDFilterContext.DEFAULT);
        result.setNameOrDefault(spec);
        return result;
    }

    public static QDFilter valueOf(String spec, String name, DataScheme scheme) {
        QDFilter result = CompositeFilters.parse(spec, scheme, scheme.getService(QDFilterFactory.class), QDFilterContext.NAMED);
        result.setShortName(name);
        return result;
    }

    public static QDFilterFactory getFactory(DataScheme scheme) {
        QDFilterFactory baseFactory = scheme.getService(QDFilterFactory.class);
        return baseFactory instanceof Factory ? baseFactory : new Factory(baseFactory);
    }

    public static SubscriptionFilter valueOf(String spec, SubscriptionFilterFactory baseFactory) {
        QDFilterFactory factory = QDFilterFactory.fromFilterFactory(baseFactory);
        return CompositeFilters.nullForAnything(CompositeFilters.parse(spec, factory.getScheme(), factory, QDFilterContext.DEFAULT));
    }

    private static QDFilter parse(String spec, DataScheme scheme, QDFilterFactory factory, QDFilterContext context) {
        if (spec.isEmpty()) {
            return QDFilter.ANYTHING;
        }
        if (factory instanceof Factory) {
            factory = ((Factory)factory).baseFactory;
        }
        Parser parser = new Parser(spec, scheme, factory, context);
        QDFilter result = parser.parseOr();
        if (parser.cur != '\u0000') {
            throw new FilterSyntaxException("Unexpected end of complex filter specification");
        }
        return result;
    }

    public static RecordOnlyFilter forRecords(Collection<DataRecord> records) {
        DataScheme scheme = null;
        boolean[] accepts = null;
        for (DataRecord record : records) {
            if (scheme != null && record.getScheme() != scheme) {
                throw new IllegalArgumentException("Records from different schemes");
            }
            if (scheme == null) {
                scheme = record.getScheme();
                accepts = new boolean[scheme.getRecordCount()];
            }
            accepts[record.getId()] = true;
        }
        return new FastRecordFilter(scheme, accepts == null ? new boolean[]{} : accepts);
    }

    public static QDFilter toStableFilter(SubscriptionFilter filter) {
        if (filter instanceof StableSubscriptionFilter) {
            QDFilter result = QDFilter.fromFilter(((StableSubscriptionFilter)filter).toStableFilter(), null);
            if (result.toStableFilter() != result) {
                throw new IllegalArgumentException(filter + ": .toStableFilter returns filter that is not itself stable");
            }
            return result;
        }
        return QDFilter.ANYTHING;
    }

    public static QDFilter makeOr(QDFilter one, QDFilter two) {
        OrBuilder builder = new OrBuilder();
        builder.add(one == null ? QDFilter.ANYTHING : one);
        builder.add(two == null ? QDFilter.ANYTHING : two);
        return builder.build(null);
    }

    public static SubscriptionFilter makeOr(SubscriptionFilter one, SubscriptionFilter two) {
        return one == null || two == null ? null : CompositeFilters.nullForAnything(CompositeFilters.makeOr(QDFilter.fromFilter(one, null), QDFilter.fromFilter(two, null)));
    }

    public static QDFilter makeAnd(QDFilter one, QDFilter two) {
        AndBuilder builder = new AndBuilder();
        builder.add(one == null ? QDFilter.ANYTHING : one);
        builder.add(two == null ? QDFilter.ANYTHING : two);
        return builder.build(null);
    }

    public static SubscriptionFilter makeAnd(SubscriptionFilter one, SubscriptionFilter two) {
        if (one == null) {
            return two;
        }
        if (two == null) {
            return one;
        }
        return CompositeFilters.nullForAnything(CompositeFilters.makeAnd(QDFilter.fromFilter(one, null), QDFilter.fromFilter(two, null)));
    }

    public static QDFilter makeNot(QDFilter filter) {
        return filter == null ? QDFilter.NOTHING : filter.negate();
    }

    public static SubscriptionFilter makeNot(SubscriptionFilter filter) {
        return CompositeFilters.nullForAnything(CompositeFilters.makeNot(QDFilter.fromFilter(filter, null)));
    }

    private static SubscriptionFilter nullForAnything(QDFilter filter) {
        return filter == QDFilter.ANYTHING ? null : filter;
    }

    private static QDFilter wrapFastFilter(QDFilter f, boolean warnOnPotentialTypo) {
        if (f.isDynamic()) {
            return f;
        }
        switch (f.getKind()) {
            case RECORD_ONLY: {
                return f instanceof FastRecordFilter ? f : new FastRecordFilter(f, warnOnPotentialTypo);
            }
            case SYMBOL_SET: {
                return f instanceof SymbolSetFilter ? f : new SymbolSetFilter(f);
            }
        }
        return f;
    }

    private static QDFilter.Kind getListFilterKind(List<QDFilter> list) {
        int ro = 0;
        int so = 0;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            QDFilter.Kind kind = list.get(i).getKind();
            if (kind.isRecordOnly()) {
                ++ro;
                continue;
            }
            if (!kind.isSymbolOnly()) continue;
            ++so;
        }
        if (ro == n) {
            return QDFilter.Kind.RECORD_ONLY;
        }
        if (so == n) {
            return QDFilter.Kind.OTHER_SYMBOL_ONLY;
        }
        return QDFilter.Kind.OTHER;
    }

    private static List<QDFilter> negateList(QDFilter[] list) {
        ArrayList<QDFilter> result = new ArrayList<QDFilter>(list.length);
        for (QDFilter filter : list) {
            result.add(filter.negate());
        }
        return result;
    }

    private static class AndFilter
    extends ListFilter {
        AndFilter(List<QDFilter> list, ListFilter source) {
            super(list, source);
        }

        @Override
        char separator() {
            return '&';
        }

        @Override
        boolean parenthesis(QDFilter f) {
            return f.getSyntaxPrecedence() == QDFilter.SyntaxPrecedence.OR;
        }

        @Override
        QDFilter rebuild(List<QDFilter> list, ListFilter source) {
            return new AndBuilder().addAll(list).build(source);
        }

        @Override
        public QDFilter negate() {
            return this.negateShortName(new OrFilter(CompositeFilters.negateList(this.list), null));
        }

        @Override
        public boolean accept(QDContract contract, DataRecord record, int cipher, String symbol) {
            for (QDFilter f : this.list) {
                if (f.accept(contract, record, cipher, symbol)) continue;
                return false;
            }
            return true;
        }

        @Override
        public QDFilter.SyntaxPrecedence getSyntaxPrecedence() {
            return QDFilter.SyntaxPrecedence.AND;
        }
    }

    private static class AndBuilder
    extends ListBuilder {
        private AndBuilder() {
        }

        @Override
        void add(QDFilter other) {
            if (other == null || other == QDFilter.ANYTHING) {
                return;
            }
            if (other instanceof AndFilter) {
                this.list.addAll(Arrays.asList(((AndFilter)other).list));
            } else {
                this.list.add(other);
            }
        }

        @Override
        QDFilter create(List<QDFilter> list, ListFilter source) {
            return new AndFilter(list, source);
        }

        @Override
        void symbolSetJoin(SymbolSet set, SymbolSet other) {
            set.retainAll(other);
        }
    }

    private static class OrFilter
    extends ListFilter {
        OrFilter(List<QDFilter> list, ListFilter source) {
            super(list, source);
        }

        @Override
        char separator() {
            return ',';
        }

        @Override
        boolean parenthesis(QDFilter f) {
            return false;
        }

        @Override
        QDFilter rebuild(List<QDFilter> list, ListFilter source) {
            return new OrBuilder().addAll(list).build(source);
        }

        @Override
        public QDFilter negate() {
            return this.negateShortName(new AndFilter(CompositeFilters.negateList(this.list), null));
        }

        @Override
        public boolean accept(QDContract contract, DataRecord record, int cipher, String symbol) {
            for (QDFilter f : this.list) {
                if (!f.accept(contract, record, cipher, symbol)) continue;
                return true;
            }
            return false;
        }

        @Override
        public QDFilter.SyntaxPrecedence getSyntaxPrecedence() {
            return QDFilter.SyntaxPrecedence.OR;
        }
    }

    private static class OrBuilder
    extends ListBuilder {
        private boolean anything;

        private OrBuilder() {
        }

        @Override
        QDFilter create(List<QDFilter> list, ListFilter source) {
            return new OrFilter(list, source);
        }

        @Override
        public void add(QDFilter other) {
            if (this.anything || other == QDFilter.NOTHING) {
                return;
            }
            if (other == null || other == QDFilter.ANYTHING) {
                this.anything = true;
                this.list.clear();
                return;
            }
            if (other instanceof OrFilter) {
                this.list.addAll(Arrays.asList(((OrFilter)other).list));
            } else {
                this.list.add(other);
            }
        }

        @Override
        void symbolSetJoin(SymbolSet set, SymbolSet other) {
            set.addAll(other);
        }
    }

    private static abstract class ListFilter
    extends QDFilter
    implements QDFilter.UpdateListener {
        final QDFilter[] list;
        final QDFilter.Kind kind;
        final boolean stable;
        final boolean dynamic;
        final boolean fast;

        abstract char separator();

        abstract boolean parenthesis(QDFilter var1);

        abstract QDFilter rebuild(List<QDFilter> var1, ListFilter var2);

        ListFilter(List<QDFilter> list, ListFilter source) {
            super(list.get(0).getScheme(), source);
            this.list = list.toArray(new QDFilter[list.size()]);
            this.kind = CompositeFilters.getListFilterKind(list);
            if (this.kind == QDFilter.Kind.RECORD_ONLY && this.getScheme() == null) {
                throw new IllegalArgumentException("Record filter shall have scheme");
            }
            boolean stable = true;
            boolean dynamic = false;
            boolean fast = true;
            for (QDFilter f : list) {
                stable &= f.isStable();
                dynamic |= f.isDynamic();
                fast &= f.isFast();
            }
            this.stable = stable;
            this.dynamic = dynamic;
            this.fast = fast;
        }

        @Override
        public QDFilter.Kind getKind() {
            return this.kind;
        }

        @Override
        public boolean isStable() {
            return this.stable;
        }

        @Override
        public boolean isDynamic() {
            return this.dynamic;
        }

        @Override
        public boolean isFast() {
            return this.fast;
        }

        @Override
        public QDFilter toStableFilter() {
            if (this.stable) {
                return this;
            }
            ArrayList<QDFilter> result = new ArrayList<QDFilter>();
            for (QDFilter f : this.list) {
                result.add(f.toStableFilter());
            }
            return this.rebuild(result, null);
        }

        @Override
        protected void dynamicTrackingStart() {
            for (QDFilter f : this.list) {
                f.addUpdateListener(this);
            }
        }

        @Override
        protected void dynamicTrackingStop() {
            for (QDFilter f : this.list) {
                f.removeUpdateListener(this);
            }
        }

        @Override
        protected QDFilter produceUpdatedFilter() {
            ArrayList<QDFilter> result = new ArrayList<QDFilter>();
            for (QDFilter f : this.list) {
                result.add(f.getUpdatedFilter());
            }
            return this.rebuild(result, this);
        }

        @Override
        public void filterUpdated(QDFilter filter) {
            this.fireFilterUpdated(null);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return Arrays.equals(this.list, ((ListFilter)o).list);
        }

        public int hashCode() {
            return Arrays.hashCode(this.list);
        }

        @Override
        public String getDefaultName() {
            StringBuilder sb = new StringBuilder();
            for (QDFilter f : this.list) {
                boolean parenthesis;
                if (sb.length() > 0) {
                    sb.append(this.separator());
                }
                if (parenthesis = this.parenthesis(f)) {
                    sb.append('(');
                }
                sb.append(f);
                if (!parenthesis) continue;
                sb.append(')');
            }
            return sb.toString();
        }

        protected QDFilter negateShortName(QDFilter result) {
            if (this.hasShortName()) {
                String name = this.toString();
                name = name.startsWith("!") ? name.substring(1) : "!" + name;
                result.setName(name);
            }
            return result;
        }
    }

    private static abstract class ListBuilder {
        final List<QDFilter> list = new ArrayList<QDFilter>();

        private ListBuilder() {
        }

        abstract void add(QDFilter var1);

        abstract QDFilter create(List<QDFilter> var1, ListFilter var2);

        abstract void symbolSetJoin(SymbolSet var1, SymbolSet var2);

        ListBuilder addAll(List<QDFilter> list) {
            list.forEach(this::add);
            return this;
        }

        QDFilter build(ListFilter source) {
            SymbolSet set;
            QDFilter original;
            int iSymbolSet;
            int iRecordOnly;
            if (this.list.isEmpty()) {
                return QDFilter.ANYTHING;
            }
            if (this.list.size() == 1) {
                return this.list.get(0);
            }
            Collections.sort(this.list, FILTERS_BY_KIND);
            for (iRecordOnly = 0; iRecordOnly < this.list.size() && this.list.get(iRecordOnly).getKind() == QDFilter.Kind.RECORD_ONLY; ++iRecordOnly) {
            }
            if (iRecordOnly > 1) {
                for (int i = 0; i < iRecordOnly; ++i) {
                    this.list.set(i, this.list.get(i).unwrap());
                }
                if (iRecordOnly < this.list.size()) {
                    List<QDFilter> recordFilters = this.list.subList(0, iRecordOnly);
                    QDFilter rf = CompositeFilters.wrapFastFilter(this.create(recordFilters, null), true);
                    recordFilters.clear();
                    this.list.add(0, rf);
                    iRecordOnly = 1;
                }
            }
            for (iSymbolSet = iRecordOnly; iSymbolSet < this.list.size() && this.list.get(iSymbolSet).getKind() == QDFilter.Kind.SYMBOL_SET; ++iSymbolSet) {
            }
            ArrayList<QDFilter> symbolSetCombines = new ArrayList<QDFilter>(this.list.subList(iRecordOnly, iSymbolSet));
            if (iSymbolSet - iRecordOnly > 1) {
                original = this.list.get(iRecordOnly);
                set = SymbolSet.copyOf(original.getSymbolSet());
                for (int i = iRecordOnly + 1; i < iSymbolSet; ++i) {
                    this.symbolSetJoin(set, this.list.get(i).getSymbolSet());
                }
                this.list.subList(iRecordOnly, iSymbolSet).clear();
                this.list.add(iRecordOnly, this.createSymbolSetFilter(original, symbolSetCombines, set));
                iSymbolSet = iRecordOnly + 1;
            }
            if (this instanceof AndBuilder && iSymbolSet - iRecordOnly > 0) {
                assert (iSymbolSet == iRecordOnly + 1);
                original = this.list.get(iRecordOnly);
                set = SymbolSet.copyOf(original.getSymbolSet());
                int j = iSymbolSet;
                for (int i = iSymbolSet; i < this.list.size(); ++i) {
                    QDFilter filter = this.list.get(i);
                    if (filter.getKind().isSymbolOnly() && !filter.isDynamic()) {
                        set.retainAll(filter);
                        symbolSetCombines.add(filter);
                        continue;
                    }
                    this.list.set(j++, filter);
                }
                this.list.subList(j, this.list.size()).clear();
                if (set.isEmpty()) {
                    QDLog.log.info("WARNING: Filter \"" + new AndFilter(symbolSetCombines, source) + "\" matches no symbol. You must quote '&' character using \"[&]\" to use it in symbol.");
                    return QDFilter.NOTHING;
                }
                this.list.set(iRecordOnly, this.createSymbolSetFilter(original, symbolSetCombines, set));
            }
            if (this.list.size() == 1) {
                return this.list.get(0);
            }
            return CompositeFilters.wrapFastFilter(this.create(this.list, source), true);
        }

        @Nonnull
        private SymbolSetFilter createSymbolSetFilter(QDFilter original, List<QDFilter> symbolSetCombines, SymbolSet set) {
            return new SymbolSetFilter(original.getScheme(), set, this.create(symbolSetCombines, null));
        }
    }

    private static class Factory
    extends QDFilterFactory {
        final QDFilterFactory baseFactory;

        Factory(QDFilterFactory baseFactory) {
            super(baseFactory.getScheme());
            this.baseFactory = baseFactory;
        }

        @Override
        public QDFilter createFilter(String spec) {
            return this.createFilter(spec, QDFilterContext.DEFAULT);
        }

        @Override
        public QDFilter createFilter(String spec, QDFilterContext context) {
            return CompositeFilters.parse(spec, this.getScheme(), this.baseFactory, context);
        }
    }

    private static class Parser {
        static final int N_CHAR_KINDS = 128;
        static final boolean[] SPECIAL = new boolean[128];
        static final boolean[] DELIMITER = new boolean[128];
        static final Map<String, Character> KEYWORDS = new HashMap<String, Character>();
        final String spec;
        final DataScheme scheme;
        final QDFilterFactory baseFactory;
        final QDFilterContext context;
        int pos;
        int next;
        char cur;
        boolean keyword;

        Parser(String spec, DataScheme scheme, QDFilterFactory baseFactory, QDFilterContext context) {
            this.spec = spec;
            this.scheme = scheme;
            this.baseFactory = baseFactory;
            this.context = context;
            this.pos = this.skipSpaces(0);
            this.initCur();
        }

        private boolean isSpecial(char c) {
            return c < SPECIAL.length && SPECIAL[c];
        }

        private boolean isDelimiter(char c) {
            return c < DELIMITER.length && DELIMITER[c];
        }

        private char getAtSpaced(int pos) {
            return pos < 0 || pos >= this.spec.length() ? (char)' ' : this.spec.charAt(pos);
        }

        private int skipSpaces(int pos) {
            while (pos < this.spec.length() && this.spec.charAt(pos) == ' ') {
                ++pos;
            }
            return pos;
        }

        private void initCur() {
            int pos = this.skipSpaces(this.pos);
            if (this.isDelimiter(this.getAtSpaced(pos - 1)) && !this.isDelimiter(this.getAtSpaced(pos))) {
                block0: for (Map.Entry<String, Character> kw : KEYWORDS.entrySet()) {
                    String key = kw.getKey();
                    int n = key.length();
                    for (int i = 0; i < n; ++i) {
                        if (this.getAtSpaced(pos + i) != key.charAt(i)) continue block0;
                    }
                    if (!this.isDelimiter(this.getAtSpaced(pos + n))) continue;
                    this.cur = kw.getValue().charValue();
                    this.next = this.skipSpaces(pos + n);
                    this.keyword = true;
                    return;
                }
            }
            pos = this.pos;
            this.keyword = false;
            if (pos >= this.spec.length()) {
                this.cur = '\u0000';
                this.next = pos;
                return;
            }
            this.cur = this.spec.charAt(pos);
            this.next = pos + 1;
        }

        private void next() {
            this.pos = this.next;
            this.initCur();
        }

        QDFilter parseOr() {
            QDFilter filter = this.parseAnd();
            if (this.cur == ',') {
                OrBuilder builder = new OrBuilder();
                builder.add(filter);
                do {
                    this.next();
                    builder.add(this.parseAnd());
                } while (this.cur == ',');
                filter = builder.build(null);
            }
            return filter;
        }

        private QDFilter parseAnd() {
            QDFilter filter = this.parseToken();
            if (this.cur == '&') {
                AndBuilder builder = new AndBuilder();
                builder.add(filter);
                do {
                    this.next();
                    builder.add(this.parseToken());
                } while (this.cur == '&');
                filter = builder.build(null);
            }
            return filter;
        }

        private QDFilter parseToken() {
            switch (this.cur) {
                case '!': {
                    this.next();
                    return CompositeFilters.makeNot(this.parseToken());
                }
                case '(': {
                    this.next();
                    QDFilter result = this.parseOr();
                    if (this.cur != ')') {
                        throw new FilterSyntaxException("Missing ')' in complex filter specification");
                    }
                    this.next();
                    return result;
                }
            }
            int brace_level = 0;
            int curl_level = 0;
            StringBuilder ss = new StringBuilder();
            while (this.cur != '\u0000' && (brace_level > 0 || curl_level > 0) || !this.isSpecial(this.cur)) {
                switch (this.cur) {
                    case '[': {
                        ++brace_level;
                        break;
                    }
                    case ']': {
                        if (--brace_level >= 0) break;
                        throw new FilterSyntaxException("Extra ']' in complex filter specification");
                    }
                }
                if (this.cur == '\\' && this.pos + 1 < this.spec.length()) {
                    char quotedChar = this.spec.charAt(this.pos + 1);
                    if (quotedChar == 'Q') {
                        this.pos += 2;
                        while (this.pos + 1 < this.spec.length() && (this.spec.charAt(this.pos) != '\\' || this.spec.charAt(this.pos + 1) != 'E')) {
                            ss.append(this.spec.charAt(this.pos++));
                        }
                        if (this.pos + 1 >= this.spec.length()) {
                            throw new FilterSyntaxException("Block quote started with '\\Q' shall be terminated with '\\E'");
                        }
                    } else {
                        ss.append('\\').append(quotedChar);
                    }
                    this.pos += 2;
                    this.initCur();
                    continue;
                }
                if (brace_level == 0) {
                    switch (this.cur) {
                        case '{': {
                            ++curl_level;
                            break;
                        }
                        case '}': {
                            if (--curl_level >= 0) break;
                            throw new FilterSyntaxException("Extra '}' in complex filter specification");
                        }
                    }
                }
                if (brace_level > 0 && this.keyword) {
                    ss.append(this.spec.substring(this.pos, this.next));
                } else {
                    ss.append(this.cur);
                }
                this.next();
            }
            if (brace_level > 0) {
                throw new FilterSyntaxException("Missing ']' in complex filter specification");
            }
            if (curl_level > 0) {
                throw new FilterSyntaxException("Missing '}' in complex filter specification");
            }
            if (ss.length() == 0) {
                throw new FilterSyntaxException("Filter pattern missing in complex filter specification");
            }
            String name = ss.toString();
            QDFilter filter = this.createWithBaseFactory(name);
            filter.setName(name);
            return CompositeFilters.wrapFastFilter(filter, this.context == QDFilterContext.DEFAULT || this.context == QDFilterContext.RECORD_ONLY);
        }

        private QDFilter createWithBaseFactory(String spec) {
            QDFilter filter;
            QDFilter qDFilter = filter = this.baseFactory != null ? this.baseFactory.createFilter(spec, this.context) : null;
            if (filter == null) {
                filter = PatternFilter.valueOfImpl(spec, spec, this.scheme);
            }
            if (this.context == QDFilterContext.RECORD_ONLY && filter instanceof PatternFilter) {
                filter = PatternFilter.valueOfImpl(":" + ((PatternFilter)filter).getPattern(), spec, this.scheme);
            }
            return filter;
        }

        static {
            Parser.SPECIAL[0] = true;
            Parser.SPECIAL[33] = true;
            Parser.SPECIAL[38] = true;
            Parser.SPECIAL[44] = true;
            Parser.SPECIAL[40] = true;
            Parser.SPECIAL[41] = true;
            System.arraycopy(SPECIAL, 0, DELIMITER, 0, 128);
            Parser.DELIMITER[32] = true;
            Parser.DELIMITER[58] = true;
            Parser.DELIMITER[42] = true;
            Parser.DELIMITER[123] = true;
            Parser.DELIMITER[125] = true;
            KEYWORDS.put("not", Character.valueOf('!'));
            KEYWORDS.put("and", Character.valueOf('&'));
            KEYWORDS.put("or", Character.valueOf(','));
            KEYWORDS.put("record", Character.valueOf(':'));
            KEYWORDS.put("any", Character.valueOf('*'));
        }
    }
}

