/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.kit;

import com.devexperts.io.BufferedInput;
import com.devexperts.io.BufferedOutput;
import com.devexperts.io.IOUtil;
import com.devexperts.qd.SerialFieldType;
import com.devexperts.qd.kit.AbstractDataIntField;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class CompactCharField
extends AbstractDataIntField {
    private static final String[] CACHE = new String[128];

    public CompactCharField(int index, String name) {
        this(index, name, SerialFieldType.UTF_CHAR.forNamedField(name));
    }

    public CompactCharField(int index, String name, SerialFieldType serialType) {
        super(index, name, serialType);
        if (!serialType.hasSameSerialTypeAs(SerialFieldType.UTF_CHAR)) {
            throw new IllegalArgumentException("Invalid serialType: " + serialType);
        }
    }

    @Override
    public String toString(int value) {
        if (value >= 0 && value < CACHE.length) {
            String s = CACHE[value];
            return s != null ? s : String.valueOf((char)value);
        }
        return String.valueOf((char)value);
    }

    @Override
    public int parseString(String value) {
        if (value.length() != 1) {
            throw new IllegalArgumentException("String must contain just one character");
        }
        return value.charAt(0);
    }

    @Override
    public final void writeInt(DataOutput out, int value) throws IOException {
        IOUtil.writeUTFChar(out, value);
    }

    @Override
    public final void writeInt(BufferedOutput out, int value) throws IOException {
        out.writeUTFChar(value);
    }

    @Override
    public final int readInt(DataInput in) throws IOException {
        return IOUtil.readUTFChar(in);
    }

    @Override
    public final int readInt(BufferedInput in) throws IOException {
        return in.readUTFChar();
    }
}

