/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.kit;

import com.devexperts.io.BufferedInput;
import com.devexperts.io.BufferedOutput;
import com.devexperts.io.IOUtil;
import com.devexperts.qd.SerialFieldType;
import com.devexperts.qd.kit.AbstractDataObjField;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Locale;

public final class ByteArrayField
extends AbstractDataObjField {
    private static final char[] HEX = "0123456789ABCDEF".toCharArray();

    public ByteArrayField(int index, String name) {
        super(index, name, SerialFieldType.BYTE_ARRAY);
    }

    public Object fromByteArray(byte[] bytes) {
        return bytes;
    }

    public byte[] toByteArray(Object value) {
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        if (value instanceof String) {
            return ((String)value).getBytes(StandardCharsets.UTF_8);
        }
        if (value instanceof char[]) {
            return new String((char[])value).getBytes(StandardCharsets.UTF_8);
        }
        return null;
    }

    private byte[] toByteArrayAlways(Object value) {
        try {
            byte[] bytes = this.toByteArray(value);
            return bytes == null ? IOUtil.objectToBytes(value) : bytes;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot convert object to bytes", e);
        }
    }

    @Override
    public String toString(Object value) {
        if (value == null) {
            return null;
        }
        byte[] bytes = this.toByteArrayAlways(value);
        StringBuilder sb = new StringBuilder(2 + 2 * bytes.length);
        sb.append("0x");
        for (byte b : bytes) {
            int x = b & 0xFF;
            sb.append(HEX[x >> 4]).append(HEX[x & 0xF]);
        }
        return sb.toString();
    }

    @Override
    public Object parseString(String value) {
        block4: {
            if (value == null) {
                return null;
            }
            String s = value.toUpperCase(Locale.US);
            if (s.startsWith("0X") && s.length() % 2 == 0) {
                byte[] b = new byte[s.length() / 2 - 1];
                for (int i = 0; i < b.length; ++i) {
                    int hi = Arrays.binarySearch(HEX, s.charAt(2 * i + 2));
                    int lo = Arrays.binarySearch(HEX, s.charAt(2 * i + 3));
                    if (hi >= 0 && lo >= 0) {
                        b[i] = (byte)((hi << 4) + lo);
                        continue;
                    }
                    break block4;
                }
                return b;
            }
        }
        return value.getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public boolean equals(Object value1, Object value2) {
        if (value1 == value2) {
            return true;
        }
        if (value1 == null || value2 == null) {
            return false;
        }
        if (value1 instanceof byte[] && value2 instanceof byte[]) {
            return Arrays.equals((byte[])value1, (byte[])value2);
        }
        if (value1 instanceof String && value2 instanceof String) {
            return value1.equals(value2);
        }
        if (value1 instanceof char[] && value2 instanceof char[]) {
            return Arrays.equals((char[])value1, (char[])value2);
        }
        return Arrays.equals(this.toByteArrayAlways(value1), this.toByteArrayAlways(value2));
    }

    @Override
    public void writeObj(DataOutput out, Object value) throws IOException {
        byte[] bytes = this.toByteArray(value);
        if (bytes != null) {
            IOUtil.writeByteArray(out, bytes);
        } else {
            IOUtil.writeObject(out, value);
        }
    }

    @Override
    public void writeObj(BufferedOutput out, Object value) throws IOException {
        byte[] bytes = this.toByteArray(value);
        if (bytes != null) {
            out.writeByteArray(bytes);
        } else {
            out.writeObject(value);
        }
    }

    @Override
    public Object readObj(DataInput in) throws IOException {
        return this.fromByteArray(IOUtil.readByteArray(in));
    }

    @Override
    public Object readObj(BufferedInput in) throws IOException {
        return in.readByteArray();
    }
}

