/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.kit;

import com.devexperts.qd.QDAgent;
import com.devexperts.qd.ng.RecordCursor;
import java.util.Arrays;

public abstract class ArrayListAttachmentStrategy<T, C>
implements QDAgent.AttachmentStrategy<Object> {
    @Override
    public Object updateAttachment(Object oldAttachment, RecordCursor cursor, boolean remove) {
        Object[] objectArray;
        Object att = cursor.getAttachment();
        if (oldAttachment == null) {
            return remove ? null : att;
        }
        if (att == null) {
            return oldAttachment;
        }
        if (oldAttachment instanceof Object[]) {
            Object[] a = oldAttachment;
            return remove ? this.removeAttachment(a, att) : this.addAttachment(a, att);
        }
        if (remove) {
            return att.equals(oldAttachment) && !this.decrementAndNotEmpty(oldAttachment) ? null : oldAttachment;
        }
        if (att.equals(oldAttachment) && this.incrementCombines(oldAttachment)) {
            objectArray = oldAttachment;
        } else {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = oldAttachment;
            objectArray = objectArray2;
            objectArray2[1] = att;
        }
        return objectArray;
    }

    private Object addAttachment(Object[] a, Object att) {
        int i;
        for (i = 0; i < a.length && a[i] != null; ++i) {
            if (!att.equals(a[i]) || !this.incrementCombines(a[i])) continue;
            return a;
        }
        if (i == a.length) {
            a = Arrays.copyOf(a, a.length * 2);
        }
        a[i] = att;
        return a;
    }

    private Object removeAttachment(Object[] a, Object att) {
        for (int i = 0; i < a.length && a[i] != null; ++i) {
            if (!att.equals(a[i])) continue;
            if (this.decrementAndNotEmpty(a[i])) {
                return a;
            }
            if (i == 0 && a[1] == null) {
                return null;
            }
            System.arraycopy(a, i + 1, a, i, a.length - i - 1);
            a[a.length - 1] = null;
            break;
        }
        return a;
    }

    public void processEach(RecordCursor cursor, C ctx) {
        Object att = cursor.getAttachment();
        if (att instanceof Object[]) {
            Object[] a;
            for (Object o : a = (Object[])att) {
                if (o == null) break;
                this.process(cursor, o, ctx);
            }
        } else {
            this.process(cursor, att, ctx);
        }
    }

    protected boolean incrementCombines(T attachment) {
        return false;
    }

    protected boolean decrementAndNotEmpty(T attachment) {
        return false;
    }

    protected abstract void process(RecordCursor var1, T var2, C var3);
}

