/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.kit;

import com.devexperts.io.BufferedInput;
import com.devexperts.io.BufferedOutput;
import com.devexperts.qd.DataIntField;
import com.devexperts.qd.SerialFieldType;
import com.devexperts.qd.kit.AbstractDataField;
import com.devexperts.qd.ng.RecordCursor;
import java.io.IOException;

public abstract class AbstractDataIntField
extends AbstractDataField
implements DataIntField {
    private static final String[] INT_STRING_CACHE = new String[1001];

    AbstractDataIntField(int index, String name, SerialFieldType serialType) {
        super(index, name, serialType);
    }

    @Override
    public String getString(RecordCursor cursor) {
        return this.toString(cursor.getInt(this.getIndex()));
    }

    @Override
    public void setString(RecordCursor cursor, String value) {
        cursor.setInt(this.getIndex(), this.parseString(value));
    }

    @Override
    public void write(BufferedOutput out, RecordCursor cursor) throws IOException {
        this.writeInt(out, cursor.getInt(this.getIndex()));
    }

    @Override
    public void read(BufferedInput in, RecordCursor cursor) throws IOException {
        cursor.setInt(this.getIndex(), this.readInt(in));
    }

    @Override
    public String toString(int value) {
        if (value >= 0 && value < INT_STRING_CACHE.length) {
            String s = INT_STRING_CACHE[value];
            return s != null ? s : Integer.toString(value);
        }
        return Integer.toString(value);
    }

    @Override
    public int parseString(String value) {
        return Integer.parseInt(value);
    }

    @Override
    public double toDouble(int value) {
        if (value == Integer.MAX_VALUE) {
            return Double.POSITIVE_INFINITY;
        }
        if (value == Integer.MIN_VALUE) {
            return Double.NEGATIVE_INFINITY;
        }
        return value;
    }

    @Override
    public int toInt(double value) {
        return (int)value;
    }

    @Override
    public boolean equals(int value1, int value2) {
        return value1 == value2;
    }
}

