/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.kit;

import com.devexperts.qd.DataField;
import com.devexperts.qd.DataRecord;
import com.devexperts.qd.SerialFieldType;

public abstract class AbstractDataField
implements DataField {
    private DataRecord record;
    private final int index;
    private final String name;
    private String localName;
    private String propertyName;
    private final SerialFieldType serialType;

    AbstractDataField(int index, String name, SerialFieldType serialType) {
        if (index < 0) {
            throw new IllegalArgumentException("index < 0");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.index = index;
        this.name = name;
        this.serialType = serialType;
    }

    public final synchronized void setRecord(DataRecord record) {
        if (this.record != record && this.record != null) {
            throw new IllegalStateException("Parent record already set to different instance");
        }
        String prefix = record.getName() + ".";
        if (!this.name.startsWith(prefix)) {
            throw new IllegalArgumentException("Field name must start with record name and dot, but '" + this.name + "' does not start with'" + prefix + "'");
        }
        this.record = record;
        this.localName = this.name.substring(prefix.length());
        this.propertyName = AbstractDataField.getDefaultPropertyName(this.localName);
    }

    public final String toString() {
        return this.name;
    }

    @Override
    public final DataRecord getRecord() {
        DataRecord result = this.record;
        if (result == null) {
            throw new IllegalStateException("Trying to get parent record when it is not initialized yet");
        }
        return result;
    }

    @Override
    public final int getIndex() {
        return this.index;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final String getLocalName() {
        String result = this.localName;
        if (result == null) {
            throw new IllegalStateException("Trying to get local name when parent record is not initialized yet");
        }
        return result;
    }

    @Override
    public String getPropertyName() {
        String result = this.propertyName;
        if (result == null) {
            throw new IllegalStateException("Trying to get property name when parent record is not initialized yet");
        }
        return result;
    }

    void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    @Override
    public final SerialFieldType getSerialType() {
        return this.serialType;
    }

    public static String getDefaultPropertyName(String localName) {
        return localName.replace(".", "");
    }
}

