/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.impl.matrix.management;

import java.util.concurrent.atomic.AtomicLongArray;

public class RecordCounters {
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private int[] count = EMPTY_INT_ARRAY;
    private int[] next = EMPTY_INT_ARRAY;
    private int last = -1;

    public void prepare(int n) {
        this.count = this.resizeIfNeeded(this.count, n);
        this.next = this.resizeIfNeeded(this.next, n);
    }

    private int[] resizeIfNeeded(int[] a, int n) {
        if (a.length >= n) {
            return a;
        }
        int[] b = new int[n];
        System.arraycopy(a, 0, b, 0, a.length);
        return b;
    }

    public void count(int rid) {
        if (this.count[rid] == 0) {
            this.next[rid] = this.last;
            this.last = rid;
        }
        int n = rid;
        this.count[n] = this.count[n] + 1;
    }

    public boolean flushAndClear(AtomicLongArray arr) {
        int rid = this.last;
        if (rid < 0) {
            return false;
        }
        do {
            arr.addAndGet(rid, this.count[rid]);
            this.count[rid] = 0;
        } while ((rid = this.next[rid]) >= 0);
        this.last = -1;
        return true;
    }
}

