/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.impl.matrix.management;

import com.devexperts.logging.Logging;
import com.devexperts.qd.DataScheme;
import com.devexperts.qd.QDContract;
import com.devexperts.qd.impl.matrix.Collector;
import com.devexperts.qd.impl.matrix.management.CollectorCounters;
import com.devexperts.qd.impl.matrix.management.CollectorManagementFactory;
import com.devexperts.qd.impl.matrix.management.CollectorOperation;
import com.devexperts.services.Services;
import com.devexperts.util.SystemProperties;
import com.devexperts.util.TimePeriod;
import java.util.EnumSet;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;

public class CollectorManagement {
    protected static final Logging log = Logging.getLogging(CollectorManagement.class);
    private static final CollectorManagementFactory FACTORY = Services.createService(CollectorManagementFactory.class, null, null);
    public static final int DEFAULT_SUBSCRIPTION_BUCKET = 10000;
    public static final int DEFAULT_DISTRIBUTION_BUCKET = 100000;
    public static final int DEFAULT_INTERLEAVE = 4;
    public static final int DEFAULT_AGENT_BUFFER_SIZE_DEFAULT = SystemProperties.getIntProperty("com.devexperts.qd.impl.matrix.Agent.MaxBufferSize", 1000000);
    public static final int DEFAULT_MAX_DISTRIBUTION_SPINS = 8;
    public static final String DEFAULT_BUFFER_OVERFLOW_LOG_INTERVAL = "10s";
    public static final String DEFAULT_LOCK_WAIT_LOG_INTERVAL = "10s";
    public static final String DEFAULT_USE_LOCK_PRIORITY = ".*Data";
    public static final String DEFAULT_USE_LOCK_COUNTERS = "";
    protected final DataScheme scheme;
    protected final QDContract contract;
    protected int subscriptionBucket = 10000;
    protected int distributionBucket = 100000;
    protected int interleave = 4;
    protected int agentBufferSizeDefault = DEFAULT_AGENT_BUFFER_SIZE_DEFAULT;
    protected int maxDistributionSpins = 8;
    protected TimePeriod bufferOverflowLogInterval = TimePeriod.valueOf("10s");
    protected TimePeriod lockWaitLogInterval = TimePeriod.valueOf("10s");
    protected OperationSet useLockPriority = new OperationSet(".*Data");
    protected OperationSet useLockCounters = new OperationSet("");

    public static CollectorManagement getInstance(DataScheme scheme, QDContract contract, String keyProperties) {
        return FACTORY == null ? new CollectorManagement(scheme, contract) : FACTORY.getInstance(scheme, contract, keyProperties);
    }

    protected CollectorManagement(DataScheme scheme, QDContract contract) {
        this.scheme = scheme;
        this.contract = contract;
    }

    public QDContract getContract() {
        return this.contract;
    }

    public int getSubscriptionBucket() {
        return this.subscriptionBucket;
    }

    public int getDistributionBucket() {
        return this.distributionBucket;
    }

    public int getInterleave() {
        if (this.contract != QDContract.TICKER) {
            throw new UnsupportedOperationException("Interleave is not supported");
        }
        return this.interleave;
    }

    public int getAgentBufferSizeDefault() {
        if (this.contract == QDContract.TICKER) {
            throw new UnsupportedOperationException("AgentBufferSizeDefault is not supported");
        }
        return this.agentBufferSizeDefault;
    }

    public int getMaxDistributionSpins() {
        return this.maxDistributionSpins;
    }

    public long getBufferOverflowLogIntervalSeconds() {
        return TimeUnit.MILLISECONDS.toSeconds(this.bufferOverflowLogInterval.getTime());
    }

    public long getLockWaitLogIntervalNanos() {
        return TimeUnit.MILLISECONDS.toNanos(this.lockWaitLogInterval.getTime());
    }

    public boolean useLockPriority(CollectorOperation op) {
        return this.useLockPriority.set.contains((Object)op);
    }

    public boolean useLockCounters(CollectorOperation op) {
        return this.useLockCounters.set.contains((Object)op);
    }

    public CollectorCounters createCounters() {
        return new CollectorCounters();
    }

    public void addCollector(Collector collector) {
    }

    public void removeCollector(Collector collector) {
    }

    public void setFatalError(Throwable error) {
    }

    protected static class OperationSet {
        final String string;
        final EnumSet<CollectorOperation> set = EnumSet.noneOf(CollectorOperation.class);

        public OperationSet(String string) {
            this.string = string;
            Pattern pattern = Pattern.compile(string);
            for (CollectorOperation op : CollectorOperation.values()) {
                if (!pattern.matcher(op.toString()).matches()) continue;
                this.set.add(op);
            }
        }

        public String toString() {
            return this.string;
        }
    }
}

