/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.impl.matrix;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.DataScheme;
import com.devexperts.qd.QDContract;
import com.devexperts.qd.QDFilter;
import com.devexperts.qd.impl.AbstractAgent;
import com.devexperts.qd.impl.matrix.Hashing;
import com.devexperts.qd.impl.matrix.Mapper;
import com.devexperts.qd.impl.matrix.PayloadBits;
import com.devexperts.qd.impl.matrix.RecordsContainer;
import com.devexperts.qd.impl.matrix.SubMatrix;
import com.devexperts.qd.impl.matrix.SubSnapshot;
import com.devexperts.qd.impl.matrix.VoidAgentBuilder;
import com.devexperts.qd.ng.EventFlag;
import com.devexperts.qd.ng.RecordCursor;
import com.devexperts.qd.ng.RecordListener;
import com.devexperts.qd.ng.RecordSink;
import com.devexperts.qd.ng.RecordSource;
import com.devexperts.qd.stats.QDStats;

class VoidAgent
extends AbstractAgent
implements RecordsContainer {
    private static final int STEP = 2;
    private static final int HISTORY_STEP = 4;
    private static final int VOID_TIME_SUB = 2;
    private static final int ATTACHMENT = 0;
    private final QDContract contract;
    private final DataScheme scheme;
    private final QDFilter filter;
    private volatile PayloadBitsSubMatrix sub;

    VoidAgent(VoidAgentBuilder builder) {
        super(builder.contract, builder);
        this.contract = builder.contract;
        this.scheme = builder.scheme;
        this.filter = builder.getFilter();
    }

    @Override
    public void setRecordListener(RecordListener listener) {
    }

    @Override
    public boolean retrieve(RecordSink sink) {
        return false;
    }

    @Override
    public synchronized void addSubscription(RecordSource source) {
        RecordCursor cur;
        while ((cur = source.next()) != null) {
            if (EventFlag.REMOVE_SYMBOL.in(cur.getEventFlags())) {
                this.removeSubInternal(cur);
                continue;
            }
            if (!this.filter.accept(this.contract, cur.getRecord(), cur.getCipher(), cur.getSymbol())) continue;
            this.addSubInternal(cur);
        }
    }

    @Override
    public synchronized void removeSubscription(RecordSource source) {
        RecordCursor cur;
        while ((cur = source.next()) != null) {
            this.removeSubInternal(cur);
        }
    }

    @Override
    public synchronized void setSubscription(RecordSource source) {
        RecordCursor cur;
        this.sub = null;
        while ((cur = source.next()) != null) {
            this.addSubInternal(cur);
        }
    }

    @Override
    public void close() {
    }

    @Override
    public void closeAndExamineDataBySubscription(RecordSink sink) {
    }

    @Override
    public QDStats getStats() {
        return QDStats.VOID;
    }

    @Override
    public boolean isSubscribed(DataRecord record, int cipher, String symbol, long time) {
        int rid;
        PayloadBitsSubMatrix sub = this.sub;
        if (sub == null) {
            return false;
        }
        int key = this.getKey(sub, cipher, symbol);
        int index = sub.getVolatileIndex(key, rid = record.getId(), 0);
        return ((SubMatrix)sub).isPayload(index) && (this.contract != QDContract.HISTORY || time >= sub.getLong(index + 2));
    }

    @Override
    public boolean examineSubscription(RecordSink sink) {
        PayloadBitsSubMatrix sub = this.sub;
        return sub != null && new SubSnapshot(sub, 2, this.contract, QDFilter.ANYTHING, this).retrieveSubscription(sink);
    }

    @Override
    public synchronized int getSubscriptionSize() {
        PayloadBitsSubMatrix sub = this.sub;
        return sub == null ? 0 : sub.payloadSize;
    }

    @Override
    public DataRecord getRecord(int rid) {
        return this.scheme.getRecord(rid);
    }

    private int getRid(DataRecord record) {
        if (record.getScheme() != this.scheme) {
            throw new IllegalArgumentException("Wrong record scheme: " + record);
        }
        return record.getId();
    }

    private int addKey(SubMatrix sub, int cipher, String symbol) {
        if ((cipher & 0xC0000000) == 0) {
            if (cipher != 0) {
                throw new IllegalArgumentException("Reserved cipher");
            }
            return sub.mapper.addKey(symbol);
        }
        return cipher;
    }

    private int getKey(SubMatrix sub, int cipher, String symbol) {
        if ((cipher & 0xC0000000) == 0) {
            if (cipher != 0) {
                throw new IllegalArgumentException("Reserved cipher");
            }
            return sub.mapper.getMapping().getKey(symbol);
        }
        return cipher;
    }

    private void addSubInternal(RecordCursor cur) {
        PayloadBitsSubMatrix sub = this.getOrCreateSub();
        if (this.needsRehash(sub)) {
            sub = this.rehash(sub);
        }
        int key = this.addKey(sub, cur.getCipher(), cur.getSymbol());
        int rid = this.getRid(cur.getRecord());
        int index = sub.addIndex(key, rid);
        sub.markPayload(index);
        if (this.hasAttachmentStrategy()) {
            sub.setObj(index, 0, this.updateAttachment(sub.getObj(index, 0), cur, false));
        }
        if (this.contract == QDContract.HISTORY) {
            sub.setLong(index + 2, cur.getTime());
        }
    }

    private void removeSubInternal(RecordCursor cur) {
        int rid;
        int key;
        PayloadBitsSubMatrix sub = this.getOrCreateSub();
        int index = sub.getIndex(key = this.getKey(sub, cur.getCipher(), cur.getSymbol()), rid = this.getRid(cur.getRecord()), 0);
        if (index == 0 || !sub.isPayload(index)) {
            return;
        }
        if (this.hasAttachmentStrategy()) {
            Object attachment = this.updateAttachment(sub.getObj(index, 0), cur, true);
            sub.setObj(index, 0, attachment);
            if (attachment != null) {
                return;
            }
        }
        sub.clearPayload(index);
    }

    private boolean needsRehash(PayloadBitsSubMatrix sub) {
        return Hashing.needRehash(sub.shift, sub.overallSize, sub.payloadSize, 29);
    }

    private PayloadBitsSubMatrix rehash(PayloadBitsSubMatrix sub) {
        this.sub = sub.rehash(29);
        return this.sub;
    }

    private PayloadBitsSubMatrix getOrCreateSub() {
        PayloadBitsSubMatrix sub = this.sub;
        if (sub != null) {
            return sub;
        }
        Mapper mapper = new Mapper(this);
        mapper.incMaxCounter(this.scheme.getRecordCount());
        this.sub = sub = new PayloadBitsSubMatrix(mapper, this.contract == QDContract.HISTORY ? 4 : 2, this.hasAttachmentStrategy() ? 0 : 1, 0, 0, 29);
        return sub;
    }

    private static class PayloadBitsSubMatrix
    extends SubMatrix {
        private final PayloadBits payloadBits;

        private PayloadBitsSubMatrix(Mapper mapper, int step, int objStep, int capacity, int prevMagic, int maxShift) {
            super(mapper, step, objStep, Integer.MAX_VALUE, capacity, prevMagic, maxShift, QDStats.VOID);
            this.payloadBits = new PayloadBits(this.matrix.length, step);
        }

        @Override
        PayloadBitsSubMatrix rehash(int maxShift) {
            PayloadBitsSubMatrix dest = new PayloadBitsSubMatrix(this.mapper, this.step, this.obj_step, this.payloadSize, this.magic, maxShift);
            this.rehashTo(dest);
            return dest;
        }

        @Override
        boolean isPayload(int index) {
            return this.payloadBits.isPayload(index);
        }

        @Override
        void markPayload(int index) {
            if (this.payloadBits.markPayload(index)) {
                this.updateAddedPayload();
            }
        }

        void clearPayload(int index) {
            if (this.payloadBits.clearPayload(index)) {
                this.updateRemovedPayload();
                this.clearIndexData(index, 2);
            }
        }
    }
}

