/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.impl.matrix;

import com.devexperts.qd.DataScheme;
import com.devexperts.qd.impl.matrix.CollectorDebug;
import com.devexperts.qd.impl.matrix.Hashing;
import com.devexperts.qd.impl.matrix.Mapper;
import com.devexperts.qd.impl.matrix.RecordCursorKeeper;
import com.devexperts.qd.impl.matrix.TickerMatrix;
import com.devexperts.qd.ng.RecordCursor;
import com.devexperts.qd.ng.RecordSink;
import com.devexperts.qd.stats.QDStats;

final class TickerStorage {
    private final TickerMatrix[] matrices;
    private final QDStats stats;

    TickerStorage(DataScheme scheme, Mapper mapper, QDStats stats, boolean withEventTimeSequence) {
        mapper.incMaxCounter(scheme.getRecordCount());
        this.matrices = new TickerMatrix[scheme.getRecordCount()];
        int i = this.matrices.length;
        while (--i >= 0) {
            this.matrices[i] = new TickerMatrix(scheme.getRecord(i), mapper, 0, 0, withEventTimeSequence);
        }
        this.stats = stats;
    }

    TickerMatrix getMatrix(int rid) {
        return this.matrices[rid];
    }

    private TickerMatrix rehashMatrixIfNeeded(int rid) {
        TickerMatrix matrix = this.matrices[rid];
        if (Hashing.needRehash(matrix.shift, matrix.overallSize, matrix.payloadSize, 29)) {
            matrix = this.matrices[rid] = matrix.rehash();
        }
        return matrix;
    }

    boolean putRecordCursor(int key, int rid, RecordCursor cursor, RecordCursorKeeper keeper) {
        return this.rehashMatrixIfNeeded(rid).putRecordCursor(key, rid, cursor, keeper, this.stats);
    }

    void removeRecord(int key, int rid) {
        this.matrices[rid].removeRecord(key, rid, this.stats);
    }

    boolean examineData(RecordSink sink) {
        RecordCursorKeeper keeper = new RecordCursorKeeper();
        int nExaminedInBatch = 0;
        for (TickerMatrix matrix : this.matrices) {
            if ((nExaminedInBatch = matrix.examineData(sink, keeper, nExaminedInBatch)) >= 0) continue;
            return true;
        }
        if (nExaminedInBatch > 0) {
            sink.flush();
        }
        return false;
    }

    void visitStorageSymbols(CollectorDebug.SymbolReferenceVisitor srv) {
        CollectorDebug.SymbolReferenceLocation srl = new CollectorDebug.SymbolReferenceLocation();
        srl.storage = true;
        for (TickerMatrix tm : this.matrices) {
            tm.visitTickerMatrixSymbols(srv, srl);
        }
    }
}

