/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.impl.matrix;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.impl.matrix.AbstractMatrix;
import com.devexperts.qd.impl.matrix.Collector;
import com.devexperts.qd.impl.matrix.CollectorDebug;
import com.devexperts.qd.impl.matrix.Mapper;
import com.devexperts.qd.impl.matrix.RecordCursorKeeper;
import com.devexperts.qd.ng.RecordCursor;
import com.devexperts.qd.ng.RecordMode;
import com.devexperts.qd.ng.RecordSink;
import com.devexperts.qd.stats.QDStats;

final class TickerMatrix
extends AbstractMatrix {
    private final DataRecord record;
    private final boolean withEventTimeSequence;
    private final int intOffset;
    private final int objOffset;

    TickerMatrix(DataRecord record, Mapper mapper, int capacity, int prev_magic, boolean withEventTimeSequence) {
        super(mapper, record.getIntFieldCount() + 1 + (withEventTimeSequence ? 2 : 0), record.getObjFieldCount(), capacity, prev_magic, 29);
        this.record = record;
        this.withEventTimeSequence = withEventTimeSequence;
        this.intOffset = 1 + (withEventTimeSequence ? 2 : 0);
        this.objOffset = 0;
    }

    TickerMatrix rehash() {
        TickerMatrix dest = new TickerMatrix(this.record, this.mapper, this.payloadSize, this.magic, this.withEventTimeSequence);
        this.startRehash();
        int index = this.matrix.length;
        while ((index -= this.step) > 0) {
            int key = this.matrix[index];
            if ((key & 0xE0000000) != 0) {
                int dest_index = dest.getIndex(key, -1);
                if (dest.matrix[dest_index] != 0) {
                    throw new IllegalStateException("Repeated key");
                }
                System.arraycopy(this.matrix, index, dest.matrix, dest_index, this.step);
                if (this.obj_step != 0) {
                    System.arraycopy(this.obj_matrix, index / this.step * this.obj_step, dest.obj_matrix, dest_index / this.step * this.obj_step, this.obj_step);
                }
                ++dest.overallSize;
                dest.addPayload();
                continue;
            }
            if (key == 0 || key == 1) continue;
            this.mapper.decCounter(key | 0x20000000);
        }
        if (dest.overallSize != this.payloadSize || dest.payloadSize != this.payloadSize) {
            throw new IllegalStateException("Payload integrity corrupted.");
        }
        return dest;
    }

    boolean putRecordCursor(int key, int rid, RecordCursor cursor, RecordCursorKeeper keeper, QDStats stats) {
        int index = this.getOrReuseIndex(key);
        boolean inserted = this.addIndex(key, index);
        RecordCursor.Owner owner = keeper.getForTickerMatrix(this, false);
        owner.setSymbol(cursor.getCipher(), cursor.getSymbol());
        owner.setOffsets(index + this.intOffset, this.obj_step == 0 ? 0 : index / this.step * this.obj_step + this.objOffset);
        RecordCursor to = owner.cursor();
        boolean changed = this.record.update(cursor, to);
        if (changed) {
            to.setEventTimeSequence(cursor.getEventTimeSequence());
        }
        if (inserted) {
            stats.updateAdded(rid);
        } else if (changed) {
            stats.updateChanged(rid);
        }
        return inserted || changed;
    }

    private int getOrReuseIndex(int key) {
        int test_key;
        int index = this.getIndex(key, -1);
        if (this.matrix[index] != 0 || (key & 0xC0000000) != 0) {
            return index;
        }
        index = (key * this.magic >>> this.shift) * this.step;
        key &= 0xDFFFFFFF;
        while ((test_key = this.matrix[index]) != key) {
            if (test_key == 0) {
                if (index > 0) {
                    return index;
                }
                index = this.matrix.length;
            }
            index -= this.step;
        }
        return index;
    }

    private boolean addIndex(int key, int index) {
        int prev_key = this.matrix[index];
        if (prev_key == key) {
            return false;
        }
        if (key == 0) {
            throw new IllegalArgumentException("Undefined key");
        }
        if (prev_key != 0) {
            if ((prev_key | 0x20000000) != key) {
                throw new IllegalArgumentException("Reusing wrong key slot");
            }
        } else {
            if ((key & 0xC0000000) == 0) {
                this.mapper.incCounter(key);
            }
            ++this.overallSize;
        }
        this.addPayload();
        this.matrix[index] = key;
        return true;
    }

    boolean getRecordData(int key, RecordSink sink, RecordCursorKeeper keeper, int mark, Object attachment) {
        int index;
        int cipher = key;
        String symbol = null;
        if ((key & 0xC0000000) == 0) {
            cipher = 0;
            symbol = this.mapper.getSymbol(key);
            if (this.mapping != null) {
                key = this.mapping.getKey(symbol);
            }
        }
        if ((index = this.getIndex(key, 0)) == 0) {
            return false;
        }
        this.getRecordInternal(index, cipher, symbol, sink, keeper, mark, attachment);
        return true;
    }

    void setupOwner(RecordCursor.Owner owner, boolean readOnly) {
        owner.setReadOnly(readOnly);
        owner.setRecord(this.record, this.withEventTimeSequence ? RecordMode.TIMESTAMPED_DATA : RecordMode.DATA);
        owner.setArrays(this.matrix, this.obj_matrix);
    }

    private void getRecordInternal(int index, int cipher, String symbol, RecordSink sink, RecordCursorKeeper keeper, int mark, Object attachment) {
        RecordCursor.Owner owner = keeper.getForTickerMatrix(this, true);
        owner.setSymbol(cipher, symbol);
        owner.setOffsets(index + this.intOffset, this.obj_step == 0 ? 0 : index / this.step * this.obj_step + this.objOffset);
        owner.setTimeMark(mark);
        owner.setAttachment(attachment);
        sink.append(owner.cursor());
    }

    void removeRecord(int key, int rid, QDStats stats) {
        int index = this.getIndex(key, 0);
        if (index == 0) {
            return;
        }
        if (--this.payloadSize < 0) {
            throw new IllegalStateException("Payload size underflow");
        }
        this.matrix[index] = (key & 0xC0000000) != 0 ? 1 : key & 0xDFFFFFFF;
        this.clearIndexData(index, 1);
        stats.updateRemoved(rid);
    }

    boolean hasRecord(int key) {
        return this.getIndex(key, 0) != 0;
    }

    boolean isAvailable(int cipher, String symbol) {
        return this.getIndex(cipher, symbol) != 0;
    }

    int getInt(int cipher, String symbol, int int_field_index) {
        return this.matrix[this.getIndex(cipher, symbol) + this.intOffset + int_field_index];
    }

    Object getObj(int cipher, String symbol, int obj_field_index) {
        return this.obj_matrix[this.getIndex(cipher, symbol) / this.step * this.obj_step + this.objOffset + obj_field_index];
    }

    void getData(RecordCursor.Owner owner, int cipher, String symbol) {
        int index = this.getIndex(cipher, symbol);
        this.getDataAt(index, owner, cipher, symbol);
    }

    public boolean getDataIfAvailable(RecordCursor.Owner owner, int cipher, String symbol) {
        int index = this.getIndex(cipher, symbol);
        if (index == 0) {
            return false;
        }
        this.getDataAt(index, owner, cipher, symbol);
        return true;
    }

    private void getDataAt(int index, RecordCursor.Owner owner, int cipher, String symbol) {
        owner.setReadOnly(true);
        owner.setSymbol(cipher, symbol);
        owner.setRecord(this.record, this.withEventTimeSequence ? RecordMode.TIMESTAMPED_DATA : RecordMode.DATA);
        owner.setArrays(this.matrix, this.obj_matrix);
        owner.setOffsets(index + this.intOffset, this.obj_step == 0 ? 0 : index / this.step * this.obj_step + this.objOffset);
    }

    int examineData(RecordSink sink, RecordCursorKeeper keeper, int nExaminedInBatch) {
        int index = this.matrix.length;
        while ((index -= this.step) >= 0) {
            int key;
            if ((this.matrix[index] & 0xE0000000) == 0) continue;
            int cipher = key = this.matrix[index];
            String symbol = null;
            if ((key & 0xC0000000) == 0) {
                cipher = 0;
                symbol = this.getMapping().getSymbolIfPresent(key);
                if (symbol == null) continue;
            }
            if (!sink.hasCapacity()) {
                if (nExaminedInBatch > 0) {
                    sink.flush();
                }
                return -1;
            }
            this.getRecordInternal(index, cipher, symbol, sink, keeper, 0, null);
            if (++nExaminedInBatch < Collector.EXAMINE_BATCH_SIZE) continue;
            sink.flush();
            nExaminedInBatch = 0;
        }
        return nExaminedInBatch;
    }

    void examineDataAlways(int key, int cipher, String symbol, RecordSink sink, RecordCursorKeeper keeper, Object attachment) {
        int index = this.getIndex(key, 0);
        if (index != 0) {
            this.getRecordInternal(index, cipher, symbol, sink, keeper, 0, attachment);
        }
    }

    private void addPayload() {
        if (++this.payloadSize > this.overallSize) {
            throw new IllegalStateException("Payload size overflow");
        }
    }

    public String toString() {
        return "TickerMatrix#" + this.record.getId();
    }

    void visitTickerMatrixSymbols(CollectorDebug.SymbolReferenceVisitor srv, CollectorDebug.SymbolReferenceLocation srl) {
        srl.index = 0;
        srv.visitSubMatrix(srl);
        int rid = this.record.getId();
        int index = this.matrix.length;
        while ((index -= this.step) >= 0) {
            boolean payload;
            int key = this.getInt(index + 0);
            if (key == 0 || key == 1) continue;
            srl.index = index;
            if ((key & 0xC0000000) != 0) {
                srv.visitSymbolReference(key, rid, true, srl);
                continue;
            }
            boolean bl = payload = (key & 0x20000000) != 0;
            if (!payload) {
                key |= 0x20000000;
            }
            srv.visitSymbolReference(key, rid, payload, srl);
        }
    }
}

