/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.impl.matrix;

import com.devexperts.qd.DataIntField;
import com.devexperts.qd.DataObjField;
import com.devexperts.qd.DataRecord;
import com.devexperts.qd.QDAgent;
import com.devexperts.qd.QDCollector;
import com.devexperts.qd.QDTicker;
import com.devexperts.qd.impl.matrix.Agent;
import com.devexperts.qd.impl.matrix.AgentProcessor;
import com.devexperts.qd.impl.matrix.Collector;
import com.devexperts.qd.impl.matrix.CollectorDebug;
import com.devexperts.qd.impl.matrix.Distribution;
import com.devexperts.qd.impl.matrix.Distributor;
import com.devexperts.qd.impl.matrix.SubMatrix;
import com.devexperts.qd.impl.matrix.TickerStorage;
import com.devexperts.qd.impl.matrix.management.CollectorOperation;
import com.devexperts.qd.ng.RecordCursor;
import com.devexperts.qd.ng.RecordSink;
import com.devexperts.qd.ng.RecordSource;
import com.devexperts.qd.stats.QDStats;
import com.devexperts.util.SystemProperties;

class Ticker
extends Collector
implements QDTicker {
    private static final int RETRIEVE_BATCH_SIZE = SystemProperties.getIntProperty(Ticker.class, "retrieveBatchSize", 100, 1, Integer.MAX_VALUE);
    private final TickerStorage storage;

    Ticker(QDCollector.Builder<?> builder) {
        super(builder, false, true);
        this.storage = new TickerStorage(this.scheme, this.mapper, this.statsStorage, builder.hasEventTimeSequence());
    }

    @Override
    Agent createAgentInternal(int number, QDAgent.Builder builder, QDStats stats) {
        Agent agent = new Agent(this, number, builder, stats);
        agent.sub = new SubMatrix(this.mapper, 7, builder.getAttachmentStrategy() == null ? 0 : 1, 4, 0, 0, 29, stats.create(QDStats.SType.AGENT_SUB));
        return agent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean retrieveDataImpl(Agent agent, RecordSink sink, boolean snapshotOnly) {
        if (agent.isClosed()) {
            return false;
        }
        agent.localLock.lock(CollectorOperation.RETRIEVE_DATA);
        try {
            boolean bl = this.retrieveDataLLocked(agent, sink, snapshotOnly);
            return bl;
        }
        finally {
            agent.localLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean retrieveDataLLocked(Agent agent, RecordSink sink, boolean snapshotOnly) {
        if (agent.isClosed()) {
            return false;
        }
        try {
            boolean moreUpdate;
            boolean moreSnapshot = !agent.snapshotQueue.isEmpty();
            boolean bl = moreUpdate = !snapshotOnly && !agent.updateQueue.isEmpty();
            while (moreSnapshot || moreUpdate) {
                if (!moreUpdate) {
                    agent.nSnapshotRetrieved = 0;
                }
                if (agent.nSnapshotRetrieved < RETRIEVE_BATCH_SIZE && moreSnapshot) {
                    int nRetrieveLimit = RETRIEVE_BATCH_SIZE - agent.nSnapshotRetrieved;
                    int nRetrievedWithBit = agent.snapshotQueue.retrieveForTicker(this, agent, sink, nRetrieveLimit, 5);
                    int nRetrieved = nRetrievedWithBit & Integer.MAX_VALUE;
                    agent.nSnapshotRetrieved += nRetrieved;
                    agent.nRetrieved += nRetrieved;
                    if ((nRetrievedWithBit & Integer.MIN_VALUE) != 0) {
                        boolean bl2 = true;
                        return bl2;
                    }
                    if (agent.snapshotQueue.isEmpty()) {
                        moreSnapshot = false;
                    }
                }
                if (!moreSnapshot) {
                    agent.nSnapshotRetrieved = RETRIEVE_BATCH_SIZE;
                }
                if (agent.nSnapshotRetrieved <= 0 || !moreUpdate) continue;
                int nRetrievedWithBit = agent.updateQueue.retrieveForTicker(this, agent, sink, agent.nSnapshotRetrieved, 6);
                int nRetrieved = nRetrievedWithBit & Integer.MAX_VALUE;
                agent.nSnapshotRetrieved -= nRetrieved;
                agent.nRetrieved += nRetrieved;
                if ((nRetrievedWithBit & Integer.MIN_VALUE) != 0) {
                    boolean bl3 = true;
                    return bl3;
                }
                if (!agent.updateQueue.isEmpty()) continue;
                moreUpdate = false;
            }
            boolean bl4 = false;
            return bl4;
        }
        finally {
            this.countRetrieval(agent);
        }
    }

    boolean getRecordData(Agent agent, RecordSink sink, int key, int rid, int mark, Object attachment) {
        return this.storage.getMatrix(rid).getRecordData(key, sink, agent.retrievalKeeper, mark, attachment);
    }

    @Override
    boolean totalRecordRemoved(int key, int rid, SubMatrix tsub, int tindex) {
        super.totalRecordRemoved(key, rid, tsub, tindex);
        if (!this.shouldStoreEverything(key, rid)) {
            this.storage.removeRecord(key, rid);
        }
        return true;
    }

    @Override
    void enqueueAddedRecord(Agent agent, SubMatrix asub, int aindex) {
        if (agent.hasVoidRecordListener()) {
            return;
        }
        int snapshot = asub.getInt(aindex + 5);
        if ((snapshot & Integer.MIN_VALUE) != 0) {
            return;
        }
        if ((asub.getInt(aindex + 6) & Integer.MIN_VALUE) != 0) {
            snapshot = 0;
        }
        asub.setInt(aindex + 5, snapshot | Integer.MIN_VALUE);
        int key = asub.getInt(aindex + 0);
        int rid = asub.getInt(aindex + 1);
        if (!this.storage.getMatrix(rid).hasRecord(key)) {
            return;
        }
        if (agent.snapshotQueue.linkToQueue(agent, aindex, 5, true)) {
            this.subNotifyAccumulator |= 4;
        }
        if (agent.updateQueue.linkToQueue(agent, aindex, 6, true)) {
            this.subNotifyAccumulator |= 8;
        }
    }

    @Override
    void dequeueRemovedRecord(Agent agent, SubMatrix asub, int aindex) {
        if ((asub.getInt(aindex + 5) & Integer.MIN_VALUE) == 0 && (asub.getInt(aindex + 6) & Integer.MIN_VALUE) != 0) {
            asub.setInt(aindex + 5, 0);
        }
        agent.snapshotQueue.resetQueueBit(agent, aindex, 5);
        agent.updateQueue.resetQueueBit(agent, aindex, 6);
        agent.snapshotQueue.cleanupEmptyHeadForTicker(agent, aindex, 5);
        agent.updateQueue.cleanupEmptyHeadForTicker(agent, aindex, 6);
    }

    @Override
    int getNotificationBits(Agent agent) {
        if (!agent.snapshotQueue.isEmpty()) {
            return -1073741824;
        }
        return !agent.updateQueue.isEmpty() ? 0x40000000 : 0;
    }

    @Override
    boolean processRecordSourceGLocked(Distributor distributor, Distribution dist, RecordSource source) {
        RecordCursor cursor;
        AgentProcessor processor = dist.getProcessor(this.management.getInterleave());
        SubMatrix tsub = this.total.sub;
        while ((cursor = source.next()) != null) {
            DataRecord record = cursor.getRecord();
            int rid = this.getRid(record);
            dist.countIncomingRecord(rid);
            int cipher = cursor.getCipher();
            String symbol = cursor.getSymbol();
            if (this.storeEverything && !distributor.filter.accept(this.contract, record, cipher, symbol)) continue;
            int key = this.getKey(cipher, symbol);
            int tindex = tsub.getIndex(key, rid, 0);
            int nagent = tsub.getInt(tindex + 2);
            if (this.shouldStoreEverything(record, cipher, symbol)) {
                if (key == 0) {
                    key = this.mapper.addKey(symbol);
                }
            } else if (nagent <= 0) continue;
            if (!this.storage.putRecordCursor(key, rid, cursor, this.keeper)) continue;
            processor.processAgentsList(nagent, tsub.getInt(tindex + 3), cursor.getTimeMark(), rid);
            if (dist.hasCapacity()) continue;
            break;
        }
        processor.flush();
        return cursor != null;
    }

    @Override
    int processAgentDataUpdate(Distribution dist, RecordSource buffer, Agent agent) {
        boolean dirty = agent.subModCount != dist.getSubModCount(agent);
        SubMatrix asub = agent.sub;
        SubMatrix osub = dist.getSub(agent);
        int i = dist.firstIndex(agent);
        while (i > 0) {
            int aindex = dist.getPayload1(i);
            if (!dirty || asub.getInt((aindex = asub.getIndex(osub.getInt(aindex + 0), osub.getInt(aindex + 1), 0)) + 4) != 0) {
                int mark = dist.getPayload2(i);
                int snapshot = asub.getInt(aindex + 5);
                if (snapshot == Integer.MIN_VALUE) {
                    agent.snapshotQueue.linkToQueue(agent, aindex, 5, true);
                } else if (snapshot == 0) {
                    asub.setInt(aindex + 5, mark & Integer.MAX_VALUE);
                } else if ((asub.getInt(aindex + 6) & Integer.MIN_VALUE) == 0) {
                    asub.setInt(aindex + 5, snapshot | Integer.MIN_VALUE);
                }
                agent.updateQueue.linkToQueue(agent, aindex, 6, true);
            }
            i = dist.nextIndex(i);
        }
        return 0;
    }

    @Override
    void examineSubDataInternalByIndex(Agent agent, int aindex, RecordSink sink) {
        SubMatrix asub = agent.sub;
        int key = asub.getInt(aindex + 0);
        int rid = asub.getInt(aindex + 1);
        Object attachment = agent.hasAttachmentStrategy() ? asub.getObj(aindex, 0) : null;
        this.storage.getMatrix(rid).examineDataAlways(key, this.getCipher(key), this.getSymbol(key), sink, this.keeper, attachment);
    }

    @Override
    public boolean isAvailable(DataRecord record, int cipher, String symbol) {
        return this.storage.getMatrix(this.getRid(record)).isAvailable(cipher, symbol);
    }

    @Override
    public void remove(RecordSource source) {
        this.globalLock.lock(CollectorOperation.REMOVE_DATA);
        try {
            this.removeGLocked(source);
        }
        finally {
            this.globalLock.unlock();
        }
    }

    private void removeGLocked(RecordSource source) {
        RecordCursor cur;
        while ((cur = source.next()) != null) {
            int rid = this.getRid(cur.getRecord());
            int key = this.getKey(cur.getCipher(), cur.getSymbol());
            this.storage.removeRecord(key, rid);
        }
    }

    @Override
    public int getInt(DataIntField field, int cipher, String symbol) {
        return this.storage.getMatrix(this.getRid(field.getRecord())).getInt(cipher, symbol, field.getIndex());
    }

    @Override
    public Object getObj(DataObjField field, int cipher, String symbol) {
        return this.storage.getMatrix(this.getRid(field.getRecord())).getObj(cipher, symbol, field.getIndex());
    }

    @Override
    public void getData(RecordCursor.Owner owner, DataRecord record, int cipher, String symbol) {
        this.storage.getMatrix(this.getRid(record)).getData(owner, cipher, symbol);
    }

    @Override
    public boolean getDataIfAvailable(RecordCursor.Owner owner, DataRecord record, int cipher, String symbol) {
        return this.storage.getMatrix(this.getRid(record)).getDataIfAvailable(owner, cipher, symbol);
    }

    @Override
    public boolean getDataIfSubscribed(RecordCursor.Owner owner, DataRecord record, int cipher, String symbol) {
        if (!this.total.isSubscribed(record, cipher, symbol, 0L)) {
            return false;
        }
        this.storage.getMatrix(this.getRid(record)).getData(owner, cipher, symbol);
        return true;
    }

    @Override
    public boolean examineData(RecordSink sink) {
        return this.storage.examineData(sink);
    }

    @Override
    public boolean examineDataBySubscription(RecordSink sink, RecordSource sub) {
        RecordCursor subCursor;
        RecordCursor.Owner dataOwner = RecordCursor.allocateOwner();
        int nExaminedInBatch = 0;
        while ((subCursor = sub.next()) != null) {
            if (!this.getDataIfAvailable(dataOwner, subCursor.getRecord(), subCursor.getCipher(), subCursor.getSymbol())) continue;
            if (!sink.hasCapacity()) {
                if (nExaminedInBatch > 0) {
                    sink.flush();
                }
                return true;
            }
            sink.append(dataOwner.cursor());
            if (++nExaminedInBatch < EXAMINE_BATCH_SIZE) continue;
            sink.flush();
            nExaminedInBatch = 0;
        }
        if (nExaminedInBatch > 0) {
            sink.flush();
        }
        return false;
    }

    @Override
    <T extends CollectorDebug.SymbolReferenceVisitor> T visitSymbols(T srv, CollectorDebug.RehashCrashInfo rci) {
        super.visitSymbols(srv, rci);
        this.storage.visitStorageSymbols(srv);
        return srv;
    }
}

