/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.impl.matrix;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.QDContract;
import com.devexperts.qd.QDFilter;
import com.devexperts.qd.impl.matrix.Agent;
import com.devexperts.qd.impl.matrix.Collector;
import com.devexperts.qd.impl.matrix.RecordsContainer;
import com.devexperts.qd.impl.matrix.SubMatrix;
import com.devexperts.qd.ng.RecordSink;

final class SubSnapshot {
    private final SubMatrix sub;
    private final int timeOffset;
    private final QDContract contract;
    private final QDFilter filter;
    private final RecordsContainer records;
    private int index;

    SubSnapshot(Agent agent, QDFilter filter) {
        this(agent.sub, agent == agent.collector.total ? 4 : 7, agent.collector.getContract(), filter, agent.collector);
    }

    SubSnapshot(SubMatrix sub, int timeOffset, QDContract contract, QDFilter filter, RecordsContainer records) {
        this.sub = sub;
        this.timeOffset = timeOffset;
        this.contract = contract;
        this.filter = filter;
        this.records = records;
        this.index = sub.matrix.length;
    }

    synchronized boolean retrieveSubscription(RecordSink sink) {
        if (this.index <= 0) {
            return false;
        }
        int nExaminedInBatch = 0;
        while ((this.index -= this.sub.step) > 0) {
            DataRecord record;
            int key;
            if (!this.sub.isSubscribed(this.index) || (key = this.sub.getVolatileInt(this.index + 0)) == 0) continue;
            int rid = this.sub.getInt(this.index + 1);
            long time = this.contract == QDContract.HISTORY ? this.sub.getLong(this.index + this.timeOffset) : 0L;
            int cipher = key;
            String symbol = null;
            if ((key & 0xC0000000) == 0) {
                cipher = 0;
                symbol = this.sub.getMapping().getSymbolIfPresent(key);
                if (symbol == null) continue;
            }
            if (!this.filter.accept(this.contract, record = this.records.getRecord(rid), cipher, symbol)) continue;
            if (!sink.hasCapacity()) {
                this.index += this.sub.step;
                break;
            }
            sink.visitRecord(record, cipher, symbol, time);
            if (++nExaminedInBatch < Collector.EXAMINE_BATCH_SIZE) continue;
            sink.flush();
            nExaminedInBatch = 0;
        }
        if (nExaminedInBatch > 0) {
            sink.flush();
        }
        return this.index > 0;
    }
}

