/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.impl.matrix;

import com.devexperts.qd.impl.matrix.Collector;
import com.devexperts.qd.impl.matrix.CollectorDebug;
import com.devexperts.qd.impl.matrix.Distributor;
import com.devexperts.qd.impl.matrix.Hashing;
import com.devexperts.qd.impl.matrix.SubMatrix;
import com.devexperts.qd.impl.matrix.SubSnapshot;
import com.devexperts.qd.impl.matrix.management.CollectorOperation;
import com.devexperts.qd.ng.AbstractRecordProvider;
import com.devexperts.qd.ng.RecordListener;
import com.devexperts.qd.ng.RecordMode;
import com.devexperts.qd.ng.RecordSink;
import com.devexperts.qd.stats.QDStats;
import com.devexperts.qd.stats.QDStatsContainer;
import com.devexperts.util.SystemProperties;

final class SubProvider
extends AbstractRecordProvider
implements QDStatsContainer {
    private static final int MAX_SUB_SHIFT = Hashing.getShift(SystemProperties.getIntProperty(SubProvider.class, "minSubSize", 2000));
    private static final int QUEUE_NEXT = 2;
    private static final int QUEUE_MARK = 3;
    private static final int TIME_SUB = 4;
    private static final int TIME_SUB_X = 5;
    final Collector collector;
    private final Distributor distributor;
    private final boolean is_added_provider;
    private final boolean has_time;
    private final RecordMode mode;
    private final QDStats stats;
    private volatile RecordListener listener;
    private SubMatrix sub;
    private int queue_head = -1;
    private int queue_tail = -1;

    SubProvider(Distributor distributor, boolean is_added_provider, QDStats stats) {
        RecordMode mode;
        this.distributor = distributor;
        this.is_added_provider = is_added_provider;
        this.has_time = is_added_provider && distributor.collector.hasTime;
        this.collector = distributor.collector;
        RecordMode recordMode = mode = this.has_time ? RecordMode.HISTORY_SUBSCRIPTION : RecordMode.SUBSCRIPTION;
        if (this.collector.hasEventTimeSequence()) {
            mode = mode.withEventTimeSequence();
        }
        this.mode = mode;
        this.stats = stats;
    }

    @Override
    public QDStats getStats() {
        return this.stats;
    }

    void closeStats() {
        this.stats.close();
    }

    boolean add(int key, int rid, long time) {
        this.rehashIfNeeded();
        boolean added = false;
        SubMatrix sub = this.sub;
        int index = sub.addIndex(key, rid);
        if (sub.getInt(index + 2) == 0) {
            int lindex = this.queue_tail;
            if (lindex < 0) {
                this.queue_head = index;
            } else {
                sub.setInt(lindex + 2, index);
            }
            this.queue_tail = index;
            sub.setInt(index + 2, -1);
        }
        if (sub.getInt(index + 3) == 0) {
            sub.setInt(index + 3, 1);
            sub.updateAddedPayload(rid);
            added = true;
        }
        if (this.has_time) {
            sub.setLong(index + 4, time);
        }
        return added;
    }

    void remove(int key, int rid) {
        SubMatrix sub = this.sub;
        int index = sub.getIndex(key, rid, 0);
        if (sub.getInt(index + 3) == 0) {
            return;
        }
        sub.setInt(index + 3, 0);
        sub.updateRemovedPayload(rid);
        if (this.has_time) {
            sub.setLong(index + 4, 0L);
        }
        if (this.queue_head == index) {
            int next;
            do {
                next = sub.getInt(index + 2);
                sub.setInt(index + 2, 0);
            } while ((index = next) > 0 && sub.getInt(index + 3) == 0);
            this.queue_head = index;
            if (index < 0) {
                this.queue_tail = -1;
            }
        }
        this.rehashIfNeeded();
    }

    private void rehashIfNeeded() {
        if (this.sub.needRehash(MAX_SUB_SHIFT)) {
            this.rehash();
        }
    }

    private void rehash() {
        SubMatrix osub = this.sub;
        SubMatrix asub = this.sub = osub.rehash(MAX_SUB_SHIFT);
        int oindex = this.queue_head;
        if (oindex > 0) {
            int lindex = -1;
            while (oindex > 0) {
                int aindex = asub.getIndex(osub.getInt(oindex), osub.getInt(oindex + 1), 0);
                if (aindex > 0) {
                    if (osub.getInt(oindex + 3) != 0) {
                        if (lindex < 0) {
                            this.queue_head = aindex;
                        } else {
                            asub.setInt(lindex + 2, aindex);
                        }
                        lindex = aindex;
                    } else {
                        asub.setInt(aindex + 2, 0);
                    }
                }
                oindex = osub.getInt(oindex + 2);
            }
            this.queue_tail = lindex;
            if (lindex < 0) {
                this.queue_head = -1;
            } else {
                asub.setInt(lindex + 2, -1);
            }
        }
    }

    void init() {
        this.sub = new SubMatrix(this.collector.mapper, this.has_time ? 6 : 4, 0, 3, 0, 0, 29, this.stats);
        this.collector.mapper.incMaxCounter(this.collector.scheme.getRecordCount());
    }

    void close() {
        this.queue_head = -1;
        if (this.sub != null) {
            this.sub.close();
            this.sub = null;
            this.collector.mapper.decMaxCounter(this.collector.scheme.getRecordCount());
        }
    }

    void notifyListenerIfQueued() {
        if (this.queue_head > 0) {
            this.notifyListener();
        }
    }

    void notifyListener() {
        RecordListener listener = this.listener;
        if (listener != null) {
            try {
                listener.recordsAvailable(this);
            }
            catch (Throwable t) {
                this.collector.errorHandler.handleSubscriptionError(this, t);
            }
        }
    }

    @Override
    public RecordMode getMode() {
        return this.mode;
    }

    @Override
    public boolean retrieve(RecordSink sink) {
        try {
            return this.retrieveImpl(sink);
        }
        catch (Throwable error) {
            this.collector.management.setFatalError(error);
            throw error;
        }
    }

    public boolean retrieveImpl(RecordSink sink) {
        if (sink != RecordSink.VOID) {
            this.distributor.initDistributorProviders();
        }
        return this.is_added_provider ? this.retrieveAddedSubscription(sink) : this.retrieveQueuedSubscription(sink);
    }

    private boolean retrieveAddedSubscription(RecordSink sink) {
        boolean notify_removed = false;
        SubSnapshot snapshot = this.distributor.getSnapshot();
        if (snapshot != null) {
            if (snapshot.retrieveSubscription(sink)) {
                return true;
            }
            this.distributor.clearSnapshot();
            notify_removed = true;
        }
        boolean has_more = this.retrieveQueuedSubscription(sink);
        if (notify_removed) {
            this.distributor.notifyRemoved();
        }
        return has_more;
    }

    private boolean retrieveQueuedSubscription(RecordSink sink) {
        if (!this.distributor.isActive() || this.distributor.getSnapshot() != null) {
            return false;
        }
        this.collector.globalLock.lock(CollectorOperation.RETRIEVE_SUBSCRIPTION);
        try {
            boolean bl = this.retrieveQueuedSubscriptionGLocked(sink);
            return bl;
        }
        finally {
            this.collector.globalLock.unlock();
        }
    }

    boolean retrieveQueuedSubscriptionGLocked(RecordSink sink) {
        if (!this.distributor.isActive() || this.distributor.getSnapshot() != null) {
            return false;
        }
        SubMatrix sub = this.sub;
        if (sub == null) {
            return false;
        }
        int index = this.queue_head;
        while (index > 0 && sink.hasCapacity()) {
            if (sub.getInt(index + 3) != 0) {
                int key = sub.getInt(index);
                int rid = sub.getInt(index + 1);
                int cipher = key;
                String symbol = null;
                if ((key & 0xC0000000) == 0) {
                    if (key == 0) {
                        throw new IllegalArgumentException("Undefined key.");
                    }
                    cipher = 0;
                    symbol = this.collector.mapper.getSymbol(key);
                }
                long time = 0L;
                if (this.has_time) {
                    time = sub.getLong(index + 4);
                }
                sink.visitRecord(this.collector.records[rid], cipher, symbol, time);
                sub.setInt(index + 3, 0);
                sub.updateRemovedPayload(rid);
                if (this.has_time) {
                    sub.setLong(index + 4, 0L);
                }
            }
            int next = sub.getInt(index + 2);
            sub.setInt(index + 2, 0);
            this.queue_head = index = next;
            if (index >= 0) continue;
            this.queue_tail = -1;
        }
        this.rehashIfNeeded();
        return this.queue_head > 0;
    }

    @Override
    public void setRecordListener(RecordListener listener) {
        if (this.listener == listener) {
            return;
        }
        this.listener = listener;
        if (this.is_added_provider) {
            this.notifyListener();
        }
    }

    void visitProviderSymbols(CollectorDebug.SymbolReferenceVisitor srv, CollectorDebug.SymbolReferenceLocation srl) {
        if (this.sub != null) {
            CollectorDebug.visitSubMatrixSymbols(srv, null, this.sub, srl);
        }
    }

    public String toString() {
        return "SubProvier(" + (this.is_added_provider ? "added" : "removed") + ") of " + this.distributor;
    }
}

