/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.impl.matrix;

import com.devexperts.qd.impl.matrix.AbstractMatrix;
import com.devexperts.qd.impl.matrix.Mapper;
import com.devexperts.qd.stats.QDStats;

class SubMatrix
extends AbstractMatrix {
    static final int KEY = 0;
    static final int RID = 1;
    private static final int MAGIC_RID = 1597687657;
    protected final int payloadOffset;
    protected final QDStats stats;

    SubMatrix(Mapper mapper, int step, int obj_step, int payloadOffset, int capacity, int prev_magic, int max_shift, QDStats stats) {
        super(mapper, step, obj_step, capacity, prev_magic, max_shift);
        this.payloadOffset = payloadOffset;
        this.stats = stats;
    }

    void closeStats() {
        this.stats.close();
    }

    int getVolatileIndex(int key, int rid, int miss_mask) {
        int test_key;
        int index = ((key + rid * 1597687657) * this.magic >>> this.shift) * this.step;
        while ((test_key = this.getVolatileInt(index + 0)) != key || this.matrix[index + 1] != rid) {
            if (test_key == 0) {
                if (index > 0) {
                    return index & miss_mask;
                }
                index = this.matrix.length;
            }
            index -= this.step;
        }
        return index;
    }

    int getIndex(int key, int rid, int miss_mask) {
        int test_key;
        int index = ((key + rid * 1597687657) * this.magic >>> this.shift) * this.step;
        while ((test_key = this.matrix[index + 0]) != key || this.matrix[index + 1] != rid) {
            if (test_key == 0) {
                if (index > 0) {
                    return index & miss_mask;
                }
                index = this.matrix.length;
            }
            index -= this.step;
        }
        return index;
    }

    int addIndex(int key, int rid) {
        int index = this.addIndexBegin(key, rid);
        this.addIndexComplete(index, key, rid);
        return index;
    }

    int addIndexBegin(int key, int rid) {
        int index = this.getIndex(key, rid, -1);
        if (this.matrix[index + 0] != 0) {
            return index;
        }
        if ((key & 0xC0000000) == 0 && this.mapper != null) {
            this.mapper.incCounter(key);
        }
        ++this.overallSize;
        if (this.payloadOffset == 0) {
            this.updateAddedPayload();
        }
        this.matrix[index + 1] = rid;
        return index;
    }

    void addIndexComplete(int index, int key, int rid) {
        if (this.matrix[index + 0] != 0) {
            return;
        }
        this.setVolatileInt(index + 0, key);
    }

    boolean isSubscribed(int index) {
        return this.isPayload(index);
    }

    boolean isPayload(int index) {
        return this.matrix[index + this.payloadOffset] != 0;
    }

    void markPayload(int index) {
        this.updateAddedPayload();
    }

    void updateAddedPayload(int rid) {
        this.stats.updateAdded(rid);
        this.updateAddedPayload();
    }

    void updateAddedPayload() {
        if (++this.payloadSize > this.overallSize) {
            throw new IllegalStateException("Payload size overflow");
        }
    }

    void updateRemovedPayload(int rid) {
        this.stats.updateRemoved(rid);
        this.updateRemovedPayload();
    }

    void updateRemovedPayload() {
        if (--this.payloadSize < 0) {
            throw new IllegalStateException("Payload size underflow");
        }
    }

    SubMatrix rehash(int maxShift) {
        SubMatrix dest = new SubMatrix(this.mapper, this.step, this.obj_step, this.payloadOffset, this.payloadSize, this.magic, maxShift, this.stats);
        this.rehashTo(dest);
        return dest;
    }

    void rehashTo(SubMatrix dest) {
        this.startRehash();
        dest.overallSize = this.payloadSize;
        int index = this.matrix.length;
        while ((index -= this.step) > 0) {
            int key = this.matrix[index + 0];
            if (key == 0) continue;
            if (this.isPayload(index)) {
                int rid = this.matrix[index + 1];
                int destIndex = dest.getIndex(key, rid, -1);
                if (dest.matrix[destIndex] != 0) {
                    throw new IllegalStateException("Repeated key detected");
                }
                dest.matrix[destIndex + 0] = key;
                dest.matrix[destIndex + 1] = rid;
                int i = this.step;
                while (--i > 1) {
                    dest.matrix[destIndex + i] = this.matrix[index + i];
                }
                if (this.obj_step != 0) {
                    int obj_index = index / this.step * this.obj_step;
                    int dest_obj_index = destIndex / this.step * this.obj_step;
                    int i2 = this.obj_step;
                    while (--i2 >= 0) {
                        dest.obj_matrix[dest_obj_index + i2] = this.obj_matrix[obj_index + i2];
                    }
                }
                dest.markPayload(destIndex);
                continue;
            }
            if ((key & 0xC0000000) != 0) continue;
            this.mapper.decCounter(key);
        }
        if (dest.payloadSize != this.payloadSize) {
            throw new IllegalStateException("Payload integrity corrupted");
        }
    }

    void close() {
        int index = this.matrix.length;
        while ((index -= this.step) > 0) {
            int key = this.matrix[index + 0];
            if (key == 0 || (key & 0xC0000000) != 0) continue;
            this.mapper.decCounter(key);
        }
    }
}

