/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.impl.matrix;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.QDAgent;
import com.devexperts.qd.QDCollector;
import com.devexperts.qd.QDStream;
import com.devexperts.qd.impl.matrix.Agent;
import com.devexperts.qd.impl.matrix.AgentIterator;
import com.devexperts.qd.impl.matrix.Collector;
import com.devexperts.qd.impl.matrix.Distribution;
import com.devexperts.qd.impl.matrix.Distributor;
import com.devexperts.qd.impl.matrix.SubMatrix;
import com.devexperts.qd.impl.matrix.management.CollectorOperation;
import com.devexperts.qd.ng.RecordCursor;
import com.devexperts.qd.ng.RecordMode;
import com.devexperts.qd.ng.RecordSink;
import com.devexperts.qd.ng.RecordSource;
import com.devexperts.qd.stats.QDStats;

class Stream
extends Collector
implements QDStream {
    private boolean enableWildcards;
    private final int wildcardCipher;

    Stream(QDCollector.Builder<?> builder) {
        super(builder, false, false);
        this.wildcardCipher = this.scheme.getCodec().getWildcardCipher();
    }

    @Override
    Agent createAgentInternal(int number, QDAgent.Builder builder, QDStats stats) {
        Agent agent = new Agent(this, number, builder, stats);
        agent.sub = new SubMatrix(this.mapper, 5, builder.getAttachmentStrategy() == null ? 0 : 1, 4, 0, 0, 29, stats.create(QDStats.SType.AGENT_SUB));
        return agent;
    }

    @Override
    RecordMode getAgentBufferMode(Agent agent) {
        RecordMode mode = agent.getMode();
        if (this.hasEventTimeSequence()) {
            mode = mode.withEventTimeSequence();
        }
        return mode;
    }

    @Override
    boolean keepInStreamBufferOnRefilter(Agent agent, RecordCursor cur) {
        SubMatrix asub = agent.sub;
        int index = asub.getIndex(this.getKey(cur.getCipher(), cur.getSymbol()), this.getRid(cur.getRecord()), 0);
        return asub.isPayload(index);
    }

    @Override
    void refilterStreamBuffersAfterSubscriptionChange(Agent agent) {
        agent.buffer.compactAndRefilter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean retrieveDataImpl(Agent agent, RecordSink sink, boolean snapshotOnly) {
        if (agent.isClosed() || snapshotOnly) {
            return false;
        }
        agent.localLock.lock(CollectorOperation.RETRIEVE_DATA);
        try {
            boolean bl = this.retrieveDataLLocked(agent, sink);
            return bl;
        }
        finally {
            agent.localLock.unlock();
        }
    }

    private boolean retrieveDataLLocked(Agent agent, RecordSink sink) {
        if (agent.isClosed()) {
            return false;
        }
        agent.nRetrieved += agent.buffer.retrieveData(sink, Integer.MAX_VALUE);
        this.countRetrieval(agent);
        if (agent.buffer.unblock()) {
            agent.localLock.signalAll();
        }
        return agent.buffer.hasNext();
    }

    @Override
    int getNotificationBits(Agent agent) {
        return agent.buffer.hasNext() ? 0x40000000 : 0;
    }

    @Override
    boolean processRecordSourceGLocked(Distributor distributor, Distribution dist, RecordSource source) {
        RecordCursor cursor;
        AgentIterator ait = dist.getAgentIterator();
        while ((cursor = source.next()) != null) {
            boolean possibleDuplicate;
            DataRecord record = cursor.getRecord();
            int rid = this.getRid(record);
            dist.countIncomingRecord(rid);
            int cipher = cursor.getCipher();
            String symbol = cursor.getSymbol();
            if (this.enableWildcards && !distributor.filter.accept(this.contract, record, cipher, symbol)) continue;
            int key = this.getKey(cipher, symbol);
            long position = cursor.getPosition();
            int prevDistSize = dist.size();
            Agent agent = ait.start(this, key, rid);
            while (agent != null) {
                dist.add(agent.number, position, 0, rid);
                agent = ait.next();
            }
            boolean bl = possibleDuplicate = dist.size() != prevDistSize;
            if (this.enableWildcards && key != this.wildcardCipher) {
                Agent agent2 = ait.start(this, this.wildcardCipher, rid);
                while (agent2 != null) {
                    if (!(possibleDuplicate && dist.isDuplicate(agent2.number, position) || !agent2.filter.getUpdatedFilter().accept(this.contract, record, cipher, symbol))) {
                        dist.add(agent2.number, position, 0, rid);
                    }
                    agent2 = ait.next();
                }
            }
            if (dist.hasCapacity()) continue;
            break;
        }
        return cursor != null;
    }

    @Override
    int processAgentDataUpdate(Distribution dist, RecordSource buffer, Agent agent) {
        int i = dist.firstIndex(agent);
        while (i > 0) {
            long position = dist.getPayloadLong(i);
            RecordCursor cursor = buffer.cursorAt(position);
            if (agent.buffer.blockNewRecord()) {
                return i;
            }
            if (!agent.buffer.dropNewRecord(cursor)) {
                RecordCursor writeCursor = agent.buffer.addDataAndCompactIfNeeded(cursor);
                writeCursor.setEventFlags(cursor.getEventFlags());
                writeCursor.setTimeMark(cursor.getTimeMark());
                if (this.hasEventTimeSequence()) {
                    writeCursor.setEventTimeSequence(cursor.getEventTimeSequence());
                }
                if (agent.hasAttachmentStrategy()) {
                    int rid;
                    int aindex;
                    SubMatrix asub;
                    Object attachment = null;
                    int key = this.getKey(cursor.getCipher(), cursor.getSymbol());
                    if (key != 0 && (asub = agent.sub).getInt((aindex = asub.getIndex(key, rid = this.getRid(cursor.getRecord()), 0)) + 4) != 0) {
                        attachment = asub.getObj(aindex, 0);
                    }
                    writeCursor.setAttachment(attachment);
                }
            }
            i = dist.nextIndex(i);
        }
        agent.buffer.dropOldRecords();
        agent.buffer.logDrops(agent);
        return 0;
    }

    @Override
    public void setEnableWildcards(boolean enableWildcards) {
        this.enableWildcards = enableWildcards;
    }

    @Override
    public boolean getEnableWildcards() {
        return this.enableWildcards;
    }

    @Override
    protected boolean isSubAllowed(Agent agent, DataRecord record, int cipher, String symbol) {
        return super.isSubAllowed(agent, record, cipher, symbol) && (this.enableWildcards || cipher != this.wildcardCipher);
    }
}

