/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.impl.matrix;

import java.util.Arrays;

class ProcessVersionTracker {
    private static final int HAS_WAITERS_FLAG = 262144;
    private int processVersion;
    private int[] inProcessVersions = new int[4];

    ProcessVersionTracker() {
    }

    synchronized int next() {
        this.processVersion = this.processVersion + 1 & 0x3FFFF;
        if (this.processVersion == 0) {
            this.processVersion = 1;
        }
        this.addImpl(this.processVersion);
        return this.processVersion;
    }

    private void addImpl(int v) {
        int n = this.inProcessVersions.length;
        for (int i = 0; i < n; ++i) {
            if (this.inProcessVersions[i] != 0) continue;
            this.inProcessVersions[i] = v;
            return;
        }
        this.inProcessVersions = Arrays.copyOf(this.inProcessVersions, 2 * n);
        this.inProcessVersions[n] = v;
    }

    synchronized void done(int v) {
        int i = this.findIndex(v);
        if (i < 0) {
            throw new IllegalStateException("Process version " + v + " should have been found");
        }
        if ((this.inProcessVersions[i] & 0x40000) != 0) {
            this.notifyAll();
        }
        this.inProcessVersions[i] = 0;
    }

    synchronized void waitWhileInProcess(int v) {
        int i;
        boolean wasInterrupted = false;
        while ((i = this.findIndex(v)) >= 0) {
            try {
                int n = i;
                this.inProcessVersions[n] = this.inProcessVersions[n] | 0x40000;
                this.wait();
            }
            catch (InterruptedException e) {
                wasInterrupted = true;
            }
        }
        if (wasInterrupted) {
            Thread.currentThread().interrupt();
        }
    }

    private int findIndex(int v) {
        if (v == 0) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < this.inProcessVersions.length; ++i) {
            if ((this.inProcessVersions[i] & 0x3FFFF) != v) continue;
            return i;
        }
        return -1;
    }
}

