/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.impl.matrix;

final class PayloadBits {
    private final int payloadShift;
    private final int[] payloadBits;

    PayloadBits(int matrixLength, int step) {
        int n = 0;
        while (step >> ++n != 0) {
        }
        this.payloadShift = n - 1;
        this.payloadBits = new int[(matrixLength >> this.payloadShift) + 31 >> 5];
    }

    boolean isPayload(int index) {
        int bit = index >> this.payloadShift;
        return (this.payloadBits[bit >> 5] & 1 << bit) != 0;
    }

    boolean markPayload(int index) {
        int bit = index >> this.payloadShift;
        int oldBits = this.payloadBits[bit >> 5];
        int newBits = oldBits | 1 << bit;
        if (newBits == oldBits) {
            return false;
        }
        this.payloadBits[bit >> 5] = newBits;
        return true;
    }

    boolean clearPayload(int index) {
        int bit = index >> this.payloadShift;
        int oldBits = this.payloadBits[bit >> 5];
        int newBits = oldBits & ~(1 << bit);
        if (newBits == oldBits) {
            return false;
        }
        this.payloadBits[bit >> 5] = newBits;
        return true;
    }
}

