/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.impl.matrix;

import com.devexperts.qd.impl.matrix.Hashing;

final class ObjectMatrix {
    private final int magic;
    private final int shift;
    private final Object[] matrix;
    private int overall_size;

    ObjectMatrix(int capacity, int prev_magic) {
        this.magic = Hashing.nextMagic(prev_magic, capacity);
        this.shift = Hashing.getShift(capacity);
        if (2 >= Integer.MAX_VALUE >> 32 - this.shift) {
            throw new IllegalArgumentException("Capacity is too large.");
        }
        this.matrix = new Object[2 << 32 - this.shift];
    }

    private final int getIndex(Object key, int miss_mask) {
        Object test_key;
        int index = key.hashCode() * this.magic >>> this.shift << 1;
        while (!key.equals(test_key = this.matrix[index])) {
            if (test_key == null) {
                if (index > 0) {
                    return index & miss_mask;
                }
                index = this.matrix.length;
            }
            index -= 2;
        }
        return index;
    }

    final Object get(Object key) {
        return this.matrix[this.getIndex(key, 0) + 1];
    }

    final void put(Object key, Object value) {
        int index = this.getIndex(key, -1);
        if (this.matrix[index] == null) {
            this.matrix[index] = key;
            ++this.overall_size;
        }
        this.matrix[index + 1] = value;
    }

    final boolean needRehash() {
        return Hashing.needRehash(this.shift, this.overall_size, this.overall_size, 29);
    }

    final ObjectMatrix rehash() {
        ObjectMatrix dest = new ObjectMatrix(this.overall_size, this.magic);
        int index = this.matrix.length;
        while ((index -= 2) > 0) {
            if (this.matrix[index] == null) continue;
            dest.put(this.matrix[index], this.matrix[index + 1]);
        }
        if (dest.overall_size != this.overall_size) {
            throw new IllegalStateException("Payload integrity corrupted.");
        }
        return dest;
    }
}

