/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.impl.matrix;

import com.devexperts.qd.impl.matrix.Agent;
import com.devexperts.util.LockFreePool;

final class Notification {
    static final int SNAPSHOT_BIT = Integer.MIN_VALUE;
    static final int UPDATE_BIT = 0x40000000;
    static final int NEXT_MASK = 0x3FFFFFFF;
    private static final LockFreePool<Notification> POOL = new LockFreePool(Notification.class.getName(), 2 * Runtime.getRuntime().availableProcessors());
    private Agent[] agents;
    private int[] info;
    private int firstAffected;

    static Notification getInstance() {
        Notification result = POOL.poll();
        return result == null ? new Notification() : result;
    }

    void release() {
        this.clear();
        POOL.offer(this);
    }

    private Notification() {
    }

    void ensureCapacity(int nAgents) {
        int length;
        int n = length = this.agents == null ? 0 : this.agents.length;
        if (nAgents < length) {
            return;
        }
        length = Math.max(16, Math.max(length << 1, nAgents + 1));
        Agent[] oldAgents = this.agents;
        int[] oldInfo = this.info;
        this.agents = new Agent[length];
        this.info = new int[length];
        int i = this.firstAffected;
        while (i > 0) {
            this.agents[i] = oldAgents[i];
            this.info[i] = oldInfo[i];
            i = oldInfo[i] & 0x3FFFFFFF;
        }
    }

    void clear() {
        int i = this.firstAffected;
        while (i > 0) {
            int next = this.info[i] & 0x3FFFFFFF;
            this.agents[i] = null;
            this.info[i] = 0;
            i = next;
        }
        this.firstAffected = 0;
    }

    void add(Agent agent, int bits) {
        int number = agent.number;
        if (this.agents[number] == null) {
            this.info[number] = this.firstAffected | bits;
            this.firstAffected = number;
        } else {
            int n = number;
            this.info[n] = this.info[n] | bits;
        }
        this.agents[number] = agent;
    }

    Agent firstAgent() {
        return this.agents[this.firstAffected];
    }

    Agent nextAgent(Agent agent) {
        return this.agents[this.info[agent.number] & 0x3FFFFFFF];
    }

    int getBits(Agent agent) {
        return this.info[agent.number] & 0xC0000000;
    }
}

