/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.impl.matrix;

import com.devexperts.qd.SymbolReceiver;
import com.devexperts.qd.impl.matrix.AbstractPayloadBitsMatrix;
import com.devexperts.qd.impl.matrix.Hashing;
import com.devexperts.qd.impl.matrix.Mapper;
import com.devexperts.qd.util.SymbolSet;

public class MatrixSymbolSet
extends SymbolSet {
    private static final int LIST_SET_LIMIT = 2;
    private volatile Core core;
    private final boolean unmodifiable;

    public MatrixSymbolSet() {
        this.clearImpl();
        this.unmodifiable = false;
    }

    private MatrixSymbolSet(Core core) {
        this.core = core;
        this.unmodifiable = true;
    }

    @Override
    public int size() {
        return this.core.payloadSize;
    }

    @Override
    public String getSymbol(char[] chars, int offset, int length) {
        return this.core.getMapping().getSymbolIfPresent(chars, offset, length);
    }

    @Override
    public boolean contains(int cipher, String symbol) {
        return this.core.contains(cipher, symbol);
    }

    @Override
    public boolean contains(int cipher, char[] chars, int offset, int length) {
        return this.core.contains(cipher, chars, offset, length);
    }

    @Override
    public boolean add(int cipher, String symbol) {
        this.checkUnmodifiable();
        if (Hashing.needRehash(this.core.shift, this.core.overallSize, this.core.payloadSize, 29)) {
            this.core = this.core.rehash();
        }
        return this.core.add(cipher, symbol);
    }

    @Override
    public boolean add(int cipher, char[] chars, int offset, int length) {
        this.checkUnmodifiable();
        if (Hashing.needRehash(this.core.shift, this.core.overallSize, this.core.payloadSize, 29)) {
            this.core = this.core.rehash();
        }
        return this.core.add(cipher, chars, offset, length);
    }

    @Override
    public boolean remove(int cipher, String symbol) {
        this.checkUnmodifiable();
        boolean result = this.core.remove(cipher, symbol);
        if (Hashing.needRehash(this.core.shift, this.core.overallSize, this.core.payloadSize, 29)) {
            this.core = this.core.rehash();
        }
        return result;
    }

    @Override
    public boolean remove(int cipher, char[] chars, int offset, int length) {
        this.checkUnmodifiable();
        boolean result = this.core.remove(cipher, chars, offset, length);
        if (Hashing.needRehash(this.core.shift, this.core.overallSize, this.core.payloadSize, 29)) {
            this.core = this.core.rehash();
        }
        return result;
    }

    @Override
    public void clear() {
        this.checkUnmodifiable();
        this.clearImpl();
    }

    @Override
    public void examine(SymbolReceiver receiver) {
        this.core.examine(receiver);
    }

    @Override
    public SymbolSet unmodifiable() {
        if (this.unmodifiable) {
            return this;
        }
        if (this.size() <= 2) {
            return new SymbolSet.ListSet(this);
        }
        return new MatrixSymbolSet(this.core);
    }

    private void clearImpl() {
        Mapper mapper = new Mapper(this);
        mapper.incMaxCounter(1);
        this.core = new Core(mapper, 0, 0);
    }

    private void checkUnmodifiable() {
        if (this.unmodifiable) {
            throw new UnsupportedOperationException("unmodifiable");
        }
    }

    private static final class Core
    extends AbstractPayloadBitsMatrix {
        Core(Mapper mapper, int capacity, int prev_magic) {
            super(mapper, 1, 0, capacity, prev_magic);
        }

        Core rehash() {
            Core dest = new Core(this.mapper, this.payloadSize, this.magic);
            this.rehashTo(dest);
            return dest;
        }

        boolean contains(int cipher, String symbol) {
            return this.isPayload(this.getIndex(cipher, symbol));
        }

        boolean contains(int cipher, char[] chars, int offset, int length) {
            return this.isPayload(this.getIndex(cipher, chars, offset, length));
        }

        boolean add(int cipher, String symbol) {
            int key = cipher;
            if ((cipher & 0xC0000000) == 0) {
                if (cipher != 0) {
                    throw new IllegalArgumentException("Reserved cipher.");
                }
                key = this.mapper.addKey(symbol);
            }
            return this.add(key);
        }

        boolean add(int cipher, char[] chars, int offset, int length) {
            int key = cipher;
            if ((cipher & 0xC0000000) == 0) {
                if (cipher != 0) {
                    throw new IllegalArgumentException("Reserved cipher.");
                }
                key = this.mapper.addKey(chars, offset, length);
            }
            return this.add(key);
        }

        private boolean add(int key) {
            int index = this.getIndex(key, -1);
            if (this.matrix[index] == 0) {
                if ((key & 0xC0000000) == 0) {
                    this.mapper.incCounter(key);
                }
                this.matrix[index] = key;
                ++this.overallSize;
            }
            if (this.isPayload(index)) {
                return false;
            }
            this.markPayload(index);
            return true;
        }

        boolean remove(int cipher, String symbol) {
            return this.remove(this.getIndex(cipher, symbol));
        }

        boolean remove(int cipher, char[] chars, int offset, int length) {
            return this.remove(this.getIndex(cipher, chars, offset, length));
        }

        private boolean remove(int index) {
            return this.clearPayload(index);
        }

        void examine(SymbolReceiver receiver) {
            int index = this.matrix.length;
            while (--index >= 0) {
                int key;
                if (!this.isPayload(index)) continue;
                int cipher = key = this.matrix[index];
                String symbol = null;
                if ((key & 0xC0000000) == 0) {
                    cipher = 0;
                    symbol = this.getMapping().getSymbolIfPresent(key);
                    if (symbol == null) continue;
                }
                receiver.receiveSymbol(cipher, symbol);
            }
        }
    }
}

