/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.impl.matrix;

import com.devexperts.qd.impl.matrix.AbstractPayloadBitsMatrix;
import com.devexperts.qd.impl.matrix.Hashing;
import com.devexperts.qd.impl.matrix.Mapper;
import com.devexperts.qd.util.SymbolObjectMap;
import com.devexperts.qd.util.SymbolObjectVisitor;

public class MatrixSymbolObjectMap<T>
extends SymbolObjectMap<T> {
    private volatile Core<T> core;

    public MatrixSymbolObjectMap() {
        this.clear();
    }

    @Override
    public int size() {
        return this.core.payloadSize;
    }

    @Override
    public String getSymbol(char[] chars, int offset, int length) {
        return this.core.getMapping().getSymbolIfPresent(chars, offset, length);
    }

    @Override
    public boolean contains(int cipher, String symbol) {
        return this.core.contains(cipher, symbol);
    }

    @Override
    public boolean contains(int cipher, char[] chars, int offset, int length) {
        return this.core.contains(cipher, chars, offset, length);
    }

    @Override
    public T get(int cipher, String symbol) {
        return this.core.get(cipher, symbol);
    }

    @Override
    public T get(int cipher, char[] chars, int offset, int length) {
        return this.core.get(cipher, chars, offset, length);
    }

    @Override
    public T put(int cipher, String symbol, T value) {
        if (Hashing.needRehash(this.core.shift, this.core.overallSize, this.core.payloadSize, 29)) {
            this.core = this.core.rehash();
        }
        return this.core.put(cipher, symbol, value);
    }

    @Override
    public T put(int cipher, char[] chars, int offset, int length, T value) {
        if (Hashing.needRehash(this.core.shift, this.core.overallSize, this.core.payloadSize, 29)) {
            this.core = this.core.rehash();
        }
        return this.core.put(cipher, chars, offset, length, value);
    }

    @Override
    public T remove(int cipher, String symbol) {
        T old_value = this.core.remove(cipher, symbol);
        if (Hashing.needRehash(this.core.shift, this.core.overallSize, this.core.payloadSize, 29)) {
            this.core = this.core.rehash();
        }
        return old_value;
    }

    @Override
    public T remove(int cipher, char[] chars, int offset, int length) {
        T old_value = this.core.remove(cipher, chars, offset, length);
        if (Hashing.needRehash(this.core.shift, this.core.overallSize, this.core.payloadSize, 29)) {
            this.core = this.core.rehash();
        }
        return old_value;
    }

    @Override
    public void clear() {
        Mapper mapper = new Mapper(this);
        mapper.incMaxCounter(1);
        this.core = new Core(mapper, 0, 0);
    }

    @Override
    public boolean examineEntries(SymbolObjectVisitor<T> visitor) {
        return this.core.examineEntries(visitor);
    }

    private static final class Core<T>
    extends AbstractPayloadBitsMatrix {
        private Core(Mapper mapper, int capacity, int prev_magic) {
            super(mapper, 1, 1, capacity, prev_magic);
        }

        Core<T> rehash() {
            Core<T> dest = new Core<T>(this.mapper, this.payloadSize, this.magic);
            this.rehashTo(dest);
            return dest;
        }

        boolean contains(int cipher, String symbol) {
            return this.isPayload(this.getIndex(cipher, symbol));
        }

        boolean contains(int cipher, char[] chars, int offset, int length) {
            return this.isPayload(this.getIndex(cipher, chars, offset, length));
        }

        T get(int cipher, String symbol) {
            return (T)this.obj_matrix[this.getIndex(cipher, symbol)];
        }

        T get(int cipher, char[] chars, int offset, int length) {
            return (T)this.obj_matrix[this.getIndex(cipher, chars, offset, length)];
        }

        T put(int cipher, String symbol, T value) {
            int key = cipher;
            if ((cipher & 0xC0000000) == 0) {
                if (cipher != 0) {
                    throw new IllegalArgumentException("Reserved cipher.");
                }
                key = this.mapper.addKey(symbol);
            }
            return this.put(key, value);
        }

        T put(int cipher, char[] chars, int offset, int length, T value) {
            int key = cipher;
            if ((cipher & 0xC0000000) == 0) {
                if (cipher != 0) {
                    throw new IllegalArgumentException("Reserved cipher.");
                }
                key = this.mapper.addKey(chars, offset, length);
            }
            return this.put(key, value);
        }

        private T put(int key, T value) {
            int index = this.getIndex(key, -1);
            if (this.matrix[index] == 0) {
                if ((key & 0xC0000000) == 0) {
                    this.mapper.incCounter(key);
                }
                this.matrix[index] = key;
                ++this.overallSize;
            }
            Object old_value = this.obj_matrix[index];
            this.obj_matrix[index] = value;
            this.markPayload(index);
            return (T)old_value;
        }

        T remove(int cipher, String symbol) {
            return this.remove(this.getIndex(cipher, symbol));
        }

        T remove(int cipher, char[] chars, int offset, int length) {
            return this.remove(this.getIndex(cipher, chars, offset, length));
        }

        private T remove(int index) {
            Object old_value = this.obj_matrix[index];
            this.clearPayload(index);
            return (T)old_value;
        }

        boolean examineEntries(SymbolObjectVisitor<T> visitor) {
            int index = this.matrix.length;
            while (--index >= 0) {
                int key;
                if (!this.isPayload(index)) continue;
                int cipher = key = this.matrix[index];
                String symbol = null;
                if ((key & 0xC0000000) == 0) {
                    cipher = 0;
                    symbol = this.getMapping().getSymbolIfPresent(key);
                    if (symbol == null) continue;
                }
                if (!visitor.hasCapacity()) {
                    return true;
                }
                visitor.visitEntry(cipher, symbol, this.obj_matrix[index]);
            }
            return false;
        }
    }
}

