/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.impl.matrix;

import com.devexperts.qd.impl.matrix.CollectorDebug;
import com.devexperts.qd.impl.matrix.FatalError;
import com.devexperts.qd.impl.matrix.Hashing;
import com.devexperts.qd.util.StringUtil;

final class Mapping {
    static final int VALID_KEY = 0x20000000;
    static final int PAYLOAD = -536870912;
    static final int DELETED_CIPHER = 1;
    static final int FIRST_KEY = 0x20000002;
    static final int LAST_KEY = 0x3FFFFFFF;
    private final Object owner;
    private final int magic;
    private final int shift;
    private final int[] keys;
    private final int[] counters;
    private final String[] symbols;
    private final int[] indices;
    private int overall_size;
    private int payload_size;
    private int last_assigned_key = 0x3FFFFFFF;
    private int max_counter;

    Mapping(Object owner, int capacity, int prev_magic) {
        this.owner = owner;
        this.magic = Hashing.nextMagic(prev_magic, capacity);
        this.shift = Hashing.getShift(capacity);
        int length = 1 << 32 - this.shift;
        this.keys = new int[length];
        this.counters = new int[length];
        this.symbols = new String[length];
        this.indices = new int[length];
    }

    private int getIndex(int key, int miss_mask) {
        int test_key;
        int index = key * this.magic >>> this.shift;
        while ((test_key = this.keys[index]) != key) {
            if (test_key == 0) {
                if (index > 0) {
                    return index & miss_mask;
                }
                index = this.keys.length;
            }
            --index;
        }
        return index;
    }

    private int getPosition(String symbol, int miss_mask) {
        int test_index;
        int position;
        for (position = symbol.hashCode() * this.magic >>> this.shift; (test_index = this.indices[position]) != 0 || position == 0; --position) {
            if (symbol.equals(this.symbols[test_index])) {
                return position;
            }
            if (position != 0) continue;
            position = this.indices.length;
        }
        return position & miss_mask;
    }

    private int getPosition(char[] chars, int offset, int length, int miss_mask) {
        int test_index;
        int position;
        int hash = StringUtil.hashCode(chars, offset, length);
        for (position = hash * this.magic >>> this.shift; (test_index = this.indices[position]) != 0 || position == 0; --position) {
            if (StringUtil.equals(this.symbols[test_index], chars, offset, length, hash)) {
                return position;
            }
            if (position != 0) continue;
            position = this.indices.length;
        }
        return position & miss_mask;
    }

    int getKey(String symbol) {
        return this.keys[this.indices[this.getPosition(symbol, 0)]];
    }

    int getKey(char[] chars, int offset, int length) {
        return this.keys[this.indices[this.getPosition(chars, offset, length, 0)]];
    }

    String getSymbolAnyway(int key) {
        return this.symbols[this.getIndex(key, 0)];
    }

    String getSymbol(int key) {
        int index = this.getIndex(key, 0);
        if (index == 0) {
            throw FatalError.fatal(this.owner, "Unknown key=" + key);
        }
        return this.symbols[index];
    }

    String getSymbolIfPresent(int key) {
        return this.symbols[this.getIndex(key, 0)];
    }

    String getSymbolIfPresent(char[] chars, int offset, int length) {
        int test_index;
        int hash = StringUtil.hashCode(chars, offset, length);
        for (int position = hash * this.magic >>> this.shift; (test_index = this.indices[position]) != 0 || position == 0; --position) {
            String symbol = this.symbols[test_index];
            if (StringUtil.equals(symbol, chars, offset, length, hash)) {
                return symbol;
            }
            if (position != 0) continue;
            position = this.indices.length;
        }
        return null;
    }

    int addKey(String symbol) {
        int position = this.getPosition(symbol, -1);
        int key = this.keys[this.indices[position]];
        if (key != 0) {
            return key;
        }
        return this.addKey(symbol, position);
    }

    int addKey(char[] chars, int offset, int length) {
        int position = this.getPosition(chars, offset, length, -1);
        int key = this.keys[this.indices[position]];
        if (key != 0) {
            return key;
        }
        return this.addKey(new String(chars, offset, length), position);
    }

    private int addKey(String symbol, int position) {
        int index;
        int key = this.last_assigned_key;
        do {
            if (++key <= 0x3FFFFFFF) continue;
            key = 0x20000002;
        } while (this.keys[index = this.getIndex(key, -1)] != 0);
        if (this.counters[index] != 0) {
            throw FatalError.fatal(this.owner, "Dirty counter for key=" + key + ", symbol=" + symbol);
        }
        this.keys[index] = key;
        this.symbols[index] = symbol;
        this.indices[position] = index;
        ++this.overall_size;
        this.last_assigned_key = key;
        return this.last_assigned_key;
    }

    void incMaxCounter(int delta) {
        if ((this.max_counter += delta) < 0) {
            throw FatalError.fatal(this.owner, "Maximum counter overflow.");
        }
    }

    void decMaxCounter(int delta) {
        if ((this.max_counter -= delta) < 0) {
            throw FatalError.fatal(this.owner, "Maximum counter underflow.");
        }
        if (this.max_counter == 0 && this.payload_size != 0) {
            throw FatalError.fatal(this.owner, "Excess payload.");
        }
    }

    void incCounter(int key) {
        int index = this.getIndex(key, 0);
        if (index == 0) {
            throw FatalError.fatal(this.owner, "Unknown key=" + key);
        }
        int n = index;
        int n2 = this.counters[n];
        this.counters[n] = n2 + 1;
        int old_counter = n2;
        if (old_counter == 0 && ++this.payload_size > this.overall_size) {
            throw FatalError.fatal(this.owner, "Payload size overflow for key=" + key + ", symbol=" + this.symbols[index]);
        }
        if (old_counter >= this.max_counter) {
            throw FatalError.fatal(this.owner, "Counter overflow for key=" + key + ", symbol=" + this.symbols[index]);
        }
    }

    void decCounter(int key) {
        int index = this.getIndex(key, 0);
        if (index == 0) {
            throw FatalError.fatal(this.owner, "Unknown key=" + key);
        }
        int n = index;
        this.counters[n] = this.counters[n] - 1;
        int new_counter = this.counters[n];
        if (new_counter == 0 && --this.payload_size < 0) {
            throw FatalError.fatal(this.owner, "Payload size underflow for key=" + key + ", symbol=" + this.symbols[index]);
        }
        if (new_counter < 0) {
            throw FatalError.fatal(this.owner, "Counter underflow for key=" + key + ", symbol=" + this.symbols[index]);
        }
        if (new_counter >= this.max_counter) {
            throw FatalError.fatal(this.owner, "Counter overflow for key=" + key + ", symbol=" + this.symbols[index]);
        }
    }

    boolean needRehash() {
        return Hashing.needRehash(this.shift, this.overall_size, this.payload_size, 29);
    }

    Mapping rehash() {
        Mapping dest = new Mapping(this.owner, this.payload_size, this.magic);
        int copied = 0;
        int index = this.keys.length;
        while (--index > 0) {
            int counter = this.counters[index];
            if (counter == 0) continue;
            int key = this.keys[index];
            String symbol = this.symbols[index];
            int dest_index = dest.getIndex(key, -1);
            if (dest.keys[dest_index] != 0) {
                throw FatalError.fatal(this.owner, "Repeated key=" + key + ", symbol=" + this.symbols[index]);
            }
            int dest_position = dest.getPosition(symbol, -1);
            if (dest.indices[dest_position] != 0) {
                throw FatalError.fatal(this.owner, "Repeated symbol=" + this.symbols[index] + ", key=" + key);
            }
            dest.keys[dest_index] = key;
            dest.counters[dest_index] = counter;
            dest.symbols[dest_index] = symbol;
            dest.indices[dest_position] = dest_index;
            ++copied;
        }
        if (copied != this.payload_size) {
            throw FatalError.fatal(this.owner, "Payload integrity corrupted.");
        }
        dest.overall_size = copied;
        dest.payload_size = copied;
        dest.last_assigned_key = this.last_assigned_key;
        dest.max_counter = this.max_counter;
        return dest;
    }

    void verify(CollectorDebug.Log log, Mapping verifyMapping) {
        int index;
        log.info("Verifying mapping...");
        int totalKeys = 0;
        for (index = 0; index < this.keys.length; ++index) {
            int key = this.keys[index];
            String symbol = this.symbols[index];
            int counter = this.counters[index];
            if (key == 0) {
                if (symbol != null) {
                    log.warn("Lost symbol " + symbol + " at " + index);
                }
                if (counter == 0) continue;
                log.warn("Lost counter " + counter + " at " + index);
                continue;
            }
            if (symbol == null && counter != 0) {
                log.warn("Undefined symbol for key " + key + " at " + index);
            }
            ++totalKeys;
            if (counter == 0) continue;
            int verifyKey = verifyMapping.getKey(symbol);
            int verifyIndex = verifyMapping.getIndex(verifyKey, -1);
            int verifyCounter = verifyMapping.counters[verifyIndex];
            if (verifyCounter != counter) {
                log.warn("Unexpected counter " + counter + " (expected counter " + verifyCounter + ") for key " + key + ", symbol " + symbol + " at " + index);
            }
            verifyMapping.counters[verifyIndex] = 0;
        }
        for (index = 0; index < verifyMapping.keys.length; ++index) {
            int verifyCounter = verifyMapping.counters[index];
            if (verifyCounter == 0) continue;
            log.warn("Missing key or zero counter for symbol " + verifyMapping.symbols[index] + " (expected counter " + verifyCounter + ")");
        }
        log.info("Verified " + totalKeys + " keys");
    }
}

