/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.impl.matrix;

import com.devexperts.qd.impl.matrix.management.CollectorCounters;
import com.devexperts.qd.impl.matrix.management.CollectorOperation;

final class LockedThreadState {
    static final int LOCK_NONE = 0;
    static final int LOCK_GLOBAL = 1;
    static final int LOCK_LOCAL = 2;
    static final int LOCK_GLOBAL_AND_LOCAL = 3;
    private int lock_level;
    private CollectorOperation op;
    private long enterNanos;
    private long acquiredNanos;

    LockedThreadState() {
    }

    void checkLevel(int desired_level) {
        if (this.lock_level >= desired_level) {
            throw new IllegalStateException("QD lock is already being held by this thread. Do not reenter QD from inside of data or subscription visitors.");
        }
    }

    void makeAcquired(int desired_level) {
        this.lock_level += desired_level;
    }

    void makeReleased(int desired_level) {
        this.lock_level -= desired_level;
    }

    public void countEnterGlobal(CollectorOperation op) {
        this.op = op;
        this.enterNanos = System.nanoTime();
    }

    void countAcquiredUncontendedGlobal() {
        this.acquiredNanos = this.enterNanos;
    }

    void countAcquiredContendedGlobal() {
        this.acquiredNanos = System.nanoTime();
    }

    void updateCountersGlobal(CollectorCounters counters) {
        if (this.op == null) {
            return;
        }
        long releaseNanos = System.nanoTime();
        counters.countLock(this.op, this.acquiredNanos - this.enterNanos, releaseNanos - this.acquiredNanos);
        this.op = null;
    }
}

