/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.impl.matrix;

import java.util.ArrayDeque;
import java.util.concurrent.Executor;

class LockBoundTaskQueue
implements Runnable {
    private boolean scheduled;
    private ArrayDeque<Object> queue;

    LockBoundTaskQueue() {
    }

    synchronized void add(Executor executor, Runnable task) {
        if (this.queue == null) {
            this.queue = new ArrayDeque();
        }
        this.queue.add(executor);
        this.queue.add(task);
        if (!this.scheduled) {
            this.scheduled = true;
            this.schedule();
        }
    }

    @Override
    public void run() {
        try {
            this.poll().run();
        }
        finally {
            this.finish();
        }
    }

    private synchronized Runnable poll() {
        assert (this.scheduled);
        return (Runnable)this.queue.poll();
    }

    private synchronized void finish() {
        assert (this.scheduled);
        if (this.queue.isEmpty()) {
            this.scheduled = false;
        } else {
            this.schedule();
        }
    }

    private void schedule() {
        ((Executor)this.queue.poll()).execute(this);
    }
}

