/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.impl.matrix;

import com.devexperts.qd.impl.matrix.GlobalLock;
import com.devexperts.qd.impl.matrix.LockedThreadState;
import com.devexperts.qd.impl.matrix.management.CollectorManagement;
import com.devexperts.qd.impl.matrix.management.CollectorOperation;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;

final class LocalLock {
    private final GlobalLock global_lock;
    private final CollectorManagement management;
    private final Sync sync = new Sync();
    private AbstractQueuedSynchronizer.ConditionObject condition;
    private Thread last_owner;
    private CollectorOperation last_op;

    LocalLock(GlobalLock global_lock, CollectorManagement management) {
        this.global_lock = global_lock;
        this.management = management;
    }

    boolean tryLock(CollectorOperation op) {
        LockedThreadState state = this.global_lock.getLockedThreadState();
        state.checkLevel(2);
        boolean success = this.sync.tryAcquire(0);
        if (success) {
            this.makeAcquired(state, op);
        }
        return success;
    }

    void lock(CollectorOperation op) {
        LockedThreadState state = this.global_lock.getLockedThreadState();
        state.checkLevel(2);
        boolean interrupted = false;
        while (true) {
            try {
                while (!this.sync.tryAcquireNanos(0, this.management.getLockWaitLogIntervalNanos())) {
                    this.global_lock.warnTooLong("local", op, this.last_owner, this.last_op);
                }
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            break;
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        this.makeAcquired(state, op);
    }

    private void makeAcquired(LockedThreadState state, CollectorOperation op) {
        this.last_owner = Thread.currentThread();
        this.last_op = op;
        state.makeAcquired(2);
    }

    void unlock() {
        this.sync.release(0);
        LockedThreadState state = this.global_lock.getLockedThreadState();
        state.makeReleased(2);
    }

    void await() throws InterruptedException {
        this.condition().await();
    }

    void signalAll() {
        this.condition().signalAll();
    }

    private AbstractQueuedSynchronizer.ConditionObject condition() {
        if (this.condition == null) {
            this.condition = new AbstractQueuedSynchronizer.ConditionObject(this.sync);
        }
        return this.condition;
    }

    private static final class Sync
    extends AbstractQueuedSynchronizer {
        Sync() {
        }

        @Override
        protected boolean tryAcquire(int arg) {
            if (this.getState() != 0) {
                return false;
            }
            return this.compareAndSetState(0, 1);
        }

        @Override
        protected boolean tryRelease(int releases) {
            if (this.getState() == 0) {
                throw new IllegalStateException("Not locked!!!");
            }
            this.setState(0);
            return true;
        }

        @Override
        protected boolean isHeldExclusively() {
            return true;
        }
    }
}

