/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.impl.matrix;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.DataVisitor;
import com.devexperts.qd.HistorySubscriptionFilter;
import com.devexperts.qd.QDAgent;
import com.devexperts.qd.QDCollector;
import com.devexperts.qd.QDFilter;
import com.devexperts.qd.QDHistory;
import com.devexperts.qd.impl.matrix.Agent;
import com.devexperts.qd.impl.matrix.AgentIterator;
import com.devexperts.qd.impl.matrix.Collector;
import com.devexperts.qd.impl.matrix.Distribution;
import com.devexperts.qd.impl.matrix.Distributor;
import com.devexperts.qd.impl.matrix.FatalError;
import com.devexperts.qd.impl.matrix.HistoryBuffer;
import com.devexperts.qd.impl.matrix.HistoryBufferDebugSink;
import com.devexperts.qd.impl.matrix.ProcessVersionTracker;
import com.devexperts.qd.impl.matrix.SubMatrix;
import com.devexperts.qd.impl.matrix.management.CollectorOperation;
import com.devexperts.qd.kit.RecordOnlyFilter;
import com.devexperts.qd.ng.EventFlag;
import com.devexperts.qd.ng.RecordBuffer;
import com.devexperts.qd.ng.RecordCursor;
import com.devexperts.qd.ng.RecordMode;
import com.devexperts.qd.ng.RecordSink;
import com.devexperts.qd.ng.RecordSource;
import com.devexperts.qd.qtp.MessageType;
import com.devexperts.qd.stats.QDStats;
import com.devexperts.qd.util.LegacyAdapter;
import com.devexperts.util.SystemProperties;
import com.devexperts.util.TimePeriod;

public class History
extends Collector
implements QDHistory {
    static final int RETRIEVE_BATCH_SIZE = SystemProperties.getIntProperty(History.class, "retrieveBatchSize", 100, 1, Integer.MAX_VALUE);
    static final int SNAPSHOT_BATCH_SIZE = SystemProperties.getIntProperty(History.class, "snapshotBatchSize", 10000, 1, Integer.MAX_VALUE);
    static final long STATE_KEEP_TIME = TimePeriod.valueOf(SystemProperties.getProperty(History.class, "stateKeepTime", "60s")).getTime();
    static final boolean FOB_FLAG = SystemProperties.getBooleanProperty("dxscheme.fob", false);
    static final String CONFLATE_FILTER = SystemProperties.getProperty(History.class, "conflateFilter", FOB_FLAG ? "!:Order*" : "*");
    static final int TX_PENDING = EventFlag.TX_PENDING.flag();
    static final int REMOVE_EVENT = EventFlag.REMOVE_EVENT.flag();
    static final int SNAPSHOT_BEGIN = EventFlag.SNAPSHOT_BEGIN.flag();
    static final int SNAPSHOT_END = EventFlag.SNAPSHOT_END.flag();
    static final int SNAPSHOT_SNIP = EventFlag.SNAPSHOT_SNIP.flag();
    static final int SNAPSHOT_MODE = EventFlag.SNAPSHOT_MODE.flag();
    static final int NO_NEXT_AGENT_BUT_STORE_HB = -1;
    static final int PROCESS_VERSION_BITS = 18;
    static final int PENDING_COUNT_BITS = 13;
    static final int SNIP_TIME_SUB_FLAG = Integer.MIN_VALUE;
    static final int PENDING_COUNT_MASK = 2147221504;
    static final int PENDING_COUNT_INC = 262144;
    static final int PROCESS_VERSION_MASK = 262143;
    static final long TX_DIRTY_LAST_RECORD_BIT = Long.MIN_VALUE;
    static final long VIRTUAL_TIME = Long.MAX_VALUE;
    private final HistorySubscriptionFilter historyFilter;
    private final QDFilter conflateFilter;
    private ProcessVersionTracker processVersion = new ProcessVersionTracker();
    private static final int RETRIEVE_NOTHING_ELSE = 0;
    private static final int RETRIEVE_SNAPSHOT = 1;
    private static final int RETRIEVE_UPDATE = 2;
    private static final int RETRIEVE_NO_CAPACITY = 3;

    protected History(QDCollector.Builder<?> builder) {
        this(builder, null);
    }

    protected History(QDCollector.Builder<?> builder, RecordOnlyFilter conflateFilter) {
        super(builder, true, true);
        HistorySubscriptionFilter historyFilter = builder.getHistoryFilter();
        if (historyFilter == null) {
            historyFilter = builder.getScheme().getService(HistorySubscriptionFilter.class);
        }
        this.historyFilter = historyFilter;
        if (conflateFilter == null) {
            conflateFilter = RecordOnlyFilter.valueOf(CONFLATE_FILTER, builder.getScheme());
        }
        this.conflateFilter = conflateFilter;
    }

    @Override
    Agent createAgentInternal(int number, QDAgent.Builder builder, QDStats stats) {
        Agent agent = new Agent(this, number, builder, stats);
        agent.sub = new SubMatrix(this.mapper, 13, builder.getAttachmentStrategy() == null ? 0 : 1, 4, 0, 0, 29, stats.create(QDStats.SType.AGENT_SUB));
        return agent;
    }

    @Override
    RecordMode getAgentBufferMode(Agent agent) {
        RecordMode mode = agent.getMode().withLink();
        if (this.hasEventTimeSequence()) {
            mode = mode.withEventTimeSequence();
        }
        return mode;
    }

    @Override
    protected long trimSubTime(RecordCursor cur) {
        long time = cur.getTime();
        return this.historyFilter == null ? time : Math.max(time, this.historyFilter.getMinHistoryTime(cur.getRecord(), cur.getCipher(), cur.getSymbol()));
    }

    @Override
    protected boolean isSubAllowed(Agent agent, DataRecord record, int cipher, String symbol) {
        if (!record.hasTime()) {
            throw new IllegalArgumentException("Record does not contain time");
        }
        return super.isSubAllowed(agent, record, cipher, symbol);
    }

    private HistoryBuffer getHB(int key, int rid) {
        int tindex = this.total.sub.getIndex(key, rid, 0);
        if (tindex == 0) {
            throw new IllegalStateException("Total entry missed");
        }
        return (HistoryBuffer)this.total.sub.getObj(tindex, 0);
    }

    HistoryBuffer getHB(Agent agent, int aindex) {
        return this.getHB(agent.sub.getInt(aindex + 0), agent.sub.getInt(aindex + 1));
    }

    @Override
    void prepareTotalSubForRehash() {
        if (STATE_KEEP_TIME <= 0L) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        SubMatrix tsub = this.total.sub;
        int tindex = tsub.matrix.length;
        while ((tindex -= tsub.step) >= 0) {
            int rid;
            HistoryBuffer hb;
            if (tsub.getInt(tindex + 2) != -1 || (hb = (HistoryBuffer)tsub.getObj(tindex, 0)) == null || hb.expirationTime > currentTime) continue;
            int key = tsub.getInt(tindex + 0);
            if (this.shouldStoreEverything(key, rid = tsub.getInt(tindex + 1))) {
                hb.expirationTime = Long.MAX_VALUE;
                continue;
            }
            this.removeHistoryBufferAt(rid, tsub, tindex);
            tsub.setInt(tindex + 2, 0);
            tsub.updateRemovedPayload(rid);
        }
    }

    @Override
    void totalRecordAdded(int key, int rid, SubMatrix tsub, int tindex, long time) {
        if (TRACE_LOG) {
            this.log.trace("totalRecordAdded time=" + time);
        }
        super.totalRecordAdded(key, rid, tsub, tindex, time);
        HistoryBuffer hb = (HistoryBuffer)tsub.getObj(tindex, 0);
        if (hb != null && !this.shouldStoreEverything(key, rid)) {
            hb.expirationTime = Long.MAX_VALUE;
            hb.removeOldRecords(time, this.statsStorage, rid);
            if (time < hb.getSnapshotTime() && !hb.isSnipToTime(hb.getSnapshotTime())) {
                hb.resetSnapshot();
            }
        }
    }

    @Override
    boolean totalRecordRemoved(int key, int rid, SubMatrix tsub, int tindex) {
        if (TRACE_LOG) {
            this.log.trace("totalRecordRemoved");
        }
        super.totalRecordRemoved(key, rid, tsub, tindex);
        if (this.shouldStoreEverything(key, rid)) {
            tsub.setInt(tindex + 2, -1);
            return false;
        }
        HistoryBuffer hb = (HistoryBuffer)tsub.getObj(tindex, 0);
        if (hb != null && STATE_KEEP_TIME > 0L) {
            hb.clearAllRecords(this.statsStorage, rid);
            hb.expirationTime = System.currentTimeMillis() + STATE_KEEP_TIME;
            tsub.setInt(tindex + 2, -1);
            return false;
        }
        this.removeHistoryBufferAt(rid, tsub, tindex);
        return true;
    }

    private void removeHistoryBufferAt(int rid, SubMatrix tsub, int tindex) {
        HistoryBuffer hb = (HistoryBuffer)tsub.getObj(tindex, 0);
        if (hb != null) {
            this.statsStorage.updateRemoved(rid, hb.size());
            tsub.setObj(tindex, 0, null);
        }
    }

    @Override
    void enqueueAddedRecord(Agent agent, SubMatrix asub, int aindex) {
        if (TRACE_LOG) {
            this.log.trace("enqueueAddedRecord time_sub=" + asub.getLong(aindex + 7) + " for " + agent);
        }
        this.unlinkFromAgentBufferAndClearTxDirty(agent, asub, aindex);
        long timeSub = asub.getLong(aindex + 7);
        if (agent.hasVoidRecordListener()) {
            asub.setLong(aindex + 9, timeSub);
            return;
        }
        asub.setLong(aindex + 9, Long.MAX_VALUE);
        HistoryBuffer hb = this.getHB(agent, aindex);
        if (hb == null) {
            return;
        }
        int nAvailable = hb.getAvailableCount(Math.max(timeSub, hb.getSnapshotTime()), Long.MAX_VALUE);
        if ((nAvailable > 0 || agent.useHistorySnapshot() && hb.getSnapshotTime() <= timeSub) && agent.snapshotQueue.linkToQueue(agent, aindex, 5, false)) {
            this.subNotifyAccumulator |= 4;
            if (!agent.buffer.hasNext()) {
                this.subNotifyAccumulator |= 8;
            }
        }
    }

    @Override
    void dequeueRemovedRecord(Agent agent, SubMatrix asub, int aindex) {
        if (TRACE_LOG) {
            this.log.trace("dequeueRemovedRecord for " + agent);
        }
        this.unlinkFromAgentBufferAndClearTxDirty(agent, asub, aindex);
        agent.snapshotQueue.cleanupEmptySnapshotHeadForHistory(agent, asub, aindex);
    }

    private void unlinkFromAgentBufferAndClearTxDirty(Agent agent, SubMatrix asub, int aindex) {
        long lastRecordWithBit = asub.getLong(aindex + 11);
        long position = lastRecordWithBit & Long.MAX_VALUE;
        if (agent.buffer.isInBuffer(position)) {
            agent.buffer.unlinkFromPersistentPosition(position);
        }
        asub.setLong(aindex + 11, 0L);
    }

    private void rebaseIfNeeded(Agent agent) {
        if (agent.buffer.needsRebase()) {
            this.rebuildLastRecordAndRebase(agent);
        }
    }

    void rebuildLastRecordAndRebase(Agent agent) {
        RecordCursor cursor;
        if (TRACE_LOG) {
            this.log.trace("rebuildLastRecordAndRebase for " + agent);
        }
        agent.buffer.compact();
        SubMatrix asub = agent.sub;
        for (int aindex = 0; aindex < asub.matrix.length; aindex += asub.step) {
            if (!asub.isPayload(aindex)) continue;
            long lastRecordWithBit = asub.getLong(aindex + 11);
            asub.setLong(aindex + 11, lastRecordWithBit & Long.MIN_VALUE);
        }
        while ((cursor = agent.buffer.next()) != null) {
            int rid;
            int key = this.getKey(cursor.getCipher(), cursor.getSymbol());
            int aindex = asub.getIndex(key, rid = this.getRid(cursor.getRecord()), 0);
            if (!asub.isPayload(aindex)) continue;
            long lastRecordWithBit = asub.getLong(aindex + 11);
            asub.setLong(aindex + 11, cursor.getPosition() + 1L | lastRecordWithBit & Long.MIN_VALUE);
        }
        agent.buffer.rewindAndRebasePosition();
    }

    @Override
    int getNotificationBits(Agent agent) {
        if (!agent.snapshotQueue.isEmpty()) {
            return -1073741824;
        }
        return agent.buffer.hasNext() ? 0x40000000 : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean retrieveDataImpl(Agent agent, RecordSink sink, boolean snapshotOnly) {
        int retrieveStatus;
        if (agent.isClosed()) {
            return false;
        }
        agent.localLock.lock(CollectorOperation.RETRIEVE_DATA);
        try {
            retrieveStatus = this.retrieveDataUpdateLLocked(agent, sink, snapshotOnly);
        }
        finally {
            agent.localLock.unlock();
        }
        switch (retrieveStatus) {
            case 0: {
                return false;
            }
            case 3: {
                return true;
            }
        }
        assert (retrieveStatus == 1);
        this.globalLock.lock(CollectorOperation.RETRIEVE_DATA);
        try {
            boolean bl = this.retrieveDataGLocked(agent, sink, snapshotOnly);
            return bl;
        }
        finally {
            this.globalLock.unlock();
        }
    }

    int retrieveDataUpdateLLocked(Agent agent, RecordSink sink, boolean snapshotOnly) {
        int result;
        if (agent.isClosed()) {
            return 0;
        }
        while ((result = this.checkRetrieveStatus(agent, snapshotOnly)) == 2) {
            if (!this.retrieveUpdateBatchFromLocalAgentBuffer(agent, sink)) continue;
            result = 3;
            break;
        }
        if (result != 1) {
            this.countRetrieval(agent);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean retrieveDataGLocked(Agent agent, RecordSink sink, boolean snapshotOnly) {
        if (agent.isClosed()) {
            return false;
        }
        agent.localLock.lock(CollectorOperation.RETRIEVE_DATA);
        try {
            boolean bl = this.retrieveDataGLLocked(agent, sink, snapshotOnly);
            return bl;
        }
        finally {
            agent.localLock.unlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean retrieveDataGLLocked(Agent agent, RecordSink sink, boolean snapshotOnly) {
        int result;
        block5: while (true) {
            result = this.checkRetrieveStatus(agent, snapshotOnly);
            switch (result) {
                case 0: {
                    break block5;
                }
                case 1: {
                    if (!this.retrieveSnapshotBatchFromGlobalHistoryBuffer(agent, sink)) break;
                    result = 3;
                    break block5;
                }
                case 2: {
                    if (!this.retrieveUpdateBatchFromLocalAgentBuffer(agent, sink)) break;
                    result = 3;
                    break block5;
                }
            }
        }
        this.countRetrieval(agent);
        if (result != 3) return false;
        return true;
    }

    protected int checkRetrieveStatus(Agent agent, boolean snapshotOnly) {
        boolean moreUpdate;
        if (agent.isClosed()) {
            return 0;
        }
        boolean moreSnapshot = !agent.snapshotQueue.isEmpty();
        boolean bl = moreUpdate = !snapshotOnly && agent.buffer.hasNext();
        if (!moreUpdate) {
            agent.nSnapshotRetrieved = 0;
            if (!moreSnapshot) {
                return 0;
            }
        }
        if (!(agent.nSnapshotRetrieved >= RETRIEVE_BATCH_SIZE || !moreSnapshot || this.shallForceRetrieveUpdate() && moreUpdate)) {
            return 1;
        }
        if (!moreSnapshot || this.shallForceRetrieveUpdate()) {
            agent.nSnapshotRetrieved = RETRIEVE_BATCH_SIZE;
        }
        assert (agent.nSnapshotRetrieved > 0 && moreUpdate);
        return 2;
    }

    private boolean retrieveUpdateBatchFromLocalAgentBuffer(Agent agent, RecordSink sink) {
        assert (agent.nSnapshotRetrieved > 0);
        int nRetrieved = agent.buffer.retrieveData(sink, agent.nSnapshotRetrieved);
        boolean retrievedLess = nRetrieved < agent.nSnapshotRetrieved;
        agent.nSnapshotRetrieved -= nRetrieved;
        agent.nRetrieved += nRetrieved;
        this.rebaseIfNeeded(agent);
        if (agent.buffer.unblock()) {
            agent.localLock.signalAll();
        }
        return agent.buffer.hasNext() && retrievedLess;
    }

    private boolean retrieveSnapshotBatchFromGlobalHistoryBuffer(Agent agent, RecordSink sink) {
        assert (agent.nSnapshotRetrieved < RETRIEVE_BATCH_SIZE);
        int nRetrievedWithBit = agent.snapshotQueue.retrieveSnapshotForHistory(this, agent, sink, RETRIEVE_BATCH_SIZE);
        int nRetrieved = nRetrievedWithBit & Integer.MAX_VALUE;
        agent.nSnapshotRetrieved += nRetrieved;
        agent.nRetrieved += nRetrieved;
        return (nRetrievedWithBit & Integer.MIN_VALUE) != 0;
    }

    @Override
    boolean processRecordSourceGLocked(Distributor distributor, Distribution dist, RecordSource source) {
        RecordCursor cursor;
        dist.trackProcessVersion(this.processVersion);
        AgentIterator ait = dist.getAgentIterator();
        RecordBuffer removeBuffer = dist.getRemoveBuffer();
        SubMatrix tsub = this.total.sub;
        while ((cursor = source.next()) != null) {
            boolean endedSnapshot;
            long endRemovePosition;
            DataRecord record = cursor.getRecord();
            int rid = this.getRid(record);
            dist.countIncomingRecord(rid);
            if (!record.hasTime()) continue;
            int cipher = cursor.getCipher();
            String symbol = cursor.getSymbol();
            if (this.storeEverything && !distributor.filter.accept(this.contract, record, cipher, symbol)) continue;
            int key = this.getKey(cipher, symbol);
            int tindex = tsub.getIndex(key, rid, 0);
            boolean shouldStoreEverything = this.shouldStoreEverything(record, cipher, symbol);
            if (shouldStoreEverything) {
                if (key == 0) {
                    key = this.mapper.addKey(symbol);
                }
                if (tindex == 0) {
                    this.rehashAgentIfNeeded(this.total);
                    tsub = this.total.sub;
                    tindex = this.createDummyTotalSubEntry(tsub, rid, key);
                }
            } else if (tsub.getInt(tindex + 2) <= 0) continue;
            long time = cursor.getTime();
            int eventFlags = cursor.getEventFlags();
            if (time == Long.MAX_VALUE && (eventFlags & REMOVE_EVENT) == 0) {
                throw new IllegalArgumentException("History does not support actual records with time == Long.MAX_VALUE");
            }
            HistoryBuffer hb = (HistoryBuffer)tsub.getObj(tindex, 0);
            if (hb == null) {
                hb = new HistoryBuffer(record, this.hasEventTimeSequence());
                tsub.setObj(tindex, 0, hb);
            }
            long timeTotal = tsub.getLong(tindex + 4);
            if (TRACE_LOG) {
                this.log.trace("processRecordSourceGLocked " + History.historyCursorString(cursor) + " timeTotal=" + timeTotal + " state before=" + hb);
            }
            int distFlags = 0;
            if ((eventFlags & (SNAPSHOT_BEGIN | SNAPSHOT_MODE)) != 0) {
                if (hb.enterSnapshotModeFirstTime()) {
                    distFlags |= 0x20000000;
                } else if (!this.conflateFilter.accept(cursor)) {
                    hb.enterSnapshotModeForUnconflated();
                    distFlags |= 0x20000000;
                }
            }
            if (hb.updateExplicitTx((eventFlags & TX_PENDING) != 0)) {
                distFlags |= Integer.MIN_VALUE;
            }
            if ((eventFlags & SNAPSHOT_BEGIN) != 0) {
                hb.snapshotBegin();
            }
            long snipRemovePosition = removeBuffer.getLimit();
            if ((eventFlags & SNAPSHOT_SNIP) != 0 && hb.snapshotSnipAndRemove(time, record, cipher, symbol, removeBuffer, this.statsStorage, rid)) {
                distFlags |= 0x40000000;
            }
            long trimToTime = hb.isWaitingForSnapshotBegin() ? hb.getEverSnapshotTime() : (shouldStoreEverything ? Long.MIN_VALUE : timeTotal);
            long sweepRemovePosition = removeBuffer.getLimit();
            long prevSnapshotTime = hb.getSnapshotTime();
            assert (hb.validTimes() && hb.getEverSnapshotTime() >= trimToTime);
            boolean updatedEverSnapshotTime = hb.updateSnapshotTimeAndSweepRemove(time, trimToTime, record, cipher, symbol, removeBuffer, this.statsStorage, rid);
            if (time >= trimToTime && hb.putRecord(time, cursor, (eventFlags & REMOVE_EVENT) != 0, this.statsStorage, rid)) {
                if (TRACE_LOG) {
                    this.log.trace("updatedRecord");
                }
                distFlags |= 0x10000000;
            }
            if ((endRemovePosition = removeBuffer.getLimit()) != sweepRemovePosition || (distFlags & 0x10000000) != 0 && time < prevSnapshotTime && time > timeTotal && !updatedEverSnapshotTime) {
                hb.updateSweepTxOn();
            }
            boolean bl = endedSnapshot = ((eventFlags & SNAPSHOT_SNIP) != 0 || time <= timeTotal) && hb.snapshotEnd();
            if (endedSnapshot && hb.updateSweepTxOff()) {
                distFlags |= Integer.MIN_VALUE;
            }
            if (distFlags == 0 && snipRemovePosition == endRemovePosition && hb.getSnapshotTime() == prevSnapshotTime) continue;
            if (this.historyFilter != null && (eventFlags & REMOVE_EVENT) == 0 && (distFlags & 0x10000000) != 0) {
                hb.enforceMaxRecordCount(this.historyFilter.getMaxRecordCount(record, cipher, symbol), this.statsStorage, rid);
            }
            if (hb.isSweepTx()) {
                distFlags |= 0x8000000;
            }
            if (hb.wasEverSnapshotMode()) {
                distFlags |= 0x4000000;
            }
            long position = cursor.getPosition();
            boolean shallTerminateBatch = false;
            Agent agent = ait.start(this, tindex);
            while (agent != null) {
                if (!agent.hasVoidRecordListener()) {
                    SubMatrix nsub = agent.sub;
                    int nagent = agent.number;
                    int nindex = ait.currentIndex();
                    long timeSub = nsub.getLong(nindex + 7);
                    int oldDistSize = dist.size();
                    if (!(sweepRemovePosition == endRemovePosition || agent.useHistorySnapshot() && (distFlags & 0x20000000) != 0)) {
                        this.addRemovedToDist(removeBuffer, sweepRemovePosition, endRemovePosition, dist, 0x18000000 | distFlags & 0x4000000, nagent, rid, timeSub);
                    }
                    if (time >= timeSub && (distFlags & 0x50000000) != 0 || agent.useHistorySnapshot() && ((distFlags & 0xA0000000) != 0 || time < prevSnapshotTime && prevSnapshotTime > timeSub && hb.wasEverSnapshotMode())) {
                        dist.add(nagent, position, distFlags, rid);
                    }
                    if (snipRemovePosition != sweepRemovePosition && !agent.useHistorySnapshot()) {
                        this.addRemovedToDist(removeBuffer, snipRemovePosition, sweepRemovePosition, dist, 0x10000000, nagent, rid, timeSub);
                    }
                    if (dist.size() > oldDistSize && this.incAgentSubProcessPendingCountAndMark(dist, nsub, nindex)) {
                        shallTerminateBatch = true;
                    }
                }
                agent = ait.next();
            }
            if (!shallTerminateBatch && dist.hasCapacity()) continue;
            break;
        }
        return cursor != null;
    }

    private int createDummyTotalSubEntry(SubMatrix tsub, int rid, int key) {
        int tindex = tsub.addIndexBegin(key, rid);
        tsub.setInt(tindex + 2, -1);
        tsub.setLong(tindex + 4, Long.MAX_VALUE);
        tsub.addIndexComplete(tindex, key, rid);
        tsub.updateAddedPayload(rid);
        return tindex;
    }

    private void addRemovedToDist(RecordBuffer removeBuffer, long position, long limit, Distribution dist, int distFlags, int nagent, int rid, long timeSub) {
        RecordCursor removeCursor;
        long removeCursorTime;
        assert (position != limit);
        removeBuffer.setPosition(position);
        while ((removeCursorTime = (removeCursor = removeBuffer.next()).getTime()) >= timeSub) {
            dist.add(nagent, removeCursor.getPosition() ^ 0xFFFFFFFFFFFFFFFFL, distFlags, rid);
            if (removeBuffer.getPosition() != limit) continue;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    int processAgentDataUpdate(Distribution dist, RecordSource buffer, Agent agent) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Statement already marked as first in another block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.markFirstStatementInBlock(Op03SimpleStatement.java:461)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Misc.markWholeBlock(Misc.java:251)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.considerAsSimpleIf(ConditionalRewriter.java:673)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.identifyNonjumpingConditionals(ConditionalRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:722)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean incAgentSubProcessPendingCountAndMark(Distribution dist, SubMatrix sub, int index) {
        int curProcessVersion;
        int historySubFlags = sub.getInt(index + 6);
        int prevProcessVersion = historySubFlags & 0x3FFFF;
        if (prevProcessVersion != (curProcessVersion = dist.getCurProcessVersion())) {
            if (prevProcessVersion != 0) {
                this.processVersion.waitWhileInProcess(prevProcessVersion);
            }
            historySubFlags = historySubFlags & Integer.MIN_VALUE | curProcessVersion | 0x40000;
        } else {
            if ((historySubFlags & 0x7FFC0000) == 2147221504) {
                throw FatalError.fatal(this, "PENDING_COUNT overflow");
            }
            historySubFlags += 262144;
        }
        sub.setInt(index + 6, historySubFlags);
        dist.addFlagsToLastAdded(0x2000000);
        return (historySubFlags & 0x7FFC0000) == 2147221504;
    }

    private boolean decAgentSubProcessPendingCountAndClear(Distribution dist, SubMatrix sub, int index, int rid) {
        boolean noMorePending;
        int historySubFlags = sub.getInt(index + 6);
        if ((historySubFlags & 0x3FFFF) != dist.getCurProcessVersion()) {
            throw FatalError.fatal(this, "PROCESS_VERSION is invalid " + (historySubFlags & 0x3FFFF) + " != " + dist.getCurProcessVersion());
        }
        if ((historySubFlags & 0x7FFC0000) == 0) {
            throw FatalError.fatal(this, "PENDING_COUNT is zero");
        }
        boolean bl = noMorePending = ((historySubFlags -= 262144) & 0x7FFC0000) == 0;
        if (noMorePending) {
            historySubFlags &= 0xFFFC0000;
        }
        sub.setInt(index + 6, historySubFlags);
        if (!sub.isPayload(index)) {
            sub.updateRemovedPayload(rid);
        }
        return noMorePending;
    }

    static boolean isAgentSubProcessing(SubMatrix sub, int index) {
        return (sub.getInt(index + 6) & 0x3FFFF) != 0;
    }

    static boolean isAgentSubSnip(SubMatrix sub, int index) {
        return (sub.getInt(index + 6) & Integer.MIN_VALUE) != 0;
    }

    static boolean isAgentTxDirty(long lastRecordWithBit) {
        return (lastRecordWithBit & Long.MIN_VALUE) != 0L;
    }

    static long makeAgentTxDirty(Agent agent, SubMatrix asub, int aindex, long lastRecord) {
        assert (!History.isAgentTxDirty(lastRecord));
        if (agent.buffer.isInBuffer(lastRecord)) {
            agent.buffer.flagFromPersistentPosition(lastRecord, TX_PENDING);
        }
        long lastRecordWithBit = lastRecord | Long.MIN_VALUE;
        asub.setLong(aindex + 11, lastRecordWithBit);
        return lastRecordWithBit;
    }

    static long makeAgentNonTxDirty(SubMatrix asub, int aindex, long lastRecordWithBit) {
        assert (History.isAgentTxDirty(lastRecordWithBit));
        asub.setLong(aindex + 11, lastRecordWithBit &= Long.MAX_VALUE);
        return lastRecordWithBit;
    }

    private void conflateLastRecord(RecordCursor cursor, RecordCursor writeCursor, boolean virtualTime, int eventFlags) {
        writeCursor.setEventFlags(eventFlags);
        if ((eventFlags & REMOVE_EVENT) != 0) {
            writeCursor.clearDataButTime();
            writeCursor.setTimeMark(0);
        } else {
            assert (!virtualTime);
            writeCursor.copyDataFrom(cursor);
            if (writeCursor.getTimeMark() == 0) {
                writeCursor.setTimeMark(cursor.getTimeMark());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getMinAvailableTime(DataRecord record, int cipher, String symbol) {
        if (!record.hasTime()) {
            throw new IllegalArgumentException("Record does not contain time.");
        }
        this.globalLock.lock(CollectorOperation.MIN_TIME);
        try {
            long l = this.getMinAvailableTimeGLocked(record, cipher, symbol);
            return l;
        }
        finally {
            this.globalLock.unlock();
        }
    }

    private long getMinAvailableTimeGLocked(DataRecord record, int cipher, String symbol) {
        int rid;
        SubMatrix tsub = this.total.sub;
        int key = this.getKey(cipher, symbol);
        int tindex = tsub.getIndex(key, rid = this.getRid(record), 0);
        HistoryBuffer hb = (HistoryBuffer)tsub.getObj(tindex, 0);
        if (hb == null) {
            return 0L;
        }
        return hb.getMinAvailableTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getMaxAvailableTime(DataRecord record, int cipher, String symbol) {
        if (!record.hasTime()) {
            throw new IllegalArgumentException("Record does not contain time.");
        }
        this.globalLock.lock(CollectorOperation.MAX_TIME);
        try {
            long l = this.getMaxAvailableTimeGLocked(record, cipher, symbol);
            return l;
        }
        finally {
            this.globalLock.unlock();
        }
    }

    private long getMaxAvailableTimeGLocked(DataRecord record, int cipher, String symbol) {
        int rid;
        SubMatrix tsub = this.total.sub;
        int key = this.getKey(cipher, symbol);
        int tindex = tsub.getIndex(key, rid = this.getRid(record), 0);
        HistoryBuffer hb = (HistoryBuffer)tsub.getObj(tindex, 0);
        if (hb == null) {
            return 0L;
        }
        return hb.getMaxAvailableTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getAvailableCount(DataRecord record, int cipher, String symbol, long startTime, long endTime) {
        if (!record.hasTime()) {
            throw new IllegalArgumentException("Record does not contain time.");
        }
        this.globalLock.lock(CollectorOperation.COUNT_DATA);
        try {
            int n = this.getAvailableCountGLocked(record, cipher, symbol, startTime, endTime);
            return n;
        }
        finally {
            this.globalLock.unlock();
        }
    }

    private int getAvailableCountGLocked(DataRecord record, int cipher, String symbol, long start_time, long end_time) {
        int rid;
        SubMatrix tsub = this.total.sub;
        int key = this.getKey(cipher, symbol);
        int tindex = tsub.getIndex(key, rid = this.getRid(record), 0);
        HistoryBuffer hb = (HistoryBuffer)tsub.getObj(tindex, 0);
        if (hb == null) {
            return 0;
        }
        return hb.getAvailableCount(start_time, end_time);
    }

    @Override
    public boolean examineData(DataRecord record, int cipher, String symbol, long startTime, long endTime, DataVisitor visitor) {
        return this.examineData(record, cipher, symbol, startTime, endTime, LegacyAdapter.of(visitor));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean examineData(DataRecord record, int cipher, String symbol, long startTime, long endTime, RecordSink sink) {
        this.globalLock.lock(CollectorOperation.EXAMINE_DATA);
        try {
            boolean bl = this.examineDataRangeGLocked(record, cipher, symbol, startTime, endTime, sink);
            return bl;
        }
        finally {
            this.globalLock.unlock();
            sink.flush();
        }
    }

    private boolean examineDataRangeGLocked(DataRecord record, int cipher, String symbol, long startTime, long endTime, RecordSink sink) {
        SubMatrix tsub = this.total.sub;
        int tindex = tsub.getIndex(this.getKey(cipher, symbol), this.getRid(record), 0);
        HistoryBuffer hb = (HistoryBuffer)tsub.getObj(tindex, 0);
        return hb != null && (startTime > endTime ? hb.examineDataRangeRTL(record, cipher, symbol, startTime, endTime, sink, this.keeper, null) : hb.examineDataRangeLTR(record, cipher, symbol, startTime, endTime, sink, this.keeper, null));
    }

    @Override
    void examineSubDataInternalByIndex(Agent agent, int aindex, RecordSink sink) {
        SubMatrix asub = agent.sub;
        int key = asub.getInt(aindex + 0);
        int rid = asub.getInt(aindex + 1);
        long time = this.hasTime ? asub.getLong(aindex + 7) : 0L;
        Object attachment = agent.hasAttachmentStrategy() ? asub.getObj(aindex, 0) : null;
        SubMatrix tsub = this.total.sub;
        int tindex = tsub.getIndex(key, rid, 0);
        HistoryBuffer hb = (HistoryBuffer)tsub.getObj(tindex, 0);
        if (hb != null) {
            hb.examineDataSnapshot(this.records[rid], this.getCipher(key), this.getSymbol(key), time, sink, this.keeper, attachment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean examineData(RecordSink sink) {
        SubMatrix tsub = this.total.sub;
        int nExaminedInBatch = 0;
        int tindex = tsub.matrix.length;
        while ((tindex -= tsub.step) >= 0) {
            int nExamined;
            HistoryBuffer hb;
            if (!tsub.isPayload(tindex) || (hb = (HistoryBuffer)tsub.getObj(tindex, 0)) == null) continue;
            this.globalLock.lock(CollectorOperation.EXAMINE_DATA);
            try {
                nExamined = this.examineDataSnapshotGLocked(sink, tsub, tindex, hb);
            }
            finally {
                this.globalLock.unlock();
            }
            if (nExamined < 0) {
                if (nExaminedInBatch - nExamined - 1 > 0) {
                    sink.flush();
                }
                return true;
            }
            if ((nExaminedInBatch += nExamined) < EXAMINE_BATCH_SIZE) continue;
            sink.flush();
            nExaminedInBatch = 0;
        }
        if (nExaminedInBatch > 0) {
            sink.flush();
        }
        return false;
    }

    private int examineDataSnapshotGLocked(RecordSink sink, SubMatrix tsub, int tindex, HistoryBuffer hb) {
        if (hb != tsub.getObj(tindex, 0)) {
            return 0;
        }
        int key = tsub.getInt(tindex + 0);
        int rid = tsub.getInt(tindex + 1);
        int cipher = key;
        String symbol = null;
        if ((key & 0xC0000000) == 0) {
            cipher = 0;
            symbol = tsub.getMapping().getSymbolIfPresent(key);
            if (symbol == null) {
                return 0;
            }
        }
        if (sink instanceof HistoryBufferDebugSink) {
            ((HistoryBufferDebugSink)((Object)sink)).visitHistoryBuffer(this.records[rid], cipher, symbol, tsub.getLong(tindex + 4), hb);
        }
        int examineMethodResult = hb.examineDataSnapshot(this.records[rid], cipher, symbol, Long.MIN_VALUE, sink, this.keeper, null) ? -1 - hb.nExamined : hb.nExamined;
        if (sink instanceof HistoryBufferDebugSink) {
            ((HistoryBufferDebugSink)((Object)sink)).visitDone(this.records[rid], cipher, symbol, examineMethodResult);
        }
        return examineMethodResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean examineDataBySubscription(RecordSink sink, RecordSource sub) {
        RecordCursor subCursor;
        int nExaminedInBatch = 0;
        while ((subCursor = sub.next()) != null) {
            int nExamined;
            DataRecord record = subCursor.getRecord();
            int cipher = subCursor.getCipher();
            String symbol = subCursor.getSymbol();
            long toTime = subCursor.getTime();
            this.globalLock.lock(CollectorOperation.EXAMINE_DATA);
            try {
                nExamined = this.examineDataBySubscriptionGLocked(record, cipher, symbol, toTime, sink);
            }
            finally {
                this.globalLock.unlock();
            }
            if (nExamined < 0) {
                if (nExaminedInBatch - nExamined - 1 > 0) {
                    sink.flush();
                }
                return true;
            }
            if ((nExaminedInBatch += nExamined) < EXAMINE_BATCH_SIZE) continue;
            sink.flush();
            nExaminedInBatch = 0;
        }
        if (nExaminedInBatch > 0) {
            sink.flush();
        }
        return false;
    }

    private int examineDataBySubscriptionGLocked(DataRecord record, int cipher, String symbol, long toTime, RecordSink sink) {
        SubMatrix tsub = this.total.sub;
        int tindex = tsub.getIndex(this.getKey(cipher, symbol), this.getRid(record), 0);
        HistoryBuffer hb = (HistoryBuffer)tsub.getObj(tindex, 0);
        if (hb == null) {
            return 0;
        }
        if (hb.examineDataSnapshot(record, cipher, symbol, toTime, sink, this.keeper, null)) {
            return -1 - hb.nExamined;
        }
        return hb.nExamined;
    }

    @Override
    public void remove(RecordSource source) {
        this.globalLock.lock(CollectorOperation.REMOVE_DATA);
        try {
            this.removeGLocked(source);
        }
        finally {
            this.globalLock.unlock();
        }
    }

    private void removeGLocked(RecordSource source) {
        RecordCursor cur;
        SubMatrix tsub = this.total.sub;
        while ((cur = source.next()) != null) {
            int rid = this.getRid(cur.getRecord());
            int key = this.getKey(cur.getCipher(), cur.getSymbol());
            int tindex = tsub.getIndex(key, rid, 0);
            if (tindex == 0) continue;
            this.removeHistoryBufferAt(rid, tsub, tindex);
            if (tsub.getInt(tindex + 2) != -1) continue;
            tsub.setInt(tindex + 2, 0);
            tsub.updateRemovedPayload(rid);
        }
    }

    public void forceRebase(QDAgent qdAgent) {
        Agent agent = (Agent)qdAgent;
        agent.localLock.lock(CollectorOperation.RETRIEVE_DATA);
        try {
            this.rebuildLastRecordAndRebase(agent);
        }
        finally {
            agent.localLock.unlock();
        }
    }

    protected boolean shallForceRetrieveUpdate() {
        return false;
    }

    private static String historyCursorString(RecordCursor cursor) {
        StringBuilder sb = new StringBuilder();
        sb.append(cursor.getDecodedSymbol());
        sb.append('@').append(cursor.getTime());
        for (int i = 2; i < cursor.getIntCount(); ++i) {
            sb.append(',').append(cursor.getInt(i));
        }
        String flags = EventFlag.formatEventFlags(cursor.getEventFlags(), MessageType.HISTORY_DATA);
        if (!flags.isEmpty()) {
            sb.append(',').append(flags);
        }
        return sb.toString();
    }
}

