/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.impl.matrix;

final class Hashing {
    static final int THRESHOLD_UP = -1431655766;
    static final int THRESHOLD_DOWN = 0x38E38E38;
    static final int THRESHOLD_ALLOC_UP = -1908874354;
    static final int MAX_SHIFT = 29;
    static final int MIN_LENGTH = 8;
    private static final int MAGIC = -1268542259;
    private static int seed = Hashing.getSeed();

    Hashing() {
    }

    static int getShift(int capacity) {
        int shift;
        for (shift = 29; -1908874354 >>> shift < capacity && shift > 1; --shift) {
        }
        if (shift <= 1) {
            throw new IllegalArgumentException("Capacity is too large: " + capacity);
        }
        return shift;
    }

    private static int getSeed() {
        int def = (int)(System.currentTimeMillis() * Runtime.getRuntime().freeMemory());
        try {
            return Integer.getInteger("com.devexperts.qd.impl.matrix.Hashing.seed", def);
        }
        catch (SecurityException e) {
            return def;
        }
    }

    static int nextMagic(int prevMagic) {
        seed = seed * -1268542259 + 1;
        int magic = seed | 1;
        int i = 31;
        while (--i >= 0) {
            int bits = magic >> i & 0xF;
            if (bits != 0 && bits != 15) continue;
            magic ^= 1 << i;
            i -= 2;
        }
        if ((magic & 1) == 0) {
            magic ^= 3;
        }
        i = 25;
        while (--i >= 0) {
            if (((magic ^ prevMagic) >> i & 0xFF) != 0) continue;
            magic ^= (magic ^ magic << 1) & 4 << i ^ 2 << i;
            i -= 6;
        }
        return magic;
    }

    static int nextMagic(int prevMagic, int capacity) {
        int magic = Hashing.nextMagic(prevMagic);
        if (capacity < 32) {
            return magic;
        }
        double eval = Hashing.evaluateContinuedFraction(magic);
        int attempts = 30 - Integer.numberOfLeadingZeros(capacity);
        for (int i = 0; i < attempts; ++i) {
            int m = Hashing.nextMagic(prevMagic);
            double e = Hashing.evaluateContinuedFraction(m);
            if (!(e > eval)) continue;
            magic = m;
            eval = e;
        }
        return magic;
    }

    static double evaluateContinuedFraction(int magic) {
        double x;
        double rem = x = (double)((long)magic & 0xFFFFFFFFL) / 4.294967296E9;
        long p2 = 1L;
        long q2 = 0L;
        long p1 = 0L;
        long q1 = 1L;
        double grade = x;
        for (int i = 1; i <= 20; ++i) {
            rem = 1.0 / rem;
            long a = (long)rem;
            rem -= (double)a;
            long p = a * p1 + p2;
            long q = a * q1 + q2;
            p2 = p1;
            q2 = q1;
            p1 = p;
            q1 = q;
            if ((grade = Math.min(grade, Math.abs(x * (double)q - (double)p) * (double)q)) < 1.0E-6 || rem < 1.0E-6 || q > 0x100000L) break;
        }
        return grade;
    }

    static boolean needRehash(int shift, int overallSize, int payloadSize, int maxShift) {
        return overallSize > -1431655766 >>> shift || payloadSize < 0x38E38E38 >>> shift && shift < maxShift;
    }
}

