/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.impl.matrix;

import com.devexperts.qd.QDLog;
import com.devexperts.qd.impl.matrix.LocalLock;
import com.devexperts.qd.impl.matrix.LockedThreadState;
import com.devexperts.qd.impl.matrix.RecordCursorKeeper;
import com.devexperts.qd.impl.matrix.management.CollectorCounters;
import com.devexperts.qd.impl.matrix.management.CollectorManagement;
import com.devexperts.qd.impl.matrix.management.CollectorOperation;
import com.devexperts.util.SystemProperties;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;

final class GlobalLock {
    private static final boolean TRACE_LOG = GlobalLock.class.desiredAssertionStatus();
    private static final boolean MANAGED = SystemProperties.getBooleanProperty(GlobalLock.class, "Managed", true);
    private final CollectorManagement management;
    private final CollectorCounters counters;
    private final RecordCursorKeeper keeper;
    private final Sync sync = new Sync();
    private Thread last_owner;
    private CollectorOperation last_op;
    private final ThreadLocal<LockedThreadState> state = new ThreadLocal();

    GlobalLock(CollectorManagement management, CollectorCounters counters, RecordCursorKeeper keeper) {
        this.management = management;
        this.counters = counters;
        this.keeper = keeper;
    }

    LocalLock newLocalLock() {
        return new LocalLock(this, this.management);
    }

    LockedThreadState getLockedThreadState() {
        LockedThreadState lts = this.state.get();
        if (lts == null) {
            lts = new LockedThreadState();
            this.state.set(lts);
        }
        return lts;
    }

    void lock(CollectorOperation op) {
        int arg;
        LockedThreadState state = this.getLockedThreadState();
        state.checkLevel(1);
        int n = arg = MANAGED && !this.management.useLockPriority(op) ? 0 : 1;
        if (MANAGED && this.management.useLockCounters(op)) {
            state.countEnterGlobal(op);
            if (this.sync.tryAcquire(arg)) {
                state.countAcquiredUncontendedGlobal();
            } else {
                this.acquireContended(arg, op);
                state.countAcquiredContendedGlobal();
            }
        } else {
            this.sync.acquire(arg);
        }
        this.last_owner = Thread.currentThread();
        this.last_op = op;
        state.makeAcquired(1);
        if (TRACE_LOG) {
            QDLog.log.trace(this.management.getContract() + " global lock locked for " + (Object)((Object)op));
        }
    }

    private void acquireContended(int arg, CollectorOperation op) {
        boolean interrupted = false;
        while (true) {
            try {
                while (!this.sync.tryAcquireNanos(arg, this.management.getLockWaitLogIntervalNanos())) {
                    this.warnTooLong("global", op, this.last_owner, this.last_op);
                }
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            break;
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    void unlock() {
        if (TRACE_LOG) {
            QDLog.log.trace(this.management.getContract() + " global lock unlocking after " + (Object)((Object)this.last_op));
        }
        this.keeper.reset();
        this.sync.release(0);
        LockedThreadState state = this.getLockedThreadState();
        state.makeReleased(1);
        if (MANAGED) {
            state.updateCountersGlobal(this.counters);
        }
    }

    void warnTooLong(String type, CollectorOperation op, Thread lastOwner, CollectorOperation last_op) {
        Exception exception = null;
        if (lastOwner != null) {
            exception = new Exception("Last owner thread was " + lastOwner.getName() + ". Current stack trace is");
            exception.setStackTrace(lastOwner.getStackTrace());
        }
        QDLog.log.warn(String.format("%s %s lock is taking too long to acquire for %s operation. Last operation was %s.", new Object[]{this.management.getContract(), type, op, last_op}), exception);
    }

    private static final class Sync
    extends AbstractQueuedSynchronizer {
        Sync() {
        }

        @Override
        protected boolean tryAcquire(int arg) {
            Thread first;
            if (this.getState() != 0) {
                return false;
            }
            return arg != 0 ? this.compareAndSetState(0, 1) : ((first = this.getFirstQueuedThread()) == null || first == Thread.currentThread()) && this.compareAndSetState(0, 1);
        }

        @Override
        protected boolean tryRelease(int releases) {
            if (this.getState() == 0) {
                throw new IllegalStateException("Not locked!!!");
            }
            this.setState(0);
            return true;
        }
    }
}

