/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.impl.matrix;

import com.devexperts.qd.QDDistributor;
import com.devexperts.qd.impl.matrix.Collector;
import com.devexperts.qd.impl.matrix.CollectorDebug;
import com.devexperts.qd.impl.matrix.Distributor;
import com.devexperts.qd.stats.QDStats;
import com.devexperts.util.ArrayUtil;
import com.devexperts.util.AtomicArrays;

final class DistributorsList {
    private static final int INITIAL_DISTRIBUTORS_SIZE = 8;
    private volatile Distributor[] distributors = new Distributor[8];
    private int last_distributor_index;

    DistributorsList() {
    }

    synchronized QDDistributor createDistributor(Collector collector, QDDistributor.Builder builder) {
        Object[] dist = this.distributors;
        this.last_distributor_index = ArrayUtil.findFreeIndex(dist, this.last_distributor_index, 1);
        int i = this.last_distributor_index;
        if (i >= dist.length) {
            dist = (Distributor[])ArrayUtil.grow(dist, 0);
            this.distributors = dist;
        }
        QDStats distributorStats = collector.stats.create(QDStats.SType.DISTRIBUTOR, builder.getKeyProperties(), builder.getKeyProperties() != null);
        Distributor d = new Distributor(collector, i, builder.getFilter(), distributorStats);
        AtomicArrays.INSTANCE.setVolatileObj(dist, i, d);
        return d;
    }

    synchronized void removeDistributorFromList(int number) {
        AtomicArrays.INSTANCE.setVolatileObj(this.distributors, number, null);
    }

    void notifyAdded() {
        Distributor[] dist = this.distributors;
        int i = dist.length;
        while (--i >= 0) {
            Distributor d = AtomicArrays.INSTANCE.getVolatileObj(dist, i);
            if (d == null) continue;
            d.notifyAdded();
        }
    }

    void notifyRemoved() {
        Distributor[] dist = this.distributors;
        int i = dist.length;
        while (--i >= 0) {
            Distributor d = AtomicArrays.INSTANCE.getVolatileObj(dist, i);
            if (d == null) continue;
            d.notifyRemoved();
        }
    }

    boolean addSub(int key, int rid, long time) {
        Distributor[] dist = this.distributors;
        boolean result = false;
        int i = dist.length;
        while (--i >= 0) {
            Distributor d = AtomicArrays.INSTANCE.getVolatileObj(dist, i);
            if (d == null || !d.addSub(key, rid, time)) continue;
            result = true;
        }
        return result;
    }

    boolean removeSub(int key, int rid) {
        Distributor[] dist = this.distributors;
        boolean result = false;
        int i = dist.length;
        while (--i >= 0) {
            Distributor d = AtomicArrays.INSTANCE.getVolatileObj(dist, i);
            if (d == null || !d.removeSub(key, rid)) continue;
            result = true;
        }
        return result;
    }

    void visitDistributorsSymbols(CollectorDebug.SymbolReferenceVisitor srv) {
        for (Distributor distributor : this.distributors) {
            if (distributor == null) continue;
            distributor.visitDistributorSymbols(srv);
        }
    }
}

