/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.impl.matrix;

import com.devexperts.qd.QDFilter;
import com.devexperts.qd.impl.AbstractDistributor;
import com.devexperts.qd.impl.matrix.Collector;
import com.devexperts.qd.impl.matrix.CollectorDebug;
import com.devexperts.qd.impl.matrix.SubProvider;
import com.devexperts.qd.impl.matrix.SubSnapshot;
import com.devexperts.qd.impl.matrix.management.CollectorOperation;
import com.devexperts.qd.ng.RecordProvider;
import com.devexperts.qd.ng.RecordSource;
import com.devexperts.qd.stats.QDStats;
import java.util.concurrent.atomic.AtomicInteger;

final class Distributor
extends AbstractDistributor {
    private static final int STATE_NEW = 0;
    private static final int STATE_ACTIVE = 1;
    private static final int STATE_CLOSED = 2;
    final Collector collector;
    private final int number;
    final QDFilter filter;
    private final QDStats stats;
    private final SubProvider added_provider;
    private final SubProvider removed_provider;
    private volatile SubSnapshot snapshot;
    private final AtomicInteger state = new AtomicInteger(0);

    Distributor(Collector collector, int number, QDFilter filter, QDStats stats) {
        this.collector = collector;
        this.number = number;
        if (filter == null) {
            throw new NullPointerException();
        }
        this.filter = filter;
        this.stats = stats;
        this.added_provider = new SubProvider(this, true, stats.create(QDStats.SType.DISTRIBUTOR_ASUB));
        this.removed_provider = new SubProvider(this, false, stats.create(QDStats.SType.DISTRIBUTOR_RSUB));
    }

    void initDistributorProviders() {
        if (this.state.get() != 0) {
            return;
        }
        this.collector.globalLock.lock(CollectorOperation.INIT_DISTRIBUTOR);
        try {
            this.initDistributorProvidersGLocked();
        }
        finally {
            this.collector.globalLock.unlock();
        }
    }

    private void initDistributorProvidersGLocked() {
        if (!this.state.compareAndSet(0, 1)) {
            return;
        }
        this.added_provider.init();
        this.removed_provider.init();
        this.snapshot = new SubSnapshot(this.collector.total, this.filter);
    }

    private void closeDistributorProviders() {
        this.collector.globalLock.lock(CollectorOperation.CLOSE_DISTRIBUTOR);
        try {
            this.closeDistributorProvidersGLocked();
        }
        finally {
            this.collector.globalLock.unlock();
        }
    }

    private void closeDistributorProvidersGLocked() {
        this.added_provider.close();
        this.removed_provider.close();
        this.clearSnapshot();
    }

    @Override
    public QDStats getStats() {
        return this.stats;
    }

    boolean addSub(int key, int rid, long time) {
        if (this.state.get() != 1) {
            return false;
        }
        if (this.filter.accept(this.collector.getContract(), this.collector.records[rid], this.collector.getCipher(key), this.collector.getSymbol(key))) {
            this.removed_provider.remove(key, rid);
            return this.added_provider.add(key, rid, time);
        }
        return false;
    }

    boolean removeSub(int key, int rid) {
        if (this.state.get() != 1) {
            return false;
        }
        if (this.filter.accept(this.collector.getContract(), this.collector.records[rid], this.collector.getCipher(key), this.collector.getSymbol(key))) {
            this.added_provider.remove(key, rid);
            return this.removed_provider.add(key, rid, 0L);
        }
        return false;
    }

    boolean isActive() {
        return this.state.get() == 1;
    }

    void notifyAdded() {
        if (this.snapshot == null) {
            this.added_provider.notifyListenerIfQueued();
        }
    }

    void notifyRemoved() {
        if (this.snapshot == null) {
            this.removed_provider.notifyListenerIfQueued();
        }
    }

    SubSnapshot getSnapshot() {
        return this.snapshot;
    }

    void clearSnapshot() {
        this.snapshot = null;
    }

    @Override
    public void process(RecordSource source) {
        this.collector.processData(this, source);
    }

    @Override
    public RecordProvider getAddedRecordProvider() {
        return this.added_provider;
    }

    @Override
    public RecordProvider getRemovedRecordProvider() {
        return this.removed_provider;
    }

    @Override
    public void close() {
        int prevState;
        do {
            if ((prevState = this.state.get()) != 2) continue;
            return;
        } while (!this.state.compareAndSet(prevState, 2));
        this.collector.distributors.removeDistributorFromList(this.number);
        if (prevState == 1) {
            this.closeDistributorProviders();
        }
        this.added_provider.closeStats();
        this.removed_provider.closeStats();
        this.stats.close();
    }

    public String toString() {
        return "distributor #" + this.number + (this.stats != null ? " [" + this.stats.getFullKeyProperties() + "]" : "") + " of " + this.collector;
    }

    void visitDistributorSymbols(CollectorDebug.SymbolReferenceVisitor srv) {
        CollectorDebug.SymbolReferenceLocation srl = new CollectorDebug.SymbolReferenceLocation();
        srl.object = this;
        srl.added = true;
        if (this.added_provider != null) {
            this.added_provider.visitProviderSymbols(srv, srl);
        }
        srl.added = false;
        srl.removed = true;
        if (this.removed_provider != null) {
            this.removed_provider.visitProviderSymbols(srv, srl);
        }
    }
}

