/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.impl.matrix;

import com.devexperts.qd.impl.matrix.Agent;
import com.devexperts.qd.impl.matrix.AgentIterator;
import com.devexperts.qd.impl.matrix.AgentProcessor;
import com.devexperts.qd.impl.matrix.AgentProcessor2;
import com.devexperts.qd.impl.matrix.AgentProcessor3;
import com.devexperts.qd.impl.matrix.AgentProcessor4;
import com.devexperts.qd.impl.matrix.ProcessVersionTracker;
import com.devexperts.qd.impl.matrix.SubMatrix;
import com.devexperts.qd.impl.matrix.management.CollectorCounters;
import com.devexperts.qd.impl.matrix.management.RecordCounters;
import com.devexperts.qd.ng.RecordBuffer;
import com.devexperts.qd.ng.RecordMode;
import com.devexperts.util.ArrayUtil;
import com.devexperts.util.LockFreePool;

final class Distribution {
    private static final int N_AGENT_PROCESSORS = 4;
    private static final LockFreePool<Distribution> POOL = new LockFreePool(Distribution.class.getName(), 2 * Runtime.getRuntime().availableProcessors());
    private static final int NEXT = 0;
    private static final int PAYLOAD1 = 1;
    private static final int PAYLOAD2 = 2;
    private static final int N_INTS = 3;
    static final int TX_END_DIST_FLAG = Integer.MIN_VALUE;
    static final int UPDATED_SNIP_DIST_FLAG = 0x40000000;
    static final int SEND_SNAPSHOT_DIST_FLAG = 0x20000000;
    static final int UPDATED_RECORD_DIST_FLAG = 0x10000000;
    static final int TX_SWEEP_DIST_FLAG = 0x8000000;
    static final int HAD_SNAPSHOT_DIST_FLAG = 0x4000000;
    static final int DEC_PENDING_COUNT_DIST_FLAG = 0x2000000;
    private static final int NEXT_MASK = 0x1FFFFFF;
    private AgentProcessor[] processors;
    private AgentIterator agentIterator;
    private RecordBuffer removeBuffer;
    private ProcessVersionTracker processVersionTracker;
    private int curProcessVersion;
    private Agent[] sharedAgents;
    private Agent[] agents;
    private SubMatrix[] subs;
    private int[] subModCounts;
    private int[] nextAffected;
    private int numberAffected;
    private int prevAffected;
    private int numberBlocked;
    private int firstBlocked;
    private int[] heads;
    private int[] tails;
    private int[] lists = new int[1536];
    private int size = 3;
    private int sizeThreshold;
    RecordCounters mIncomingRecords = new RecordCounters();
    RecordCounters mOutgoingRecords = new RecordCounters();
    int mPrevSize;
    int mSpins;

    static Distribution getInstance() {
        Distribution result = POOL.poll();
        return result == null ? new Distribution() : result;
    }

    private Distribution() {
    }

    void release() {
        POOL.offer(this);
    }

    AgentProcessor getProcessor(int interleave) {
        int index;
        AgentProcessor result;
        AgentProcessor[] processors = this.processors;
        if (processors == null) {
            this.processors = processors = new AgentProcessor[4];
        }
        if ((result = processors[index = Math.max(Math.min(interleave, 4) - 1, 0)]) == null) {
            switch (index) {
                case 0: {
                    result = new AgentProcessor(this);
                    break;
                }
                case 1: {
                    result = new AgentProcessor2(this);
                    break;
                }
                case 2: {
                    result = new AgentProcessor3(this);
                    break;
                }
                case 3: {
                    result = new AgentProcessor4(this);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            processors[index] = result;
        }
        return result;
    }

    AgentIterator getAgentIterator() {
        AgentIterator agentIterator = this.agentIterator;
        if (agentIterator != null) {
            return agentIterator;
        }
        this.agentIterator = new AgentIterator();
        return this.agentIterator;
    }

    RecordBuffer getRemoveBuffer() {
        RecordBuffer removeBuffer = this.removeBuffer;
        if (removeBuffer != null) {
            return removeBuffer;
        }
        this.removeBuffer = new RecordBuffer(RecordMode.HISTORY_SUBSCRIPTION);
        return this.removeBuffer;
    }

    void trackProcessVersion(ProcessVersionTracker processVersionTracker) {
        this.processVersionTracker = processVersionTracker;
        this.curProcessVersion = processVersionTracker.next();
    }

    int getCurProcessVersion() {
        return this.curProcessVersion;
    }

    int getMaxAgentNumber() {
        return this.sharedAgents.length - 1;
    }

    void start(Agent[] shared_agents, int threshold) {
        int length;
        this.sharedAgents = shared_agents;
        this.sizeThreshold = 3 + threshold * 3;
        int n = length = this.agents == null ? 0 : this.agents.length;
        if (shared_agents.length <= length) {
            return;
        }
        length = Math.max(16, Math.max(length << 1, shared_agents.length));
        this.agents = new Agent[length];
        this.subs = new SubMatrix[length];
        this.subModCounts = new int[length];
        this.nextAffected = new int[length];
        this.heads = new int[length];
        this.tails = new int[length];
    }

    void done() {
        if (this.processVersionTracker != null) {
            this.processVersionTracker.done(this.curProcessVersion);
            this.processVersionTracker = null;
        }
        if (this.agentIterator != null) {
            this.agentIterator.clear();
        }
        if (this.removeBuffer != null) {
            this.removeBuffer.clear();
        }
        this.sharedAgents = null;
        int i = this.nextAffected[0];
        while (i > 0) {
            int next = this.nextAffected[i];
            this.clear(i);
            i = next;
        }
        this.nextAffected[0] = 0;
        this.numberAffected = 0;
        this.prevAffected = 0;
        this.numberBlocked = 0;
        this.firstBlocked = 0;
        this.size = 3;
        this.mPrevSize = this.size();
    }

    private void block(int i, int blockIndex) {
        this.nextAffected[i] = this.firstBlocked;
        this.firstBlocked = i;
        ++this.numberBlocked;
        this.heads[i] = blockIndex;
    }

    private void clear(int i) {
        this.agents[i] = null;
        this.subs[i] = null;
        this.nextAffected[i] = 0;
    }

    Agent add(int number, int payload1, int payload2, int flags, int rid) {
        assert ((flags & 0x1FFFFFF) == 0);
        Agent agent = this.agents[number];
        if (agent == null) {
            agent = this.sharedAgents[number];
            if (agent.hasVoidRecordListener()) {
                return agent;
            }
            this.addNewAgent(number, agent);
        }
        if (this.size + 2 >= this.lists.length) {
            this.lists = ArrayUtil.grow(this.lists, 0);
        }
        this.lists[this.size + 0] = flags;
        this.lists[this.size + 1] = payload1;
        this.lists[this.size + 2] = payload2;
        int tail = this.tails[number];
        int tailFlags = this.lists[tail + 0] & 0xFE000000;
        this.lists[tail + 0] = this.size | tailFlags;
        this.tails[number] = this.size;
        this.size += 3;
        this.mOutgoingRecords.count(rid);
        return agent;
    }

    Agent add(int number, long payload, int flags, int rid) {
        return this.add(number, (int)(payload >> 32), (int)payload, flags, rid);
    }

    boolean isDuplicate(int number, long payload) {
        if (this.agents[number] == null) {
            return false;
        }
        int tail = this.tails[number];
        return this.lists[tail + 1] == (int)(payload >> 32) && this.lists[tail + 2] == (int)payload;
    }

    void addFlagsToLastAdded(int flags) {
        assert ((flags & 0x1FFFFFF) == 0);
        int n = this.size - 3 + 0;
        this.lists[n] = this.lists[n] | flags;
    }

    private void addNewAgent(int number, Agent agent) {
        this.agents[number] = agent;
        this.subs[number] = agent.sub;
        this.subModCounts[number] = agent.subModCount;
        this.nextAffected[number] = this.nextAffected[0];
        this.nextAffected[0] = number;
        ++this.numberAffected;
        this.heads[number] = this.size;
        this.tails[number] = 0;
    }

    int size() {
        return this.size / 3 - 1;
    }

    boolean hasCapacity() {
        return this.size < this.sizeThreshold;
    }

    boolean hasBlocked() {
        return this.firstBlocked > 0;
    }

    void enqueueBlocked() {
        if (this.numberAffected != 0) {
            throw new IllegalStateException();
        }
        this.nextAffected[0] = this.firstBlocked;
        this.firstBlocked = 0;
        this.numberAffected = this.numberBlocked;
        this.numberBlocked = 0;
    }

    int numberOfAgents() {
        return this.numberAffected;
    }

    Agent firstAgent() {
        this.prevAffected = 0;
        return this.agents[this.nextAffected[this.prevAffected]];
    }

    Agent nextAgent() {
        this.prevAffected = this.nextAffected[this.prevAffected];
        return this.agents[this.nextAffected[this.prevAffected]];
    }

    Agent removeAgent(int blockIndex) {
        int current = this.nextAffected[this.prevAffected];
        if (current == 0) {
            throw new IllegalStateException("No agent to remove.");
        }
        int next = this.nextAffected[current];
        if (blockIndex > 0) {
            this.block(current, blockIndex);
        } else {
            this.clear(current);
        }
        --this.numberAffected;
        this.nextAffected[this.prevAffected] = next;
        return this.agents[next];
    }

    SubMatrix getSub(Agent agent) {
        return this.subs[agent.number];
    }

    int getSubModCount(Agent agent) {
        return this.subModCounts[agent.number];
    }

    int firstIndex(Agent agent) {
        return this.heads[agent.number];
    }

    int nextIndex(int index) {
        return this.lists[index + 0] & 0x1FFFFFF;
    }

    int getPayload1(int index) {
        return this.lists[index + 1];
    }

    int getPayload2(int index) {
        return this.lists[index + 2];
    }

    long getPayloadLong(int index) {
        return (long)this.getPayload1(index) << 32 | (long)this.getPayload2(index) & 0xFFFFFFFFL;
    }

    int getFlags(int index) {
        return this.lists[index + 0];
    }

    public void prepareCounters(int nRecords) {
        this.mIncomingRecords.prepare(nRecords);
        this.mOutgoingRecords.prepare(nRecords);
        this.mPrevSize = this.size();
    }

    public void countIncomingRecord(int rid) {
        this.mIncomingRecords.count(rid);
    }

    public void countSpins(int mSpins) {
        this.mSpins += mSpins;
    }

    void flushAndClearCounters(CollectorCounters counters) {
        counters.countDistributionAndClear(this.mIncomingRecords, this.mOutgoingRecords, this.mSpins);
        this.mSpins = 0;
    }
}

