/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.impl.matrix;

import com.devexperts.qd.DataScheme;
import com.devexperts.qd.QDAgent;
import com.devexperts.qd.QDLog;
import com.devexperts.qd.impl.matrix.Agent;
import com.devexperts.qd.impl.matrix.Mapper;
import com.devexperts.qd.impl.matrix.SubMatrix;
import com.devexperts.qd.stats.QDStats;
import java.util.Arrays;

public class CollectorDebug {
    public static final Log DEFAULT = new Log();
    public static final Log CONSOLE = new Log(){

        @Override
        public void info(String message) {
            System.out.println(message);
        }

        @Override
        public void warn(String message) {
            System.out.println(message);
        }
    };

    static void visitAgentSymbols(SymbolReferenceVisitor srv, RehashCrashInfo rci, Agent agent) {
        SymbolReferenceLocation srl = new SymbolReferenceLocation();
        srl.object = agent;
        CollectorDebug.visitSubMatrixSymbols(srv, rci != null && agent.number == rci.agent ? rci : null, agent.sub, srl);
    }

    static void visitSubMatrixSymbols(SymbolReferenceVisitor srv, RehashCrashInfo rci, SubMatrix sub, SymbolReferenceLocation srl) {
        srl.index = 0;
        srv.visitSubMatrix(srl);
        if (sub.mapping != null) {
            if (rci != null) {
                srv.visitMessage("Detected rehash in progress", srl);
            } else {
                srv.visitMessage("Detected rehash in progress, but no crash info provided; results may be inconsistent", srl);
            }
        } else if (rci != null) {
            srv.visitMessage("Rehash should be in progress, but not started", srl);
        }
        boolean bl = srl.rehash = rci != null;
        if (sub.matrix == null) {
            return;
        }
        int index = sub.matrix.length;
        while ((index -= sub.step) >= 0) {
            srl.index = index;
            boolean payload = sub.isPayload(index);
            int key = sub.getInt(index + 0);
            int rid = sub.getInt(index + 1);
            if (key == 0) {
                if (payload) {
                    srv.visitMessage("Payload entry with zero key", srl);
                }
                if (rid == 0) continue;
                srv.visitMessage("Record id %d with zero key", srl, rid);
                continue;
            }
            if ((key & 0xE0000000) != 0) {
                srv.visitSymbolReference(key, rid, payload, srl);
            } else {
                srv.visitMessage("Entry with invalid key %d", srl, key);
            }
            if (rci == null || rci.key != key) continue;
            rci = null;
            srl.rehash = false;
            srv.visitMessage("Rehashing crash key %d found", srl, key);
        }
        srl.rehash = false;
    }

    public static String fmtKeyRid(DataScheme scheme, Mapper mapper, int key, int rid) {
        String record = rid >= 0 && rid < scheme.getRecordCount() ? scheme.getRecord(rid).getName() : "(invalid)";
        String symbol = (key & 0xC0000000) != 0 ? scheme.getCodec().decode(key) : mapper.getMapping().getSymbolIfPresent(key);
        return "record #" + rid + " " + record + " key " + key + ", symbol " + symbol;
    }

    public static interface AgentVisitor {
        public void visitAgent(QDAgent var1);
    }

    static class AnalyzeKeyRid
    extends SymbolReferenceVisitor {
        private final Log log;
        private final int key;
        private final int rid;
        private final DataScheme scheme;
        private final Mapper mapper;

        AnalyzeKeyRid(Log log, int key, int rid, DataScheme scheme, Mapper mapper) {
            this.log = log;
            this.key = key;
            this.rid = rid;
            this.scheme = scheme;
            this.mapper = mapper;
        }

        @Override
        public void visitSymbolReference(int key, int rid, boolean payload, SymbolReferenceLocation srl) {
            if (this.key != -1 && this.key != key || this.rid != -1 && this.rid != rid) {
                return;
            }
            this.log.info("Found " + CollectorDebug.fmtKeyRid(this.scheme, this.mapper, key, rid) + " " + (payload ? "payload" : "stale") + " at " + srl);
        }
    }

    static class AgentList {
        static final int NUMBER = 0;
        static final int INDEX = 1;
        static final int STEP = 2;
        int[] list = new int[8];
        int size;

        AgentList() {
        }

        public void add(int agentNumber, int agentIndex) {
            if (this.size + 2 >= this.list.length) {
                this.list = Arrays.copyOf(this.list, 2 * this.list.length);
            }
            this.list[this.size + 0] = agentNumber;
            this.list[this.size + 1] = agentIndex;
            this.size += 2;
        }

        public void clear() {
            this.size = 0;
        }

        public void sort() {
            for (int i = 0; i < this.size; i += 2) {
                for (int j = i + 2; j < this.size; j += 2) {
                    if (this.list[i + 0] <= this.list[j + 0]) continue;
                    this.swap(i, j, 0);
                    this.swap(i, j, 1);
                }
            }
        }

        private void swap(int i, int j, int offset) {
            int tmp = this.list[i + offset];
            this.list[i + offset] = this.list[j + offset];
            this.list[j + offset] = tmp;
        }
    }

    static class VerifySubscription
    extends SymbolReferenceVisitor {
        private final Log log;
        private final DataScheme scheme;
        private final Mapper mapper;
        private SubMatrix allSub;
        int agentNumber;
        int totalSize;

        VerifySubscription(Log log, DataScheme scheme, Mapper mapper) {
            this.log = log;
            this.scheme = scheme;
            this.mapper = mapper;
            this.allSub = new SubMatrix(null, 2, 1, 0, 0, 0, 29, QDStats.VOID);
        }

        @Override
        public void visitSymbolReference(int key, int rid, boolean payload, SymbolReferenceLocation srl) {
            if (payload) {
                this.add(key, rid).add(this.agentNumber, srl.index);
                ++this.totalSize;
            }
        }

        private AgentList add(int key, int rid) {
            int index;
            AgentList list;
            if (this.allSub.needRehash(29)) {
                this.allSub = this.allSub.rehash(29);
            }
            if ((list = (AgentList)this.allSub.getObj(index = this.allSub.addIndex(key, rid), 0)) == null) {
                list = new AgentList();
                this.allSub.setObj(index, 0, list);
            }
            return list;
        }

        public void verifyTotal(SubMatrix totalSub, Agent[] agents) {
            AgentList tmp = new AgentList();
            int index = totalSub.matrix.length;
            while ((index -= totalSub.step) >= 0) {
                int rid;
                if (!totalSub.isPayload(index)) continue;
                int key = totalSub.getInt(index + 0);
                int allSubIndex = this.allSub.getIndex(key, rid = totalSub.getInt(index + 1), 0);
                if (!this.allSub.isPayload(allSubIndex)) {
                    this.log.warn("Found " + this.fmtKeyRid(key, rid) + " in total sub but not in agent subs");
                    continue;
                }
                AgentList list = (AgentList)this.allSub.getObj(allSubIndex, 0);
                int nagent = totalSub.getInt(index + 2);
                int nindex = totalSub.getInt(index + 3);
                tmp.clear();
                while (nagent > 0) {
                    if (nagent >= agents.length) {
                        this.log.warn("Invalid NEXT_AGENT " + nagent + " in total sub chain for " + this.fmtKeyRid(key, rid));
                        break;
                    }
                    Agent next = agents[nagent];
                    if (next == null) {
                        this.log.warn("Missing next agent in total sub chain for record " + rid + " key " + key);
                        break;
                    }
                    tmp.add(nagent, nindex);
                    int nextKey = next.sub.getInt(nindex + 0);
                    int nextRid = next.sub.getInt(nindex + 1);
                    if (nextKey != key || nextRid != rid) {
                        this.log.warn("Reference to wrong " + this.fmtKeyRid(nextKey, nextRid) + " at " + nindex + " of " + next + " in total sub chain for " + this.fmtKeyRid(key, rid));
                        break;
                    }
                    nagent = next.sub.getInt(nindex + 2);
                    nindex = next.sub.getInt(nindex + 3);
                }
                list.sort();
                tmp.sort();
                int i = 0;
                int j = 0;
                while (i < list.size || j < tmp.size) {
                    int nj;
                    int ni = i < list.size ? list.list[i + 0] : Integer.MAX_VALUE;
                    int n = nj = j < tmp.size ? tmp.list[j + 0] : Integer.MAX_VALUE;
                    if (ni < nj) {
                        this.log.warn("Subscription in " + this.fmtAgent(ni, agents) + " at " + list.list[i + 1] + " is missing in total sub chain for " + this.fmtKeyRid(key, rid));
                        i += 2;
                        continue;
                    }
                    if (ni > nj) {
                        this.log.warn("Subscription in " + this.fmtAgent(nj, agents) + " at " + tmp.list[j + 1] + " is not found, but is in total sub chain for " + this.fmtKeyRid(key, rid));
                        j += 2;
                        continue;
                    }
                    i += 2;
                    j += 2;
                }
            }
        }

        private String fmtAgent(int index, Agent[] agents) {
            Agent agent = index >= 0 && index < agents.length ? agents[index] : null;
            return agent != null ? agent.toString() : "agent #" + index;
        }

        private String fmtKeyRid(int key, int rid) {
            return CollectorDebug.fmtKeyRid(this.scheme, this.mapper, key, rid);
        }
    }

    static class VerifySymbolReferences
    extends SymbolReferenceVisitor {
        private final Log log;
        private final DataScheme scheme;
        private final Mapper collectorMapper;
        private final Mapper verifyMapper;
        private int payloadCipher;
        private int payloadKey;
        private int staleCipher;
        private int staleKey;

        VerifySymbolReferences(Log log, DataScheme scheme, Mapper collectorMapper, Mapper verifyMapper) {
            this.log = log;
            this.scheme = scheme;
            this.collectorMapper = collectorMapper;
            this.verifyMapper = verifyMapper;
        }

        void printSummary() {
            this.log.info(" Payload entries: " + this.payloadCipher + " ciphers, " + this.payloadKey + " keys");
            this.log.info("   Stale entries: " + this.staleCipher + " ciphers, " + this.staleKey + " keys");
        }

        @Override
        public void visitSubMatrix(SymbolReferenceLocation srl) {
            this.verifyMapper.incMaxCounter(srl.storage ? 1 : this.scheme.getRecordCount());
        }

        @Override
        public void visitSymbolReference(int key, int rid, boolean payload, SymbolReferenceLocation srl) {
            if ((key & 0xC0000000) != 0) {
                if (payload) {
                    ++this.payloadCipher;
                } else {
                    ++this.staleCipher;
                }
            } else if ((key & 0x20000000) != 0) {
                if (payload) {
                    ++this.payloadKey;
                } else {
                    ++this.staleKey;
                }
                String symbol = this.collectorMapper.getMapping().getSymbolAnyway(key);
                if (symbol != null) {
                    if (payload || !srl.rehash) {
                        int verifyKey = this.verifyMapper.addKey(symbol);
                        this.verifyMapper.incCounter(verifyKey);
                    }
                } else {
                    this.log.warn("Unknown key " + key + " at " + srl);
                }
            } else {
                this.log.warn("Invalid key " + key + " at " + srl);
            }
        }

        @Override
        public void visitMessage(String message, SymbolReferenceLocation srl) {
            this.log.warn(message + " at " + srl);
        }

        @Override
        public void visitMessage(String message, SymbolReferenceLocation srl, int param) {
            this.log.warn(String.format(message, param) + " at " + srl);
        }
    }

    static abstract class SymbolReferenceVisitor {
        SymbolReferenceVisitor() {
        }

        public void visitSymbolReference(int key, int rid, boolean payload, SymbolReferenceLocation srl) {
        }

        public void visitSubMatrix(SymbolReferenceLocation srl) {
        }

        public void visitMessage(String message, SymbolReferenceLocation srl) {
        }

        public void visitMessage(String message, SymbolReferenceLocation srl, int param) {
        }
    }

    static class SymbolReferenceLocation {
        public int index;
        public Object object;
        public boolean added;
        public boolean removed;
        public boolean storage;
        public boolean rehash;

        SymbolReferenceLocation() {
        }

        public String toString() {
            return (this.index > 0 ? this.index + " of " : "") + (this.object != null ? this.object.toString() : "") + (this.added ? " added" : "") + (this.removed ? " removed" : "") + (this.storage ? "storage" : "") + (this.rehash ? " before rehash crash point" : "");
        }
    }

    public static class RehashCrashInfo {
        public int agent;
        public int key;
    }

    static class Log {
        Log() {
        }

        public void info(String message) {
            QDLog.log.info(message);
        }

        public void warn(String message) {
            QDLog.log.warn(message);
        }
    }
}

