/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.impl.matrix;

import com.devexperts.logging.Logging;
import com.devexperts.qd.QDContract;
import com.devexperts.qd.impl.matrix.Agent;
import com.devexperts.qd.impl.matrix.Collector;
import com.devexperts.qd.impl.matrix.History;
import com.devexperts.qd.impl.matrix.HistoryBuffer;
import com.devexperts.qd.impl.matrix.SubMatrix;
import com.devexperts.qd.impl.matrix.Ticker;
import com.devexperts.qd.ng.RecordCursor;
import com.devexperts.qd.ng.RecordSink;

final class AgentQueue {
    private static final Logging log = Logging.getLogging(AgentQueue.class);
    private static final int EOL = Integer.MAX_VALUE;
    private int head = Integer.MAX_VALUE;
    private int tail = Integer.MAX_VALUE;
    static final int RETRIEVE_NO_CAPACITY_BIT = Integer.MIN_VALUE;

    AgentQueue() {
    }

    boolean isEmpty() {
        return this.head == Integer.MAX_VALUE;
    }

    void resetQueueBit(Agent agent, int aindex, int queueOfs) {
        assert (this == agent.snapshotQueue && queueOfs == 5 || this == agent.updateQueue && queueOfs == 6);
        SubMatrix asub = agent.sub;
        asub.setInt(aindex + queueOfs, asub.getInt(aindex + queueOfs) & Integer.MAX_VALUE);
    }

    boolean linkToQueue(Agent agent, int aindex, int queueOfs, boolean setQueueBitOnExisting) {
        assert (this == agent.snapshotQueue && queueOfs == 5 || this == agent.updateQueue && queueOfs == 6);
        SubMatrix asub = agent.sub;
        int val = asub.getInt(aindex + queueOfs);
        if ((val & Integer.MAX_VALUE) != 0) {
            if (setQueueBitOnExisting) {
                asub.setInt(aindex + queueOfs, val | Integer.MIN_VALUE);
            }
            return false;
        }
        boolean first = false;
        int tail = this.tail;
        if (tail == Integer.MAX_VALUE) {
            this.head = aindex;
            first = true;
        } else {
            asub.setInt(tail + queueOfs, aindex | asub.getInt(tail + queueOfs) & Integer.MIN_VALUE);
        }
        asub.setInt(aindex + queueOfs, -1);
        this.tail = aindex;
        return first;
    }

    int retrieveForTicker(Ticker ticker, Agent agent, RecordSink sink, int nRetrieveLimit, int queueOfs) {
        boolean retainSnapshotBit;
        assert (agent.collector == ticker);
        assert (this == agent.snapshotQueue && queueOfs == 5 || this == agent.updateQueue && queueOfs == 6);
        int aindex = this.head;
        assert (aindex != Integer.MAX_VALUE);
        SubMatrix asub = agent.sub;
        int nRetrieved = 0;
        do {
            int update = asub.getInt(aindex + 6);
            boolean bl = retainSnapshotBit = queueOfs == 5 && (update & Integer.MIN_VALUE) == 0;
            if ((update & Integer.MIN_VALUE) == 0) continue;
            if (!sink.hasCapacity()) {
                return nRetrieved | Integer.MIN_VALUE;
            }
            int key = asub.getInt(aindex + 0);
            int rid = asub.getInt(aindex + 1);
            int mark = asub.getInt(aindex + 5);
            if ((mark & Integer.MIN_VALUE) != 0) {
                asub.setInt(aindex + 5, mark & Integer.MAX_VALUE);
                mark = 0;
            }
            Object attachment = agent.hasAttachmentStrategy() ? asub.getObj(aindex, 0) : null;
            asub.setInt(aindex + 6, update & Integer.MAX_VALUE);
            if (!ticker.getRecordData(agent, sink, key, rid, mark, attachment)) continue;
            ++nRetrieved;
        } while ((aindex = this.retrieveNextQueued(agent, aindex, queueOfs, retainSnapshotBit)) != Integer.MAX_VALUE && nRetrieved < nRetrieveLimit);
        return nRetrieved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int retrieveSnapshotForHistory(History history, Agent agent, RecordSink sink, int nRetrieveLimit) {
        assert (agent.collector == history);
        assert (this == agent.snapshotQueue);
        int aindex = this.head;
        assert (aindex != Integer.MAX_VALUE);
        SubMatrix asub = agent.sub;
        int nRetrieved = 0;
        do {
            int nExamined;
            Object attachment;
            long timeKnown = asub.getLong(aindex + 9);
            long timeSub = asub.getLong(aindex + 7);
            assert (timeKnown >= timeSub);
            if (timeKnown == timeSub) {
                aindex = this.retrieveNextQueued(agent, aindex, 5);
                continue;
            }
            HistoryBuffer hb = history.getHB(agent, aindex);
            if (hb == null) {
                aindex = this.retrieveNextQueued(agent, aindex, 5);
                continue;
            }
            long toTime = Math.max(timeSub, hb.getSnapshotTime());
            if (timeKnown <= toTime) {
                aindex = this.retrieveNextQueued(agent, aindex, 5);
                continue;
            }
            int key = asub.getInt(aindex + 0);
            int rid = asub.getInt(aindex + 1);
            Object object = attachment = agent.hasAttachmentStrategy() ? asub.getObj(aindex, 0) : null;
            if ((asub.getInt(aindex + 5) & Integer.MIN_VALUE) != 0) {
                agent.nSnapshotHistoryRem = History.SNAPSHOT_BATCH_SIZE;
            }
            nRetrieveLimit = Math.min(nRetrieveLimit, agent.nSnapshotHistoryRem);
            int snapshotEndFlag = 0;
            if (toTime == timeSub) {
                snapshotEndFlag = History.isAgentSubSnip(asub, aindex) ? History.SNAPSHOT_SNIP : History.SNAPSHOT_END;
            } else if (hb.isSnipToTime(toTime)) {
                snapshotEndFlag = History.SNAPSHOT_SNIP;
            }
            boolean txEnd = false;
            long lastRecordWithBit = asub.getLong(aindex + 11);
            int eventFlags = 0;
            if (agent.useHistorySnapshot() && !History.isAgentTxDirty(lastRecordWithBit) && hb.wasEverSnapshotMode() && History.isAgentSubProcessing(asub, aindex)) {
                if (Collector.TRACE_LOG) {
                    log.trace("makeAgentTxDirty on isAgentSubProcessing in AgentQueue");
                }
                lastRecordWithBit = History.makeAgentTxDirty(agent, asub, aindex, lastRecordWithBit);
            }
            boolean noMoreDirtyOnFullRetrieve = false;
            if (History.isAgentTxDirty(lastRecordWithBit)) {
                eventFlags |= History.TX_PENDING;
                boolean bl = noMoreDirtyOnFullRetrieve = snapshotEndFlag != 0 && !hb.isTx() && !History.isAgentSubProcessing(asub, aindex);
                if (noMoreDirtyOnFullRetrieve && !agent.buffer.isInBuffer(lastRecordWithBit & Long.MAX_VALUE)) {
                    txEnd = true;
                }
            }
            if (timeKnown == Long.MAX_VALUE) {
                eventFlags |= History.SNAPSHOT_BEGIN;
            }
            boolean hasMore = true;
            try {
                hasMore = hb.examineDataRetrieve(history.records[rid], history.getCipher(key), history.getSymbol(key), timeKnown, toTime, sink, history.keeper, attachment, agent.nSnapshotHistoryRem, eventFlags, snapshotEndFlag, txEnd, agent.useHistorySnapshot());
            }
            finally {
                nExamined = hb.nExamined;
                if (nExamined > 0) {
                    if (hb.isSnipToTime(hb.examinedTime)) {
                        hb.examinedTime = timeSub;
                    }
                    asub.setLong(aindex + 9, hb.examinedTime);
                    nRetrieved += nExamined;
                }
                if (noMoreDirtyOnFullRetrieve && !hasMore) {
                    if (Collector.TRACE_LOG) {
                        log.trace("makeAgentNonTxDirty in AgentQueue");
                    }
                    lastRecordWithBit = History.makeAgentNonTxDirty(asub, aindex, lastRecordWithBit);
                    if (!txEnd) {
                        RecordCursor writeCursor = agent.buffer.writeCursorAtPersistentPosition(lastRecordWithBit);
                        writeCursor.setEventFlags(writeCursor.getEventFlags() & ~History.TX_PENDING);
                    }
                } else if (agent.useHistorySnapshot() && !History.isAgentTxDirty(lastRecordWithBit) && nExamined > 0 && hb.isTx()) {
                    if (Collector.TRACE_LOG) {
                        log.trace("makeAgentTxDirty on isTx in AgentQueue");
                    }
                    History.makeAgentTxDirty(agent, asub, aindex, lastRecordWithBit);
                }
            }
            if (hasMore) {
                agent.nSnapshotHistoryRem -= nExamined;
                if (nExamined < nRetrieveLimit) {
                    this.resetQueueBit(agent, aindex, 5);
                    return nRetrieved | Integer.MIN_VALUE;
                }
                if (agent.nSnapshotHistoryRem > 0) {
                    this.resetQueueBit(agent, aindex, 5);
                    return nRetrieved;
                }
                aindex = this.moveToTailAndRetrieveNextQueued(agent, aindex, 5);
                continue;
            }
            aindex = this.retrieveNextQueued(agent, aindex, 5);
        } while (aindex != Integer.MAX_VALUE && nRetrieved < nRetrieveLimit);
        return nRetrieved;
    }

    void cleanupEmptyHeadForTicker(Agent agent, int aindex, int queueOfs) {
        assert (agent.collector.getContract() == QDContract.TICKER);
        assert (this == agent.snapshotQueue && queueOfs == 5 || this == agent.updateQueue && queueOfs == 6);
        if (aindex != this.head) {
            return;
        }
        SubMatrix asub = agent.sub;
        while ((asub.getInt(aindex + 6) & Integer.MIN_VALUE) == 0 && (aindex = this.retrieveNextQueued(agent, aindex, queueOfs)) != Integer.MAX_VALUE) {
        }
    }

    void cleanupEmptySnapshotHeadForHistory(Agent agent, SubMatrix asub, int aindex) {
        long timeSub;
        long timeKnown;
        assert (agent.collector.getContract() == QDContract.HISTORY);
        assert (this == agent.snapshotQueue);
        if (aindex != this.head) {
            return;
        }
        do {
            timeKnown = asub.getLong(aindex + 9);
            timeSub = asub.getLong(aindex + 7);
            assert (timeKnown >= timeSub);
        } while (timeKnown <= timeSub && (aindex = this.retrieveNextQueued(agent, aindex, 5)) != Integer.MAX_VALUE);
    }

    private int retrieveNextQueued(Agent agent, int aindex, int queueOfs) {
        return this.retrieveNextQueued(agent, aindex, queueOfs, false);
    }

    private int retrieveNextQueued(Agent agent, int aindex, int queueOfs, boolean retainQueueBit) {
        SubMatrix asub = agent.sub;
        int state = asub.getInt(aindex + queueOfs);
        int next = state & Integer.MAX_VALUE;
        asub.setInt(aindex + queueOfs, retainQueueBit ? state & Integer.MIN_VALUE : 0);
        this.head = next;
        if (next == Integer.MAX_VALUE) {
            this.tail = Integer.MAX_VALUE;
        }
        return next;
    }

    private int moveToTailAndRetrieveNextQueued(Agent agent, int aindex, int queueOfs) {
        assert (aindex == this.head);
        assert (this == agent.snapshotQueue && queueOfs == 5 || this == agent.updateQueue && queueOfs == 6);
        SubMatrix asub = agent.sub;
        int val = asub.getInt(aindex + queueOfs);
        int next = val & Integer.MAX_VALUE;
        if (next == Integer.MAX_VALUE) {
            asub.setInt(aindex + queueOfs, val | Integer.MIN_VALUE);
            return aindex;
        }
        int tail = this.tail;
        asub.setInt(tail + queueOfs, aindex | asub.getInt(tail + queueOfs) & Integer.MIN_VALUE);
        asub.setInt(aindex + queueOfs, -1);
        this.tail = aindex;
        this.head = next;
        return next;
    }

    int getHead() {
        return this.head;
    }

    void fixQueue(Agent agent, int oindex, SubMatrix osub, int queueOfs) {
        assert (this == agent.snapshotQueue && queueOfs == 5 || this == agent.updateQueue && queueOfs == 6);
        if (oindex == Integer.MAX_VALUE) {
            return;
        }
        SubMatrix asub = agent.sub;
        int lindex = 0;
        do {
            int aindex;
            if ((aindex = asub.getIndex(osub.getInt(oindex + 0), osub.getInt(oindex + 1), 0)) <= 0) continue;
            if (lindex == 0) {
                this.head = aindex;
            } else {
                asub.setInt(lindex + queueOfs, aindex | asub.getInt(lindex + queueOfs) & Integer.MIN_VALUE);
            }
            lindex = aindex;
        } while ((oindex = osub.getInt(oindex + queueOfs) & Integer.MAX_VALUE) != Integer.MAX_VALUE);
        if (lindex == 0) {
            this.tail = Integer.MAX_VALUE;
            this.head = Integer.MAX_VALUE;
        } else {
            this.tail = lindex;
            agent.sub.setInt(lindex + queueOfs, Integer.MAX_VALUE | asub.getInt(lindex + queueOfs) & Integer.MIN_VALUE);
        }
    }
}

