/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.impl.matrix;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.QDAgent;
import com.devexperts.qd.QDLog;
import com.devexperts.qd.impl.matrix.Agent;
import com.devexperts.qd.ng.RecordBuffer;
import com.devexperts.qd.ng.RecordCursor;
import com.devexperts.qd.ng.RecordFilter;
import com.devexperts.qd.ng.RecordSink;
import com.devexperts.qd.stats.QDStats;

class AgentBuffer
implements RecordFilter {
    public static final int BASE = 1;
    private static final int DEFAULT_REBASE_THRESHOLD = 0x3FFFFFFF;
    private final QDStats stats;
    private final Agent agent;
    private final RecordBuffer buffer;
    private long firstPosition = 1L;
    private int maxBufferSize;
    private QDAgent.BufferOverflowStrategy overflowStrategy = QDAgent.BufferOverflowStrategy.DROP_OLDEST;
    private int droppedRecords;
    private int lastLogTime;
    private boolean blocked;
    private int lastDroppedCipher = 0;
    private String lastDroppedSymbol = null;
    private DataRecord lastDroppedRecord = null;

    AgentBuffer(Agent agent) {
        this.agent = agent;
        this.stats = agent.stats.create(QDStats.SType.AGENT_DATA);
        this.buffer = new RecordBuffer(agent.collector.getAgentBufferMode(agent));
        this.maxBufferSize = agent.collector.management.getAgentBufferSizeDefault();
    }

    int getRebaseThreshold() {
        return 0x3FFFFFFF;
    }

    public void setBufferSizeLLocked(int maxBufferSize) {
        this.maxBufferSize = maxBufferSize;
    }

    public void setBufferOverflowStrategyLLocked(QDAgent.BufferOverflowStrategy overflowStrategy) {
        this.overflowStrategy = overflowStrategy;
    }

    public long getPositionBase() {
        return this.buffer.getPosition() - this.firstPosition;
    }

    public void rewindAndRebasePosition() {
        this.buffer.rewind();
        this.firstPosition = 1L;
    }

    public long getLastPersistentPosition() {
        return this.buffer.getLimit() - this.getPositionBase();
    }

    public boolean needsRebase() {
        int rebaseThreshold = this.getRebaseThreshold();
        return (int)this.firstPosition > rebaseThreshold || (int)(this.firstPosition >> 32) > rebaseThreshold;
    }

    public boolean hasNext() {
        return this.buffer.hasNext();
    }

    public RecordCursor next() {
        return this.buffer.next();
    }

    public boolean isInBuffer(long persistentPosition) {
        return persistentPosition >= this.firstPosition;
    }

    public void unlinkFromPersistentPosition(long persistentPosition) {
        assert (this.buffer.getMode().hasLink() && this.isInBuffer(persistentPosition));
        this.buffer.unlinkFrom(persistentPosition + this.getPositionBase());
    }

    public void flagFromPersistentPosition(long persistentPosition, int eventFlags) {
        assert (this.buffer.getMode().hasLink() && this.isInBuffer(persistentPosition));
        this.buffer.flagFrom(persistentPosition + this.getPositionBase(), eventFlags);
    }

    public RecordCursor writeCursorAtPersistentPosition(long persistentPosition) {
        return this.buffer.writeCursorAt(persistentPosition + this.getPositionBase());
    }

    @Override
    public boolean accept(RecordCursor cursor) {
        assert (!this.buffer.getMode().hasLink());
        boolean accepted = this.agent.collector.keepInStreamBufferOnRefilter(this.agent, cursor);
        if (!accepted) {
            this.stats.updateRemoved(cursor.getRecord().getId());
        }
        return accepted;
    }

    public void compact() {
        assert (this.buffer.getMode().hasLink());
        this.buffer.compact();
    }

    public void compactAndRefilter() {
        assert (!this.buffer.getMode().hasLink());
        this.buffer.compact(this);
    }

    public RecordCursor addDataAndCompactIfNeeded(RecordCursor cursor) {
        this.stats.updateAdded(cursor.getRecord().getId());
        return this.buffer.addDataAndCompactIfNeeded(cursor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int retrieveData(RecordSink sink, int nRetrieveLimit) {
        long originalPosition = this.buffer.getPosition();
        try {
            RecordCursor cursor;
            int count = 0;
            while (sink.hasCapacity() && (cursor = this.buffer.next()) != null) {
                try {
                    this.stats.updateRemoved(cursor.getRecord().getId());
                    if (cursor.isUnlinked()) continue;
                    sink.append(cursor);
                    if (++count < nRetrieveLimit) continue;
                    break;
                }
                finally {
                    this.buffer.cleanup(cursor);
                }
            }
            int n = count;
            return n;
        }
        finally {
            this.firstPosition += this.buffer.getPosition() - originalPosition;
        }
    }

    public boolean isBlocked() {
        return this.blocked;
    }

    public boolean unblock() {
        if (this.blocked && !this.buffer.hasNext()) {
            this.blocked = false;
            return true;
        }
        return false;
    }

    public boolean blockNewRecord() {
        if (this.overflowStrategy != QDAgent.BufferOverflowStrategy.BLOCK) {
            return false;
        }
        if (this.buffer.size() < this.maxBufferSize) {
            return false;
        }
        this.blocked = true;
        return true;
    }

    public boolean dropNewRecord(RecordCursor cursor) {
        if (this.overflowStrategy != QDAgent.BufferOverflowStrategy.DROP_NEWEST) {
            return false;
        }
        if (this.buffer.size() < this.maxBufferSize) {
            return false;
        }
        this.makeDropped(cursor);
        return true;
    }

    public void dropOldRecords() {
        if (this.overflowStrategy != QDAgent.BufferOverflowStrategy.DROP_OLDEST) {
            return;
        }
        while (this.buffer.size() > this.maxBufferSize) {
            long original_position = this.buffer.getPosition();
            RecordCursor cursor = this.buffer.next();
            this.makeDropped(cursor);
            this.stats.updateRemoved(cursor.getRecord().getId());
            this.buffer.cleanup(cursor);
            this.firstPosition += this.buffer.getPosition() - original_position;
        }
    }

    private void makeDropped(RecordCursor cursor) {
        this.lastDroppedCipher = cursor.getCipher();
        this.lastDroppedSymbol = cursor.getSymbol();
        this.lastDroppedRecord = cursor.getRecord();
        ++this.droppedRecords;
    }

    public void logDrops(Agent agent) {
        if (this.droppedRecords <= 0) {
            return;
        }
        int time = (int)(System.currentTimeMillis() / 1000L);
        if ((long)(time - this.lastLogTime) < agent.collector.management.getBufferOverflowLogIntervalSeconds()) {
            return;
        }
        this.lastLogTime = time;
        QDLog.log.error(agent.collector.getContract() + " buffer overflow - " + this.droppedRecords + " records skipped for agent [" + agent.getStats().getFullKeyProperties() + "]." + (this.lastDroppedRecord == null ? "" : " Last record was " + agent.collector.scheme.getCodec().decode(this.lastDroppedCipher, this.lastDroppedSymbol) + ":" + this.lastDroppedRecord.getName()));
        agent.collector.counters.countDropped(this.droppedRecords);
        this.droppedRecords = 0;
    }

    public void clear() {
        this.buffer.clear();
    }

    public void closeStats() {
        this.stats.close();
    }
}

