/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.impl.matrix;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.QDAgent;
import com.devexperts.qd.QDContract;
import com.devexperts.qd.QDFilter;
import com.devexperts.qd.impl.AbstractAgent;
import com.devexperts.qd.impl.matrix.AgentBuffer;
import com.devexperts.qd.impl.matrix.AgentQueue;
import com.devexperts.qd.impl.matrix.AgentSnapshotProvider;
import com.devexperts.qd.impl.matrix.Collector;
import com.devexperts.qd.impl.matrix.LocalLock;
import com.devexperts.qd.impl.matrix.RecordCursorKeeper;
import com.devexperts.qd.impl.matrix.SubMatrix;
import com.devexperts.qd.impl.matrix.management.CollectorOperation;
import com.devexperts.qd.ng.RecordListener;
import com.devexperts.qd.ng.RecordProvider;
import com.devexperts.qd.ng.RecordSink;
import com.devexperts.qd.ng.RecordSource;
import com.devexperts.qd.stats.QDStats;

final class Agent
extends AbstractAgent {
    private static final int STATE_ACTIVE = Integer.MAX_VALUE;
    private static final int STATE_CLOSE_COMPLETE = 0;
    final Collector collector;
    final LocalLock localLock;
    final int number;
    final QDFilter filter;
    private final boolean hasVoidRecordListener;
    final QDStats stats;
    private volatile int state = Integer.MAX_VALUE;
    private RecordSink closeSink;
    private volatile AgentSnapshotProvider snapshotProvider;
    private volatile RecordListener snapshotListener;
    private volatile RecordListener dataListener;
    Agent nextClosingAgent;
    volatile SubMatrix sub;
    int subModCount;
    final RecordCursorKeeper retrievalKeeper;
    final AgentQueue snapshotQueue;
    final AgentQueue updateQueue;
    final AgentBuffer buffer;
    int nSnapshotHistoryRem;
    int nSnapshotRetrieved;
    int nRetrieved;
    private int setterCleanupIndex;
    boolean reducedSub;

    Agent(Collector collector, int number, QDAgent.Builder builder, QDStats stats) {
        super(collector.getContract(), builder);
        if (number <= 0) {
            throw new IllegalArgumentException("Agent number must be positive.");
        }
        this.collector = collector;
        this.localLock = collector.globalLock.newLocalLock();
        this.number = number;
        this.filter = builder.getFilter();
        this.hasVoidRecordListener = builder.hasVoidRecordListener();
        this.stats = stats;
        if (this.hasVoidRecordListener) {
            this.dataListener = RecordListener.VOID;
        }
        boolean regular = number > 1;
        boolean ticker = collector.getContract() == QDContract.TICKER;
        boolean stream = collector.getContract() == QDContract.STREAM;
        this.retrievalKeeper = regular && ticker ? new RecordCursorKeeper() : null;
        this.snapshotQueue = regular && !stream ? new AgentQueue() : null;
        this.updateQueue = regular && ticker ? new AgentQueue() : null;
        this.buffer = regular && !ticker ? collector.createAgentBuffer(this) : null;
    }

    @Override
    public QDStats getStats() {
        return this.stats;
    }

    boolean isClosed() {
        return this.state != Integer.MAX_VALUE;
    }

    boolean isCloseCompleted() {
        return this.state == 0;
    }

    void startClose(RecordSink sink) {
        this.state = this.sub.matrix.length;
        this.closeSink = sink;
    }

    boolean performCloseSteps() {
        int index = this.state;
        if (index == 0) {
            return false;
        }
        while ((index -= this.sub.step) > 0) {
            int pagent = this.sub.getInt(index + 4);
            if (pagent == 0) continue;
            if (this.closeSink != null) {
                this.collector.examineSubDataInternalByIndex(this, index, this.closeSink);
            }
            this.collector.removeSubInternalExistingByIndex(this, index, pagent & Integer.MAX_VALUE);
            if (--this.collector.subStepsRemaining > 0) continue;
            this.state = index;
            return true;
        }
        if (this.buffer != null) {
            this.buffer.clear();
        }
        this.sub.close();
        this.collector.mapper.decMaxCounter(this.collector.scheme.getRecordCount());
        this.state = 0;
        return false;
    }

    void startSetterCleanup() {
        this.setterCleanupIndex = this.sub.matrix.length;
    }

    boolean performSetterCleanupSteps() {
        int index = this.setterCleanupIndex;
        if (index == 0) {
            return false;
        }
        while ((index -= this.sub.step) > 0) {
            int pagent = this.sub.getInt(index + 4);
            if (pagent == 0) continue;
            if ((pagent & Integer.MIN_VALUE) != 0) {
                this.sub.setInt(index + 4, pagent & Integer.MAX_VALUE);
                continue;
            }
            this.collector.removeSubInternalExistingByIndex(this, index, pagent);
            if (--this.collector.subStepsRemaining > 0) continue;
            this.setterCleanupIndex = index;
            return true;
        }
        this.setterCleanupIndex = 0;
        return false;
    }

    private boolean setSnapshotListenerLLocked(RecordListener listener) {
        if (this.snapshotListener == listener) {
            return false;
        }
        this.snapshotListener = listener;
        return (this.collector.getNotificationBits(this) & Integer.MIN_VALUE) != 0;
    }

    private boolean setDataListenerLLocked(RecordListener listener) {
        if (this.dataListener == listener) {
            return false;
        }
        this.dataListener = listener;
        return (this.collector.getNotificationBits(this) & 0x40000000) != 0;
    }

    boolean hasVoidRecordListener() {
        return this.dataListener == RecordListener.VOID;
    }

    void notifySnapshotListener() {
        this.notifyListener(this.snapshotListener, this.snapshotProvider);
    }

    void notifyDataListener() {
        this.notifyListener(this.dataListener, this);
    }

    private void notifyListener(RecordListener listener, RecordProvider provider) {
        if (listener != null && !this.isClosed()) {
            try {
                listener.recordsAvailable(provider);
            }
            catch (Throwable t) {
                this.collector.errorHandler.handleDataError(this, t);
            }
        }
    }

    @Override
    public RecordProvider getSnapshotProvider() {
        AgentSnapshotProvider snapshotProvider = this.snapshotProvider;
        if (snapshotProvider != null) {
            return snapshotProvider;
        }
        this.localLock.lock(CollectorOperation.CONFIG_AGENT);
        try {
            RecordProvider recordProvider = this.getSnapshotProviderLLocked();
            return recordProvider;
        }
        finally {
            this.localLock.unlock();
        }
    }

    private RecordProvider getSnapshotProviderLLocked() {
        AgentSnapshotProvider snapshotProvider = this.snapshotProvider;
        if (snapshotProvider != null) {
            return snapshotProvider;
        }
        this.snapshotProvider = new AgentSnapshotProvider(this);
        return this.snapshotProvider;
    }

    @Override
    public boolean retrieve(RecordSink sink) {
        return this.collector.retrieveData(this, sink, false);
    }

    void setSnapshotListener(RecordListener listener) {
        this.localLock.lock(CollectorOperation.CONFIG_AGENT);
        try {
            if (!this.setSnapshotListenerLLocked(listener)) {
                return;
            }
        }
        finally {
            this.localLock.unlock();
        }
        this.notifySnapshotListener();
    }

    @Override
    public void setRecordListener(RecordListener listener) {
        if (this.hasVoidRecordListener && listener != null && listener != RecordListener.VOID) {
            throw new IllegalArgumentException("only VOID listener is allowed");
        }
        this.localLock.lock(CollectorOperation.CONFIG_AGENT);
        try {
            if (!this.setDataListenerLLocked(listener)) {
                return;
            }
        }
        finally {
            this.localLock.unlock();
        }
        this.notifyDataListener();
    }

    @Override
    public void addSubscription(RecordSource source) {
        int res = 0;
        while ((res = this.addSubscriptionPart(source, res)) != 0) {
        }
    }

    @Override
    public int addSubscriptionPart(RecordSource source, int notify) {
        return this.collector.addSubscriptionPart(this, source, notify);
    }

    @Override
    public void removeSubscription(RecordSource source) {
        int res = 0;
        while ((res = this.removeSubscriptionPart(source, res)) != 0) {
        }
    }

    @Override
    public int removeSubscriptionPart(RecordSource source, int notify) {
        return this.collector.removeSubscriptionPart(this, source, notify);
    }

    @Override
    public void setSubscription(RecordSource source) {
        int res = 0;
        while ((res = this.setSubscriptionPart(source, res)) != 0) {
        }
    }

    @Override
    public int setSubscriptionPart(RecordSource source, int notify) {
        return this.collector.setSubscriptionPart(this, source, notify);
    }

    @Override
    public void close() {
        this.closeImpl(null);
    }

    @Override
    public int closePart(int notify) {
        return this.closePartImpl(null, notify);
    }

    @Override
    public void closeAndExamineDataBySubscription(RecordSink sink) {
        if (sink == null) {
            throw new NullPointerException();
        }
        this.closeImpl(sink);
    }

    private void closeImpl(RecordSink sink) {
        int res = 0;
        while ((res = this.closePartImpl(sink, res)) != 0) {
        }
    }

    private int closePartImpl(RecordSink sink, int notify) {
        int res = this.collector.closeAgentPartImpl(this, sink, notify);
        if (res == 0) {
            if (this.buffer != null) {
                this.buffer.closeStats();
            }
            this.sub.closeStats();
            this.stats.close();
        }
        return res;
    }

    @Override
    public boolean isSubscribed(DataRecord record, int cipher, String symbol, long time) {
        return this.collector.isSub(this, record, cipher, symbol, time, 7);
    }

    @Override
    public boolean examineSubscription(RecordSink sink) {
        return this.collector.examineSub(this, sink);
    }

    @Override
    public int getSubscriptionSize() {
        return this.sub.payloadSize;
    }

    @Override
    public void setMaxBufferSize(int maxBufferSize) {
        super.setMaxBufferSize(maxBufferSize);
        if (this.buffer == null) {
            return;
        }
        this.localLock.lock(CollectorOperation.CONFIG_AGENT);
        try {
            this.buffer.setBufferSizeLLocked(maxBufferSize);
        }
        finally {
            this.localLock.unlock();
        }
    }

    @Override
    public void setBufferOverflowStrategy(QDAgent.BufferOverflowStrategy bufferOverflowStrategy) {
        super.setBufferOverflowStrategy(bufferOverflowStrategy);
        if (this.buffer == null) {
            return;
        }
        this.localLock.lock(CollectorOperation.CONFIG_AGENT);
        try {
            this.buffer.setBufferOverflowStrategyLLocked(bufferOverflowStrategy);
        }
        finally {
            this.localLock.unlock();
        }
    }

    public String toString() {
        return "agent #" + this.number + (this.stats != null ? " [" + this.stats.getFullKeyProperties() + "]" : "") + " of " + this.collector;
    }
}

