/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.impl.matrix;

import com.devexperts.qd.impl.matrix.AbstractMatrix;
import com.devexperts.qd.impl.matrix.Mapper;
import com.devexperts.qd.impl.matrix.PayloadBits;

abstract class AbstractPayloadBitsMatrix
extends AbstractMatrix {
    private final PayloadBits payloadBits;

    AbstractPayloadBitsMatrix(Mapper mapper, int step, int obj_step, int capacity, int prev_magic) {
        super(mapper, step, obj_step, capacity, prev_magic, 29);
        this.payloadBits = new PayloadBits(this.matrix.length, step);
    }

    final boolean isPayload(int index) {
        return this.payloadBits.isPayload(index);
    }

    final void markPayload(int index) {
        if (this.payloadBits.markPayload(index)) {
            this.updateAddedPayload();
        }
    }

    final boolean clearPayload(int index) {
        if (this.payloadBits.clearPayload(index)) {
            this.updateRemovedPayload(index);
            return true;
        }
        return false;
    }

    final void rehashTo(AbstractPayloadBitsMatrix dest) {
        this.startRehash();
        int index = this.matrix.length;
        while ((index -= this.step) > 0) {
            int key = this.matrix[index];
            if (key == 0) continue;
            if (this.isPayload(index)) {
                int destIndex = dest.getIndex(key, -1);
                if (dest.matrix[destIndex] != 0) {
                    throw new IllegalStateException("Repeated key.");
                }
                dest.matrix[destIndex] = key;
                ++dest.overallSize;
                int i = this.step;
                while (--i > 0) {
                    dest.matrix[destIndex + i] = this.matrix[index + i];
                }
                if (this.obj_step != 0) {
                    int obj_index = index / this.step * this.obj_step;
                    int dest_obj_index = destIndex / this.step * this.obj_step;
                    int i2 = this.obj_step;
                    while (--i2 >= 0) {
                        dest.obj_matrix[dest_obj_index + i2] = this.obj_matrix[obj_index + i2];
                    }
                }
                dest.markPayload(destIndex);
                continue;
            }
            if ((key & 0xC0000000) != 0) continue;
            this.mapper.decCounter(key);
        }
        if (dest.overallSize != this.payloadSize || dest.payloadSize != this.payloadSize) {
            throw new IllegalStateException("Payload integrity corrupted.");
        }
    }

    private void updateAddedPayload() {
        if (++this.payloadSize > this.overallSize) {
            throw new IllegalStateException("Payload size overflow.");
        }
    }

    private void updateRemovedPayload(int index) {
        if (--this.payloadSize < 0) {
            throw new IllegalStateException("Payload size underflow.");
        }
        this.clearIndexData(index, 1);
    }
}

