/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.impl.matrix;

import com.devexperts.qd.impl.matrix.Hashing;
import com.devexperts.qd.impl.matrix.Mapper;
import com.devexperts.qd.impl.matrix.Mapping;
import com.devexperts.util.AtomicArrays;

abstract class AbstractMatrix {
    protected final Mapper mapper;
    protected volatile Mapping mapping;
    protected final int magic;
    protected final int shift;
    protected final int step;
    protected final int[] matrix;
    protected final int obj_step;
    protected final Object[] obj_matrix;
    protected int overallSize;
    protected int payloadSize;

    AbstractMatrix(Mapper mapper, int step, int obj_step, int capacity, int prev_magic, int max_shift) {
        this.mapper = mapper;
        this.magic = Hashing.nextMagic(prev_magic, capacity);
        this.shift = Math.min(max_shift, Hashing.getShift(capacity));
        this.step = step;
        if (step >= Integer.MAX_VALUE >> 32 - this.shift) {
            throw new IllegalArgumentException("Step and capacity are too large.");
        }
        this.matrix = new int[step << 32 - this.shift];
        this.obj_step = obj_step;
        if (obj_step >= Integer.MAX_VALUE >> 32 - this.shift) {
            throw new IllegalArgumentException("Obj_step and capacity are too large.");
        }
        this.obj_matrix = obj_step == 0 ? null : new Object[obj_step << 32 - this.shift];
    }

    final Mapping getMapping() {
        Mapping mapping = this.mapper.getMapping();
        if (this.mapping != null) {
            mapping = this.mapping;
        }
        return mapping;
    }

    final boolean needRehash(int max_shift) {
        return Hashing.needRehash(this.shift, this.overallSize, this.payloadSize, max_shift);
    }

    final void startRehash() {
        if (this.mapping != null) {
            throw new IllegalStateException("Repeated rehash.");
        }
        if (this.mapper != null) {
            this.mapping = this.mapper.getMapping();
        }
    }

    final int getInt(int index) {
        return this.matrix[index];
    }

    final void setInt(int index, int value) {
        this.matrix[index] = value;
    }

    final int getVolatileInt(int index) {
        return AtomicArrays.INSTANCE.getVolatileInt(this.matrix, index);
    }

    final void setVolatileInt(int index, int value) {
        AtomicArrays.INSTANCE.setVolatileInt(this.matrix, index, value);
    }

    final boolean compareAndSetInt(int index, int expect, int update) {
        return AtomicArrays.INSTANCE.compareAndSetInt(this.matrix, index, expect, update);
    }

    final long getLong(int index) {
        return (long)this.matrix[index] << 32 | (long)this.matrix[index + 1] & 0xFFFFFFFFL;
    }

    final void setLong(int index, long value) {
        this.matrix[index] = (int)(value >>> 32);
        this.matrix[index + 1] = (int)value;
    }

    final Object getObj(int index, int offset) {
        return this.obj_matrix[index / this.step * this.obj_step + offset];
    }

    final void setObj(int index, int offset, Object value) {
        this.obj_matrix[index / this.step * this.obj_step + offset] = value;
    }

    final int getIndex(int key, int miss_mask) {
        int test_key;
        int index = (key * this.magic >>> this.shift) * this.step;
        while ((test_key = this.matrix[index]) != key) {
            if (test_key == 0) {
                if (index > 0) {
                    return index & miss_mask;
                }
                index = this.matrix.length;
            }
            index -= this.step;
        }
        return index;
    }

    final int getIndex(int cipher, String symbol) {
        int key = cipher;
        if ((cipher & 0xC0000000) == 0) {
            if (cipher != 0) {
                throw new IllegalArgumentException("Reserved cipher.");
            }
            key = this.getMapping().getKey(symbol);
        }
        return this.getIndex(key, 0);
    }

    final int getIndex(int cipher, char[] chars, int offset, int length) {
        int key = cipher;
        if ((cipher & 0xC0000000) == 0) {
            if (cipher != 0) {
                throw new IllegalArgumentException("Reserved cipher.");
            }
            key = this.getMapping().getKey(chars, offset, length);
        }
        return this.getIndex(key, 0);
    }

    final void clearIndexData(int index, int leaveInts) {
        int i = this.step;
        while (--i >= leaveInts) {
            this.matrix[index + i] = 0;
        }
        if (this.obj_step != 0) {
            int obj_index = index / this.step * this.obj_step;
            int i2 = this.obj_step;
            while (--i2 >= 0) {
                this.obj_matrix[obj_index + i2] = null;
            }
        }
    }
}

